/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.formula.api.util.aviator;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.AbstractVariadicFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.NormalDistribution;

public class AviatorCustomFunction {
    /*
     * WARNING - void declaration
     */
    private static List<Object> expandArgs(Map<String, Object> env, AviatorObject ... args) {
        void var5_7;
        ArrayList<Object> argList = new ArrayList<Object>();
        AviatorObject[] aviatorObjectArray = args;
        int n = aviatorObjectArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            AviatorObject arg = aviatorObjectArray[var5_7];
            if (arg.getValue(env) != null) {
                argList.add(arg.getValue(env));
            }
            ++var5_7;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object e : argList) {
            if (e instanceof Collection) {
                result.addAll((Collection)e);
                continue;
            }
            result.add(e);
        }
        return result;
    }

    private static AviatorObject cdf(Number x, Number mean, Number sigma) {
        NormalDistribution normalDistribution = new NormalDistribution(mean.doubleValue(), sigma.doubleValue());
        double cdfValue = normalDistribution.cumulativeProbability(x.doubleValue());
        return new AviatorDecimal((Number)cdfValue);
    }

    private static AviatorObject pdf(Number x, Number mean, Number sigma) {
        Calc part1 = new Calc(1).divide(new Calc().sqrt(Math.PI * 2).multiply(sigma));
        Calc part2 = new Calc(new Calc(x).sub(mean)).pow(2);
        Calc part3 = new Calc(sigma).pow(2).multiply(2);
        Calc part4 = new Calc(Math.E).pow(new Calc(-1).multiply(part2.divide(part3)));
        return new AviatorDecimal((Number)part1.multiply(part4).getValue());
    }

    public static class ProbitFunction
    extends AbstractFunction {
        public ProbitFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject call(Map<String, Object> env, AviatorObject arg) {
            Number p = FunctionUtils.getNumberValue((AviatorObject)arg, env);
            double pVal = p.doubleValue();
            return new AviatorDecimal((Number)this.inverseNormalCDF(pVal));
        }

        private double inverseNormalCDF(double p) {
            if (p <= 0.0) {
                return -5.0;
            }
            if (p >= 1.0) {
                return 5.0;
            }
            double y = 2.0 * p - 1.0;
            return Math.sqrt(2.0) * this.inverseErf(y);
        }

        private double inverseErf(double y) {
            double a = 0.147;
            double lnTerm = Math.log(1.0 - y * y);
            double sqrtTerm = Math.sqrt(Math.PI * Math.PI * lnTerm * lnTerm / 4.0 + a * lnTerm);
            return (Math.PI * lnTerm / 2.0 + sqrtTerm) / (-2.0 * a);
        }

        public String getName() {
            return "PROBIT";
        }
    }

    public static class normdistFunction
    extends AbstractVariadicFunction {
        public normdistFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.size() != 4) {
                return null;
            }
            Number x = (Number)numberList.get(0);
            Number mean = (Number)numberList.get(1);
            Number sigma = (Number)numberList.get(2);
            boolean cumulative = (Boolean)numberList.get(3);
            if (sigma.doubleValue() <= 0.0) {
                return null;
            }
            return cumulative ? AviatorCustomFunction.cdf(x, mean, sigma) : AviatorCustomFunction.pdf(x, mean, sigma);
        }

        public String getName() {
            return "NORMDIST";
        }
    }

    public static class roundFixFunction
    extends AbstractVariadicFunction {
        public roundFixFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.size() != 2) {
                return null;
            }
            BigDecimal number = Calc.getBigDecimal(numberList.get(0));
            Integer decimalPlaces = (Integer)numberList.get(1);
            return new AviatorDecimal((Number)number.setScale((int)decimalPlaces, RoundingMode.HALF_UP));
        }

        public String getName() {
            return "ROUND_FIX";
        }
    }

    public static class normsdistFunction
    extends AbstractFunction {
        public normsdistFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject call(Map<String, Object> env, AviatorObject arg) {
            Number z = (Number)FunctionUtils.getJavaObject((AviatorObject)arg, env);
            Calc part1 = new Calc(1).divide(new Calc().sqrt(Math.PI * 2));
            Calc part2 = new Calc(Math.E).pow(new Calc(-1).multiply(z).multiply(z).divide(2));
            return new AviatorDecimal((Number)part1.multiply(part2).getValue());
        }

        public String getName() {
            return "NORMSDIST";
        }
    }

    public static class StandardizeFunction
    extends AbstractVariadicFunction {
        public StandardizeFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.size() != 3) {
                return null;
            }
            Number x = (Number)numberList.get(0);
            Number mean = (Number)numberList.get(1);
            Number standardDev = (Number)numberList.get(2);
            if (standardDev.doubleValue() <= 0.0) {
                return null;
            }
            return new AviatorDecimal((Number)new Calc(x).sub(mean).divide(standardDev).getValue());
        }

        public String getName() {
            return "STANDARDIZE";
        }
    }

    public static class RangeFunction
    extends AbstractVariadicFunction {
        public RangeFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.isEmpty()) {
                return null;
            }
            double max = numberList.stream().mapToDouble(number -> Calc.getBigDecimal(number).doubleValue()).max().orElse(0.0);
            double min = numberList.stream().mapToDouble(number -> Calc.getBigDecimal(number).doubleValue()).min().orElse(0.0);
            return new AviatorDecimal((Number)new Calc(max).sub(min).getValue());
        }

        public String getName() {
            return "RANGE";
        }
    }

    public static class StdevFunction
    extends AbstractVariadicFunction {
        public StdevFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.isEmpty()) {
                return null;
            }
            int length = numberList.size();
            Calc mean = new Calc().add(numberList).divide(length);
            Calc standardDeviation = new Calc();
            for (Object num : numberList) {
                standardDeviation.add(new Calc(num).sub(mean).pow(2));
            }
            return new AviatorDecimal((Number)new Calc().sqrt(standardDeviation.divide(length - 1)).getValue());
        }

        public String getName() {
            return "STDEV";
        }
    }

    public static class SqrtFunction
    extends AbstractFunction {
        public SqrtFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject call(Map<String, Object> env, AviatorObject arg) {
            Object number = FunctionUtils.getJavaObject((AviatorObject)arg, env);
            return new AviatorDecimal((Number)new Calc().sqrt(number).getValue());
        }

        public String getName() {
            return "SQRT";
        }
    }

    public static class LnFunction
    extends AbstractVariadicFunction {
        public LnFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            ArrayList<Object> numberList = new ArrayList<Object>();
            for (AviatorObject arg : args) {
                if (arg.getValue(env) == null) continue;
                numberList.add(arg.getValue(env));
            }
            if (numberList.size() != 1) {
                return null;
            }
            double number = Double.parseDouble(numberList.get(0).toString());
            return new AviatorDecimal((Number)Math.log(number));
        }

        public String getName() {
            return "LN";
        }
    }

    public static class LogFunction
    extends AbstractVariadicFunction {
        public LogFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            ArrayList<Object> numberList = new ArrayList<Object>();
            for (AviatorObject arg : args) {
                if (arg.getValue(env) == null) continue;
                numberList.add(arg.getValue(env));
            }
            if (numberList.size() != 2) {
                return null;
            }
            return new AviatorDecimal((Number)new Calc().log(numberList).getValue());
        }

        public String getName() {
            return "LOG";
        }
    }

    public static class EPowFunction
    extends AbstractVariadicFunction {
        public EPowFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            ArrayList<Object> numberList = new ArrayList<Object>();
            numberList.add(Math.E);
            for (AviatorObject arg : args) {
                if (arg.getValue(env) == null) continue;
                numberList.add(arg.getValue(env));
            }
            if (numberList.size() != 2) {
                return null;
            }
            return new AviatorDecimal((Number)new Calc().pow(numberList).getValue());
        }

        public String getName() {
            return "EXP";
        }
    }

    public static class PowFunction
    extends AbstractVariadicFunction {
        public PowFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            ArrayList<Object> numberList = new ArrayList<Object>();
            for (AviatorObject arg : args) {
                if (arg.getValue(env) == null) continue;
                numberList.add(arg.getValue(env));
            }
            if (numberList.size() != 2) {
                return null;
            }
            return new AviatorDecimal((Number)new Calc().pow(numberList).getValue());
        }

        public String getName() {
            return "POWER";
        }
    }

    public static class ModFunction
    extends AbstractVariadicFunction {
        public ModFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            ArrayList<Object> numberList = new ArrayList<Object>();
            for (AviatorObject arg : args) {
                if (arg.getValue(env) == null) continue;
                numberList.add(arg.getValue(env));
            }
            if (numberList.size() != 2) {
                return null;
            }
            return new AviatorDecimal((Number)new Calc().mod(numberList).getValue());
        }

        public String getName() {
            return "MOD";
        }
    }

    public static class AbsFunction
    extends AbstractFunction {
        public AbsFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject call(Map<String, Object> env, AviatorObject arg) {
            Object number = FunctionUtils.getJavaObject((AviatorObject)arg, env);
            return new AviatorDecimal((Number)new Calc().abs(number).getValue());
        }

        public String getName() {
            return "ABS";
        }
    }

    public static class AvgFunction
    extends AbstractVariadicFunction {
        public AvgFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.isEmpty()) {
                return null;
            }
            return new AviatorDecimal((Number)new Calc().add(numberList).divide(numberList.size()).getValue());
        }

        public String getName() {
            return "AVERAGE";
        }
    }

    public static class MinFunction
    extends AbstractVariadicFunction {
        public MinFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.isEmpty()) {
                return null;
            }
            return new AviatorDecimal((Number)numberList.stream().mapToDouble(number -> Calc.getBigDecimal(number).doubleValue()).min().orElse(0.0));
        }

        public String getName() {
            return "MIN";
        }
    }

    public static class MaxFunction
    extends AbstractVariadicFunction {
        public MaxFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.isEmpty()) {
                return null;
            }
            return new AviatorDecimal((Number)numberList.stream().mapToDouble(number -> Calc.getBigDecimal(number).doubleValue()).max().orElse(0.0));
        }

        public String getName() {
            return "MAX";
        }
    }

    public static class SumOfSquaresFunction
    extends AbstractVariadicFunction {
        public SumOfSquaresFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.isEmpty()) {
                return null;
            }
            Calc result = new Calc();
            for (Object number : numberList) {
                result.add(new Calc(number).pow(2).getValue());
            }
            return new AviatorDecimal((Number)result.getValue());
        }

        public String getName() {
            return "SUM_OF_SQUARES";
        }
    }

    public static class SumFunction
    extends AbstractVariadicFunction {
        public SumFunction(AviatorCustomFunction aviatorCustomFunction) {
        }

        public AviatorObject variadicCall(Map<String, Object> env, AviatorObject ... args) {
            List numberList = AviatorCustomFunction.expandArgs(env, args);
            if (numberList.isEmpty()) {
                return null;
            }
            return new AviatorDecimal((Number)new Calc().add(numberList).getValue());
        }

        public String getName() {
            return "SUM";
        }
    }
}

