/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.organUserRoleSelector.service.impl;

import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.spc.adapter.organUser.service.IOrganUserApiService;
import com.jxdinfo.spc.adapter.organUser.vo.OrganUserTreeApiVo;
import com.jxdinfo.spc.core.common.service.ISpcBaseConfigService;
import com.jxdinfo.spc.core.common.vo.SpcBaseConfigVo;
import com.jxdinfo.spc.core.organUserRoleSelector.constant.OrganUserConstant;
import com.jxdinfo.spc.core.organUserRoleSelector.dao.OrganUserMapper;
import com.jxdinfo.spc.core.organUserRoleSelector.service.IOrganUserService;
import com.jxdinfo.spc.core.organUserRoleSelector.vo.RoleTreeVo;
import com.jxdinfo.spc.core.organUserRoleSelector.vo.SearchOrganUserRoleVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrganUserServiceImpl
implements IOrganUserService {
    @Resource
    private IOrganUserApiService organUserApiService;
    @Resource
    private OrganUserMapper organUserMapper;
    @Resource
    private ISpcBaseConfigService configService;
    @Resource
    private ISysRolesExternalService sysRolesExternalService;

    @Override
    public List<OrganUserTreeApiVo> lazyOrganUserTree(Long departmentId, Integer resultType) {
        List organUserTreeVoList = this.organUserApiService.lazyOrganUserTree(departmentId, resultType);
        SpcBaseConfigVo config = this.configService.getSpcBaseConfigByKey(OrganUserConstant.DIMISSION_DEPARTMENT_ID);
        if (config != null && StringUtil.isNotEmpty((Object)config.getConfigValue()) && HussarUtils.isNotEmpty((Object)organUserTreeVoList)) {
            String dimission = config.getConfigValue();
            organUserTreeVoList = organUserTreeVoList.stream().filter(organUserTreeVo -> !dimission.equals(((Long)organUserTreeVo.getId()).toString()) && !dimission.equals(((Long)organUserTreeVo.getParentId()).toString())).collect(Collectors.toList());
        }
        return organUserTreeVoList;
    }

    @Override
    public List<SearchOrganUserRoleVo> searchOrganAndUserAndRole(String keyword, String struFid, List<String> types) {
        List<SearchOrganUserRoleVo> userList;
        if (CollectionUtil.isEmpty(types)) {
            return null;
        }
        SpcBaseConfigVo config = this.configService.getSpcBaseConfigByKey(OrganUserConstant.DIMISSION_DEPARTMENT_ID);
        String dimissionStr = null;
        if (config != null) {
            dimissionStr = config.getConfigValue();
        }
        Long dimission = 0L;
        try {
            dimission = Long.parseLong(dimissionStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<SearchOrganUserRoleVo> organUserVoList = new ArrayList<SearchOrganUserRoleVo>();
        keyword = keyword.replaceAll("%", "/%").replaceAll("-", "/-");
        if (types.contains(OrganUserConstant.TYPE_ORGAN)) {
            List<SearchOrganUserRoleVo> organList = this.organUserMapper.queryOrgan(keyword, struFid, dimission, null);
            organUserVoList.addAll(organList);
        }
        if (types.contains(OrganUserConstant.TYPE_USER)) {
            userList = this.organUserMapper.queryUser(keyword, struFid, dimission, null, null);
            Map<Long, List<SearchOrganUserRoleVo>> listMap = userList.stream().collect(Collectors.groupingBy(SearchOrganUserRoleVo::getId));
            userList = listMap.values().stream().map(group -> {
                SearchOrganUserRoleVo first = (SearchOrganUserRoleVo)group.get(0);
                if (group.size() > 1) {
                    String mergedDepartmentNames = group.stream().map(SearchOrganUserRoleVo::getDepartmentName).filter(Objects::nonNull).distinct().collect(Collectors.joining(","));
                    first.setDepartmentName(mergedDepartmentNames);
                }
                return first;
            }).collect(Collectors.toList());
            organUserVoList.addAll(userList);
        }
        if (types.contains(OrganUserConstant.TYPE_ROLE)) {
            userList = this.organUserMapper.queryRole(keyword);
            organUserVoList.addAll(userList);
        }
        return organUserVoList;
    }

    @Override
    public List<RoleTreeVo> lazyRoleGroup(Long id) {
        ArrayList<RoleTreeVo> roleTreeVoList = new ArrayList<RoleTreeVo>();
        if (id == null) {
            List roleGroupTree = this.sysRolesExternalService.getAllRoleGroup();
            if (CollectionUtil.isNotEmpty((Collection)roleGroupTree)) {
                for (SysRoleGroup sysRoleGroup : roleGroupTree) {
                    RoleTreeVo roleTreeVo = new RoleTreeVo();
                    Long groupId = sysRoleGroup.getId();
                    roleTreeVo.setId(groupId);
                    roleTreeVo.setLabel(sysRoleGroup.getGroupName());
                    List sysRolesList = this.sysRolesExternalService.searchRoleToGroup(groupId, null);
                    roleTreeVo.setHasChildren(false);
                    if (CollectionUtil.isNotEmpty((Collection)sysRolesList)) {
                        roleTreeVo.setHasChildren(true);
                    }
                    roleTreeVo.setTypes("roleGroup");
                    roleTreeVoList.add(roleTreeVo);
                }
            }
            return roleTreeVoList;
        }
        List sysRolesList = this.sysRolesExternalService.searchRoleToGroup(id, null);
        if (CollectionUtil.isNotEmpty((Collection)sysRolesList)) {
            for (SysRoles sysRoles : sysRolesList) {
                RoleTreeVo roleTreeVo = new RoleTreeVo();
                roleTreeVo.setId(sysRoles.getId());
                roleTreeVo.setLabel(sysRoles.getRoleName());
                roleTreeVo.setTypes("role");
                roleTreeVoList.add(roleTreeVo);
            }
        }
        return roleTreeVoList;
    }
}

