/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.operatelog.util;

import com.jxdinfo.spc.core.operatelog.vo.ChangeValue;
import com.jxdinfo.spc.core.operatelog.vo.JsonItem;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DiffUtil {
    public static final String DISPLAY_ABSENT = "\u65e0";
    private static final ZoneId DEFAULT_ZONE = ZoneId.systemDefault();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final Function<Object, String> DATE_FORMATTER = o -> {
        if (o == null) {
            return DISPLAY_ABSENT;
        }
        if (o instanceof Date) {
            return DiffUtil.formatDateTime(DiffUtil.toLocalDateTime((Date)o), FORMATTER);
        }
        if (o instanceof LocalDate) {
            return DiffUtil.formatDate((LocalDate)o, FORMATTER);
        }
        if (o instanceof LocalDateTime) {
            return DiffUtil.formatDateTime((LocalDateTime)o, FORMATTER);
        }
        return DiffUtil.formatValue(o);
    };
    private static final Function<Object, String> DEFAULT_FORMATTER = DiffUtil::formatValue;

    @SafeVarargs
    public static <T> List<JsonItem> diff(T before, T after, FieldMapping<T> ... fieldMappings) {
        ArrayList<JsonItem> result = new ArrayList<JsonItem>();
        for (FieldMapping<T> mapping : fieldMappings) {
            String afterDisplay;
            String fieldName = ((FieldMapping)mapping).fieldName;
            Function getter = ((FieldMapping)mapping).getter;
            Function valueFormatterSupplier = ((FieldMapping)mapping).valueFormatterSupplier;
            Object beforeValue = getter.apply(before);
            Object afterValue = getter.apply(after);
            String beforeDisplay = DiffUtil.formatValue(beforeValue);
            if (Objects.equals(beforeDisplay, afterDisplay = DiffUtil.formatValue(afterValue))) continue;
            Function valueFormatter = (Function)valueFormatterSupplier.apply(true);
            beforeDisplay = (String)valueFormatter.apply(beforeValue);
            afterDisplay = (String)valueFormatter.apply(afterValue);
            ChangeValue changeValue = new ChangeValue();
            changeValue.setBeforeValue(beforeDisplay);
            changeValue.setAfterValue(afterDisplay);
            JsonItem jsonItem = new JsonItem();
            jsonItem.setItemKey(fieldName);
            jsonItem.setItemValue(changeValue);
            result.add(jsonItem);
        }
        return result;
    }

    public static <T> FieldMapping<T> of(String fieldName, Function<T, ?> getter) {
        return new FieldMapping(fieldName, (Function)getter);
    }

    public static <T> FieldMapping<T> of(String fieldName, Function<T, ?> getter, Function<Boolean, Function<Object, String>> valueFormatterSupplier) {
        return new FieldMapping(fieldName, getter, valueFormatterSupplier);
    }

    public static <T> FieldMapping<T> ofTime(String fieldName, Function<T, ?> getter) {
        return new FieldMapping(fieldName, getter, isChanged -> DATE_FORMATTER);
    }

    public static <T> FieldMapping<T> ofWithSuffix(String fieldName, Function<T, ?> getter, String suffix) {
        return new FieldMapping(fieldName, getter, isChanged -> value -> {
            if (value == null) {
                return DISPLAY_ABSENT;
            }
            String formattedValue = value instanceof Number ? String.valueOf(Math.round(((Number)value).doubleValue())) : String.valueOf(value);
            return formattedValue + suffix;
        });
    }

    public static <V> Function<Boolean, Function<Object, String>> mapKeyStringFormatterLazy(Supplier<List<V>> dicListSupplier, Function<V, String> keyExtractor, Function<V, String> labelExtractor) {
        return FormatterFactory.createStringKeyFormatter(dicListSupplier, keyExtractor, labelExtractor);
    }

    public static <V> Function<Boolean, Function<Object, String>> mapKeyLongFormatterLazy(Supplier<List<V>> dicListSupplier, Function<V, Long> keyExtractor, Function<V, String> labelExtractor) {
        return FormatterFactory.createLongKeyFormatter(dicListSupplier, keyExtractor, labelExtractor);
    }

    public static Function<Boolean, Function<Object, String>> stringMapFormatterLazy(Supplier<Map<String, String>> mapSupplier) {
        return FormatterFactory.createMapFormatter(mapSupplier);
    }

    public static Function<Boolean, Function<Object, String>> longMapFormatterLazy(Supplier<Map<Long, String>> mapSupplier) {
        return FormatterFactory.createLongMapFormatter(mapSupplier);
    }

    private static String formatValue(Object value) {
        if (value == null) {
            return DISPLAY_ABSENT;
        }
        String strValue = value.toString().trim();
        return strValue.isEmpty() ? DISPLAY_ABSENT : strValue;
    }

    public static String formatDateTime(LocalDateTime dateTime, DateTimeFormatter formatter) {
        if (dateTime == null) {
            return "";
        }
        return dateTime.format(formatter);
    }

    public static String formatDate(LocalDate date, DateTimeFormatter formatter) {
        if (date == null) {
            return "";
        }
        return date.format(formatter);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(DEFAULT_ZONE).toLocalDateTime();
    }

    private static class FormatterFactory {
        private FormatterFactory() {
        }

        private static <V> Function<Boolean, Function<Object, String>> createStringKeyFormatter(Supplier<List<V>> dicListSupplier, Function<V, String> keyExtractor, Function<V, String> labelExtractor) {
            LazyCache cache = LazyCache.of(() -> ((List)dicListSupplier.get()).stream().collect(Collectors.toMap(keyExtractor, labelExtractor)));
            return isChanged -> o -> {
                if (o == null || !isChanged.booleanValue()) {
                    return DiffUtil.formatValue(o);
                }
                Map map = (Map)cache.get();
                if (map == null || map.isEmpty()) {
                    return DiffUtil.DISPLAY_ABSENT;
                }
                return map.getOrDefault(String.valueOf(o), DiffUtil.DISPLAY_ABSENT);
            };
        }

        private static <V> Function<Boolean, Function<Object, String>> createLongKeyFormatter(Supplier<List<V>> dicListSupplier, Function<V, Long> keyExtractor, Function<V, String> labelExtractor) {
            LazyCache cache = LazyCache.of(() -> ((List)dicListSupplier.get()).stream().collect(Collectors.toMap(keyExtractor, labelExtractor)));
            return isChanged -> o -> {
                if (o == null || !isChanged.booleanValue()) {
                    return DiffUtil.formatValue(o);
                }
                Map map = (Map)cache.get();
                if (map == null || map.isEmpty()) {
                    return DiffUtil.DISPLAY_ABSENT;
                }
                try {
                    Long key = Long.valueOf(String.valueOf(o));
                    return map.getOrDefault(key, DiffUtil.DISPLAY_ABSENT);
                }
                catch (NumberFormatException e) {
                    return DiffUtil.DISPLAY_ABSENT;
                }
            };
        }

        private static Function<Boolean, Function<Object, String>> createMapFormatter(Supplier<Map<String, String>> mapSupplier) {
            LazyCache cache = LazyCache.of(mapSupplier);
            return isChanged -> o -> {
                if (o == null || !isChanged.booleanValue()) {
                    return DiffUtil.formatValue(o);
                }
                Map map = (Map)cache.get();
                if (map == null) {
                    return DiffUtil.DISPLAY_ABSENT;
                }
                return map.getOrDefault(String.valueOf(o), DiffUtil.DISPLAY_ABSENT);
            };
        }

        private static Function<Boolean, Function<Object, String>> createLongMapFormatter(Supplier<Map<Long, String>> mapSupplier) {
            LazyCache cache = LazyCache.of(mapSupplier);
            return isChanged -> o -> {
                if (o == null || !isChanged.booleanValue()) {
                    return DiffUtil.formatValue(o);
                }
                Map map = (Map)cache.get();
                if (map == null) {
                    return DiffUtil.DISPLAY_ABSENT;
                }
                try {
                    Long key = Long.valueOf(String.valueOf(o));
                    return map.getOrDefault(key, DiffUtil.DISPLAY_ABSENT);
                }
                catch (NumberFormatException e) {
                    return DiffUtil.DISPLAY_ABSENT;
                }
            };
        }
    }

    private static class LazyCache<T> {
        private final Supplier<T> supplier;
        private T value;
        private volatile boolean initialized;

        private LazyCache(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T get() {
            if (!this.initialized) {
                LazyCache lazyCache = this;
                synchronized (lazyCache) {
                    if (!this.initialized) {
                        this.value = this.supplier.get();
                        this.initialized = true;
                    }
                }
            }
            return this.value;
        }

        private static <T> LazyCache<T> of(Supplier<T> supplier) {
            return new LazyCache<T>(supplier);
        }
    }

    public static class FieldMapping<T> {
        private final String fieldName;
        private final Function<T, ?> getter;
        private final Function<Boolean, Function<Object, String>> valueFormatterSupplier;

        private FieldMapping(String fieldName, Function<T, ?> getter) {
            this(fieldName, getter, (Boolean isChanged) -> DEFAULT_FORMATTER);
        }

        private FieldMapping(String fieldName, Function<T, ?> getter, Function<Boolean, Function<Object, String>> valueFormatterSupplier) {
            this.fieldName = fieldName;
            this.getter = getter;
            this.valueFormatterSupplier = valueFormatterSupplier;
        }
    }
}

