/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.dataPool.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.spc.adapter.dict.service.IDictAPIService;
import com.jxdinfo.spc.adapter.dict.vo.DictApiVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.FilterFieldListVo;
import com.jxdinfo.spc.core.common.dto.TimeBody;
import com.jxdinfo.spc.core.common.util.TimeFlagTransferUtil;
import com.jxdinfo.spc.core.dataPool.dao.DataPoolDataMapper;
import com.jxdinfo.spc.core.dataPool.dto.DataPoolDataDto;
import com.jxdinfo.spc.core.dataPool.dto.FieldBody;
import com.jxdinfo.spc.core.dataPool.model.DataPoolDataEntity;
import com.jxdinfo.spc.core.dataPool.service.IDataPoolDataService;
import com.jxdinfo.spc.core.dataPool.vo.DataPoolDataVo;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataPoolDataServiceImpl
extends HussarServiceImpl<DataPoolDataMapper, DataPoolDataEntity>
implements IDataPoolDataService {
    @Autowired
    private DataPoolDataMapper dataPoolDataMapper;
    @Resource
    private IDictAPIService dictApiService;

    @Override
    public Page<DataPoolDataVo> queryPage(DataPoolDataDto dto) {
        Page page = dto.getPage();
        dto = this.transfer(dto);
        dto.escapeFields();
        Page<DataPoolDataVo> result = this.dataPoolDataMapper.getList(page, dto);
        this.transferDict(result.getRecords());
        return result;
    }

    private void transferDict(List<DataPoolDataVo> dataPoolDataVoList) {
        List resourceTypeList = this.dictApiService.getDictList("resource_type");
        Map<String, Object> resourceTypeMap = resourceTypeList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        dataPoolDataVoList.forEach(dataPoolDataVo -> {
            if (HussarUtils.isNotEmpty((Object)dataPoolDataVo.getResourceType()) && resourceTypeMap.containsKey(dataPoolDataVo.getResourceType())) {
                dataPoolDataVo.setResourceType(resourceTypeMap.get(dataPoolDataVo.getResourceType()).toString());
            }
        });
    }

    @Override
    public List<DataPoolDataVo> getExportList(DataPoolDataDto dto) {
        dto = this.transfer(dto);
        List<DataPoolDataVo> dataPoolDataVoList = this.dataPoolDataMapper.getList(dto);
        this.transferDict(dataPoolDataVoList);
        return dataPoolDataVoList;
    }

    @Override
    public List<DataPoolDataVo> listData(FilterFieldListVo filterFieldListVo, int lastSort, int size, String controlProjectId) {
        Page page = new Page();
        page.setCurrent(1L);
        page.setSize((long)size);
        Page<DataPoolDataVo> result = this.dataPoolDataMapper.listData(filterFieldListVo, lastSort, size, controlProjectId, (Page<DataPoolDataVo>)page);
        return result.getRecords();
    }

    private DataPoolDataDto transfer(DataPoolDataDto dto) {
        TimeBody timebody;
        FieldBody fieldBody;
        dto.setDetectTime(TimeFlagTransferUtil.transfer(dto.getDetectTime()));
        List<FieldBody> fieldList = dto.getFieldList();
        if (dto.getField1() != null) {
            fieldBody = dto.getField1();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_1");
            fieldList.add(fieldBody);
        }
        if (dto.getField2() != null) {
            fieldBody = dto.getField2();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_2");
            fieldList.add(fieldBody);
        }
        if (dto.getField3() != null) {
            fieldBody = dto.getField3();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_3");
            fieldList.add(fieldBody);
        }
        if (dto.getField4() != null) {
            fieldBody = dto.getField4();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_4");
            fieldList.add(fieldBody);
        }
        if (dto.getField5() != null) {
            fieldBody = dto.getField5();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_5");
            fieldList.add(fieldBody);
        }
        if (dto.getField6() != null) {
            fieldBody = dto.getField6();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_6");
            fieldList.add(fieldBody);
        }
        if (dto.getField7() != null) {
            fieldBody = dto.getField7();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_7");
            fieldList.add(fieldBody);
        }
        if (dto.getField8() != null) {
            fieldBody = dto.getField8();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_8");
            fieldList.add(fieldBody);
        }
        if (dto.getField9() != null) {
            fieldBody = dto.getField9();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_9");
            fieldList.add(fieldBody);
        }
        if (dto.getField10() != null) {
            fieldBody = dto.getField10();
            if ("1".equals(fieldBody.getVariableType())) {
                timebody = TimeFlagTransferUtil.transfer(fieldBody);
                fieldBody.setStart(timebody.getStart());
                fieldBody.setEnd(timebody.getEnd());
            }
            fieldBody.setVariableFileName("FIELD_10");
            fieldList.add(fieldBody);
        }
        return dto;
    }

    @Override
    public Boolean saveDataBatch(List<DataPoolDataEntity> dataPoolDataList) {
        try {
            DataPoolDataEntity entity;
            if (HussarUtils.isEmpty(dataPoolDataList)) {
                return true;
            }
            Page page = new Page(1L, 1L);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.select(new SFunction[]{DataPoolDataEntity::getDataSort}).orderByDesc(DataPoolDataEntity::getDataSort);
            Page resultPage = (Page)this.dataPoolDataMapper.selectPage((IPage)page, (Wrapper)wrapper);
            DataPoolDataEntity dataPoolDataEntity2 = entity = resultPage.getRecords().isEmpty() ? null : (DataPoolDataEntity)resultPage.getRecords().get(0);
            if (HussarUtils.isNotEmpty(entity)) {
                for (int i = 0; i < dataPoolDataList.size(); ++i) {
                    dataPoolDataList.get(i).setDataSort(entity.getDataSort() + i + 1);
                }
            } else {
                for (int i = 0; i < dataPoolDataList.size(); ++i) {
                    dataPoolDataList.get(i).setDataSort(i + 1);
                }
            }
            dataPoolDataList.forEach(dataPoolDataEntity -> dataPoolDataEntity.setSyncTime(LocalDateTime.now()));
            return this.saveBatch(dataPoolDataList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

