/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.common.util;

import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.spc.adapter.lang.service.ILangApiService;
import com.jxdinfo.spc.core.common.constant.LangeTransactionEnum;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class LangeTransactionUtil {
    private static final ILangApiService langApiService = (ILangApiService)SpringContextUtil.getBean(ILangApiService.class);
    private static final boolean enableLange = langApiService.getIsEnable();

    public static String transactionString(LangeTransactionEnum transactionEnum) {
        if (enableLange) {
            return langApiService.getTranslateName(transactionEnum.getKey(), transactionEnum.getDefaultValue());
        }
        return transactionEnum.getDefaultValue();
    }

    public static <T> void transactionList(List<T> list, Function<T, String> getTranslateTagFunction, BiConsumer<T, String> setProcessNameFunction) {
        if (enableLange) {
            langApiService.translateBatch(list, getTranslateTagFunction, setProcessNameFunction);
        }
    }

    public static boolean getEnableLange() {
        return enableLange;
    }
}

