/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.common.service.impl;

import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.spc.core.common.constant.CommonConstant;
import com.jxdinfo.spc.core.common.dto.SpcMessageDto;
import com.jxdinfo.spc.core.common.service.IExtendMessageService;
import com.jxdinfo.spc.core.common.service.IMessageSendService;
import com.jxdinfo.spc.core.common.service.ISpcMessageService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageSendServiceImpl
implements IMessageSendService {
    @Autowired
    private ISpcMessageService spcMessageService;
    @Autowired
    private IExtendMessageService extendMessageService;

    @Override
    public void sendMessage(SpcMessageDto spcMessageDto) {
        CompletableFuture.runAsync(() -> {
            try {
                this.spcMessageService.sendSpcMessage(spcMessageDto);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.extendMessageService.sendExtendMessage(spcMessageDto);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public SpcMessageDto defaultMessage(String messageTitle, String messageContent, LocalDateTime date, SecurityUser user, String userId, String businessAddress, String mobileBusinessAddress) {
        SpcMessageDto spcMessageDto = new SpcMessageDto();
        spcMessageDto.setMessageTitle(messageTitle);
        spcMessageDto.setMessageContent(messageContent);
        spcMessageDto.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        spcMessageDto.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
        spcMessageDto.setUserId(userId);
        if (user.getDeptId() != null) {
            spcMessageDto.setCreatoeDepartmentId(String.valueOf(user.getDeptId()));
        }
        spcMessageDto.setMessageIssue(user.getUserName());
        spcMessageDto.setCreator(user.getUserId());
        spcMessageDto.setLastEditor(user.getUserId());
        spcMessageDto.setBusinessAddress(businessAddress);
        spcMessageDto.setMobileBusinessAddress(mobileBusinessAddress);
        return spcMessageDto;
    }

    public void pushMessageDemo() {
        String title = "\u6d88\u606f\u6807\u9898";
        String content = "\u6d88\u606f\u5185\u5bb9\u6d88\u606f\u5185\u5bb9\u6d88\u606f\u5185\u5bb9\u6d88\u606f\u5185\u5bb9\u6d88\u606f\u5185\u5bb9\u6d88\u606f\u5185\u5bb9";
        String url = "\u6253\u5f00url";
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = new SecurityUser();
        user.setUserId(null);
        user.setUserName("\u7cfb\u7edf");
        SpcMessageDto addSysMessageType = this.defaultMessage(title, content, date, null, "\u6d88\u606f\u63a5\u6536\u4eba", url, "");
        this.sendMessage(addSysMessageType);
    }
}

