/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.baseManage.judgmentRuleManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.dao.JudgmentRuleGroupMapper;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.model.JudgmentRule;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.model.JudgmentRuleGroup;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.service.JudgmentRuleGroupService;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.service.impl.JudgmentRuleServiceImpl;
import com.jxdinfo.spc.core.common.constant.LangeTransactionEnum;
import com.jxdinfo.spc.core.common.util.LangeTransactionUtil;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="baseMange.judgmentRuleManage.JudgmentRuleGroupServiceImpl")
public class JudgmentRuleGroupServiceImpl
extends ServiceImpl<JudgmentRuleGroupMapper, JudgmentRuleGroup>
implements JudgmentRuleGroupService {
    @Autowired
    private JudgmentRuleGroupMapper judgmentRuleGroupMapper;
    @Resource
    private JudgmentRuleServiceImpl judgmentRuleService;

    @Override
    public ApiResponse saveRuleGroup(JudgmentRuleGroup ruleGroup) {
        List list;
        long count = this.count((Wrapper)new LambdaQueryWrapper().eq(JudgmentRuleGroup::getGroupName, (Object)ruleGroup.getGroupName()));
        if (count > 0L) {
            return ApiResponse.fail((String)LangeTransactionUtil.transactionString(LangeTransactionEnum.JUDGMENT_RULE_GROUP_SAVE_MESSAGE));
        }
        if ("1".equals(ruleGroup.getIsDefault()) && (list = this.list((Wrapper)new LambdaQueryWrapper().eq(JudgmentRuleGroup::getIsDefault, (Object)ruleGroup.getIsDefault()))).size() == 1 && !((JudgmentRuleGroup)((Object)list.get(0))).getGroupId().equals(ruleGroup.getGroupId())) {
            return ApiResponse.fail((String)LangeTransactionUtil.transactionString(LangeTransactionEnum.DEFAULT_GROUP_ALREADY_MESSAGE));
        }
        if (ruleGroup.getGroupId() != null) {
            ruleGroup.setLastEditorName(BaseSecurityUtil.getUser().getUserName());
            ruleGroup.setLastEditor(BaseSecurityUtil.getUser().getUserId());
            ruleGroup.setLastTime(LocalDateTime.now());
        } else {
            ruleGroup.setCreatorName(BaseSecurityUtil.getUser().getUserName());
            ruleGroup.setCreator(BaseSecurityUtil.getUser().getUserId());
            ruleGroup.setCreateTime(LocalDateTime.now());
            ruleGroup.setIsSystem("0");
            ruleGroup.setIsDefault(ruleGroup.getIsDefault());
        }
        this.saveOrUpdate((Object)ruleGroup);
        return ApiResponse.success((Object)ruleGroup.getGroupId());
    }

    @Override
    @HussarTransactional
    public Boolean deleteRuleGroup(JudgmentRuleGroup ruleGroup) {
        JudgmentRuleGroup judgmentRuleGroup = (JudgmentRuleGroup)((Object)this.getById(ruleGroup.getGroupId()));
        if ("1".equals(judgmentRuleGroup.getIsDefault())) {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(JudgmentRuleGroup::getIsSystem, (Object)"1")).set(JudgmentRuleGroup::getIsDefault, (Object)"1"));
        }
        return this.removeById(ruleGroup.getGroupId());
    }

    @Override
    @HussarTransactional
    public Long copyRuleGroup(JudgmentRuleGroup ruleGroup) {
        JudgmentRuleGroup copyGroup = new JudgmentRuleGroup();
        JudgmentRuleGroup judgmentRuleGroup = (JudgmentRuleGroup)((Object)this.getById(ruleGroup.getGroupId()));
        copyGroup.setIsDefault("0");
        copyGroup.setIsSystem("0");
        copyGroup.setCreateTime(LocalDateTime.now());
        copyGroup.setCreatorName(BaseSecurityUtil.getUser().getUserName());
        copyGroup.setCreator(BaseSecurityUtil.getUser().getUserId());
        String copy = LangeTransactionUtil.transactionString(LangeTransactionEnum.COPY);
        copyGroup.setGroupName(judgmentRuleGroup.getGroupName() + "-" + copy);
        boolean cpyGroupFlag = this.save((Object)copyGroup);
        if (cpyGroupFlag) {
            List<JudgmentRule> list = this.judgmentRuleService.queryList(ruleGroup.getGroupId());
            list.forEach(rule -> {
                rule.setJudgmentRuleId(null);
                rule.setGroupId(copyGroup.getGroupId());
            });
            this.judgmentRuleService.saveBatch(list);
        }
        return copyGroup.getGroupId();
    }

    @Override
    @HussarTransactional
    public ApiResponse updateDefault(JudgmentRuleGroup ruleGroup) {
        if ("1".equals(ruleGroup.getIsDefault())) {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().ne(JudgmentRuleGroup::getGroupId, (Object)ruleGroup.getGroupId())).set(JudgmentRuleGroup::getIsDefault, (Object)"0"));
        }
        if ("0".equals(ruleGroup.getIsDefault())) {
            this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(JudgmentRuleGroup::getIsSystem, (Object)"1")).set(JudgmentRuleGroup::getIsDefault, (Object)"1"));
        }
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(JudgmentRuleGroup::getGroupId, (Object)ruleGroup.getGroupId())).set(JudgmentRuleGroup::getIsDefault, (Object)ruleGroup.getIsDefault()));
        return ApiResponse.success((String)LangeTransactionUtil.transactionString(LangeTransactionEnum.UPDATE_DEFAULT_MESSAGE));
    }

    @Override
    public List<JudgmentRuleGroup> queryList() {
        List list = this.list();
        list.sort(Comparator.comparing(HussarBaseEntity::getCreateTime));
        return list;
    }
}

