/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.baseManage.controlProjectManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dao.ControlProjectTypeMapper;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dto.ControlProjectTypeDto;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.model.ControlProject;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.model.ControlProjectType;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.service.ControlProjectService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.service.ControlProjectTypeService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.vo.ProjectTypeTreeNodeVo;
import com.jxdinfo.spc.core.common.constant.LangeTransactionEnum;
import com.jxdinfo.spc.core.common.util.CommonUtils;
import com.jxdinfo.spc.core.common.util.LangeTransactionUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="baseMange.controlProjectManage.SpcControlProjectTypeServiceImpl")
public class ControlProjectTypeServiceImpl
extends ServiceImpl<ControlProjectTypeMapper, ControlProjectType>
implements ControlProjectTypeService {
    @Autowired
    private ControlProjectTypeMapper controlProjectTypeMapper;
    @Resource
    private ControlProjectService controlProjectService;

    @Override
    @HussarTransactional
    public ApiResponse<Long> saveControlProjectType(ControlProjectTypeDto controlProjectTypeDto) {
        List list = new ArrayList();
        ControlProjectType controlProjectType = (ControlProjectType)((Object)BeanUtil.copy((Object)((Object)controlProjectTypeDto), ControlProjectType.class));
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (controlProjectType != null && HussarUtils.isEmpty((Object)controlProjectType.getTypePK())) {
            String typeId = CommonUtils.generateAssignId(ControlProjectType.class);
            Long typePK = Long.valueOf(typeId);
            controlProjectType.setCreateTime(date);
            controlProjectType.setCreator(user.getUserId());
            controlProjectType.setCreatorName(user.getUserName());
            controlProjectType.setTypeId(typeId);
            controlProjectType.setTypePK(typePK);
            String parentId = controlProjectType.getParentId();
            if (HussarUtils.isEmpty((Object)parentId)) {
                controlProjectType.setTypePath(String.valueOf(controlProjectType.getTypeId()));
                controlProjectType.setTypeNamePath(controlProjectType.getTypeName());
                controlProjectType.setTypeLevel(1);
            } else {
                ControlProjectType parentInfo = (ControlProjectType)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ControlProjectType::getTypeId, (Object)parentId)));
                controlProjectType.setTypePath(parentInfo.getTypePath() + "/" + controlProjectType.getTypeId());
                controlProjectType.setTypeNamePath(parentInfo.getTypeNamePath() + "/" + controlProjectType.getTypeName());
                controlProjectType.setTypeLevel(parentInfo.getTypeLevel() + 1);
            }
        } else {
            ControlProjectType controlProjectTypeOld = (ControlProjectType)((Object)this.getById(controlProjectType.getTypePK()));
            String typeNamePath = controlProjectTypeOld.getTypeNamePath();
            if (controlProjectTypeOld.getTypeName().equals(controlProjectTypeDto.getTypeName())) {
                return ApiResponse.success((Object)controlProjectType.getTypePK());
            }
            controlProjectType.setTypeNamePath(typeNamePath.substring(0, typeNamePath.lastIndexOf("/") + 1) + controlProjectType.getTypeName());
            controlProjectType.setLastEditor(user.getUserId());
            controlProjectType.setLastEditorName(user.getUserName());
            controlProjectType.setLastTime(date);
            list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ControlProjectType::getTypePath, (Object)controlProjectType.getTypeId())).ne(ControlProjectType::getTypeId, (Object)controlProjectType.getTypeId()));
        }
        List typeList = this.list((Wrapper)new LambdaQueryWrapper());
        Map<String, ControlProjectType> typePathMap = typeList.stream().collect(Collectors.toMap(ControlProjectType::getTypeNamePath, item -> item));
        if (typePathMap.containsKey(controlProjectType.getTypeNamePath())) {
            String message = LangeTransactionUtil.transactionString(LangeTransactionEnum.IS_ALREADY_EXISTS);
            message = message.replaceAll("%s", controlProjectTypeDto.getTypeName());
            return ApiResponse.fail((String)message);
        }
        if (HussarUtils.isNotEmpty(list)) {
            for (ControlProjectType item2 : list) {
                int i = Arrays.asList(item2.getTypePath().split("/")).indexOf(controlProjectType.getTypeId());
                List<String> typeNamePathList = Arrays.asList(item2.getTypeNamePath().split("/"));
                typeNamePathList.set(i, controlProjectTypeDto.getTypeName());
                item2.setTypeNamePath(typeNamePathList.stream().collect(Collectors.joining("/")));
            }
            this.updateBatchById(list);
        }
        this.saveOrUpdate((Object)controlProjectType);
        return ApiResponse.success((Object)controlProjectType.getTypePK());
    }

    @Override
    public ApiResponse deleteControlProjectType(ControlProjectTypeDto controlProjectTypeDto) {
        String typeId = controlProjectTypeDto.getTypeId();
        List children = this.controlProjectTypeMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ControlProjectType::getParentId, (Object)typeId));
        if (!children.isEmpty()) {
            return ApiResponse.fail((String)LangeTransactionUtil.transactionString(LangeTransactionEnum.DELETE_CONTROL_PROJECT_TYPE_MESSAGE));
        }
        List controlProjectList = this.controlProjectService.list((Wrapper)new LambdaQueryWrapper().eq(ControlProject::getTypeId, (Object)typeId));
        if (!controlProjectList.isEmpty()) {
            return ApiResponse.fail((String)LangeTransactionUtil.transactionString(LangeTransactionEnum.DELETE_CONTROL_PROJECT_TYPE_MESSAGE));
        }
        this.removeById(controlProjectTypeDto.getTypePK());
        return ApiResponse.success();
    }

    @Override
    public ApiResponse<List<ProjectTypeTreeNodeVo>> queryTree(String typeId) {
        try {
            if (HussarUtils.isNotEmpty((Object)typeId) && "0".equals(typeId)) {
                Map<String, Integer> controlProjectCountMap = this.getControlProjectCountMap(null);
                return ApiResponse.success(this.buildTree(null, controlProjectCountMap));
            }
            Map<String, Integer> controlProjectCountMap = this.getControlProjectCountMap(typeId);
            List<ProjectTypeTreeNodeVo> treeNodeVoList = this.buildTreeRecursion(typeId, controlProjectCountMap);
            if (HussarUtils.isEmpty((Object)typeId)) {
                ArrayList<ProjectTypeTreeNodeVo> resultTreeNodeList = new ArrayList<ProjectTypeTreeNodeVo>();
                ProjectTypeTreeNodeVo treeNode = new ProjectTypeTreeNodeVo();
                treeNode.setTypeLevel(0);
                treeNode.setTypeId("0");
                treeNode.setTypePK(0L);
                treeNode.setTypeName(LangeTransactionUtil.transactionString(LangeTransactionEnum.ALL_TYPE));
                int childrenCount = (int)this.controlProjectService.count();
                treeNode.setChildrenCount(childrenCount);
                treeNode.setChildren(treeNodeVoList);
                resultTreeNodeList.add(treeNode);
                return ApiResponse.success(resultTreeNodeList);
            }
            return ApiResponse.success(treeNodeVoList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)("\u63a7\u5236\u9879\u76ee\u5206\u7c7b\u6811\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Override
    public List<ControlProjectType> queryList(String typeName) {
        return this.list((Wrapper)new LambdaQueryWrapper().like(ControlProjectType::getTypeName, (Object)typeName));
    }

    @Override
    public ControlProjectType queryTypeByTypeId(String typeId) {
        return (ControlProjectType)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(ControlProjectType::getTypeId, (Object)typeId)));
    }

    private Map<String, Integer> getControlProjectCountMap(String rootId) {
        ControlProjectType controlProjectType;
        if (HussarUtils.isNotEmpty((Object)rootId) && (HussarUtils.isEmpty((Object)((Object)(controlProjectType = (ControlProjectType)((Object)this.controlProjectTypeMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(ControlProjectType::getTypeId, (Object)rootId)))))) || controlProjectType.getTypePath() == null)) {
            return new HashMap<String, Integer>();
        }
        List<ProjectTypeTreeNodeVo> countList = this.controlProjectTypeMapper.selectControlProjectCountMap(rootId);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(countList.size());
        for (ProjectTypeTreeNodeVo vo : countList) {
            countMap.put(vo.getTypeId(), vo.getChildrenCount());
        }
        return countMap;
    }

    private List<ProjectTypeTreeNodeVo> buildTree(String rootId, Map<String, Integer> controlProjectCountMap) {
        ArrayList<ProjectTypeTreeNodeVo> treeNodeList = new ArrayList<ProjectTypeTreeNodeVo>();
        List<ControlProjectType> allChildren = this.controlProjectTypeMapper.selectChildrenByParentId(rootId);
        Map<String, List<ControlProjectType>> childrenGroupByParent = allChildren.stream().collect(Collectors.groupingBy(item -> HussarUtils.isEmpty((Object)item.getParentId()) ? "0" : item.getParentId()));
        List directChildren = childrenGroupByParent.getOrDefault(HussarUtils.isEmpty((Object)rootId) ? "0" : rootId, new ArrayList());
        for (ControlProjectType child : directChildren) {
            ProjectTypeTreeNodeVo treeNode = new ProjectTypeTreeNodeVo();
            treeNode.setTypeId(child.getTypeId());
            treeNode.setTypeName(child.getTypeName());
            if (HussarUtils.isNotEmpty((Object)rootId)) {
                treeNode.setParentId(rootId);
            }
            treeNode.setTypePath(child.getTypePath());
            treeNode.setTypeNamePath(child.getTypeNamePath());
            treeNode.setTypeLevel(child.getTypeLevel());
            treeNode.setChildrenCount(controlProjectCountMap.get(child.getTypeId()));
            List nextLevelChildren = childrenGroupByParent.getOrDefault(child.getTypeId(), new ArrayList());
            if (!nextLevelChildren.isEmpty()) {
                ArrayList<ProjectTypeTreeNodeVo> childrenNodes = new ArrayList<ProjectTypeTreeNodeVo>();
                for (ControlProjectType nextChild : nextLevelChildren) {
                    ProjectTypeTreeNodeVo nextTreeNode = new ProjectTypeTreeNodeVo();
                    nextTreeNode.setTypeId(nextChild.getTypeId());
                    nextTreeNode.setTypeName(nextChild.getTypeName());
                    nextTreeNode.setParentId(child.getTypeId());
                    nextTreeNode.setTypePath(nextChild.getTypePath());
                    nextTreeNode.setTypeNamePath(nextChild.getTypeNamePath());
                    nextTreeNode.setTypeLevel(nextChild.getTypeLevel());
                    nextTreeNode.setChildrenCount(controlProjectCountMap.get(nextChild.getTypeId()));
                    childrenNodes.add(nextTreeNode);
                }
                treeNode.setChildren(childrenNodes);
            }
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    private List<ProjectTypeTreeNodeVo> buildTreeRecursion(String rootId, Map<String, Integer> controlProjectCountMap) {
        ArrayList<ProjectTypeTreeNodeVo> treeNodeList = new ArrayList<ProjectTypeTreeNodeVo>();
        List<ControlProjectType> allChildren = this.controlProjectTypeMapper.selectChildrenByParentId(rootId);
        Map<String, List<ControlProjectType>> childrenGroupByParent = allChildren.stream().collect(Collectors.groupingBy(item -> HussarUtils.isEmpty((Object)item.getParentId()) ? "0" : item.getParentId()));
        List directChildren = childrenGroupByParent.getOrDefault(HussarUtils.isEmpty((Object)rootId) ? "0" : rootId, new ArrayList());
        for (ControlProjectType child : directChildren) {
            ProjectTypeTreeNodeVo treeNode = new ProjectTypeTreeNodeVo();
            treeNode.setTypePK(child.getTypePK());
            treeNode.setTypeId(child.getTypeId());
            treeNode.setTypeName(child.getTypeName());
            if (HussarUtils.isNotEmpty((Object)rootId)) {
                treeNode.setParentId(rootId);
            }
            treeNode.setTypePath(child.getTypePath());
            treeNode.setTypeNamePath(child.getTypeNamePath());
            treeNode.setTypeLevel(child.getTypeLevel());
            treeNode.setChildrenCount(controlProjectCountMap.get(child.getTypeId()));
            List<ProjectTypeTreeNodeVo> grandChildren = this.buildTreeRecursion(child.getTypeId(), controlProjectCountMap);
            treeNode.setChildren(grandChildren);
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }
}

