/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.baseManage.controlProjectManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.spc.adapter.dict.service.IDictAPIService;
import com.jxdinfo.spc.adapter.dict.vo.DictApiVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AnalysisInfoEntity;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.IAnalysisInfoService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dao.ControlProjectMapper;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dto.ControlProjectDto;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dto.ControlProjectImportDto;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dto.ControlProjectPageDto;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.model.ControlProject;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.model.ControlProjectType;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.service.ControlProjectService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.service.ControlProjectTypeService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.util.ReadControlProjectExcelUtil;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.vo.ControlProjectVo;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.vo.ImportResultVo;
import com.jxdinfo.spc.core.common.constant.LangeTransactionEnum;
import com.jxdinfo.spc.core.common.util.CommonUtils;
import com.jxdinfo.spc.core.common.util.LangeTransactionUtil;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="baseMange.controlProjectManage.SpcControlProjectServiceImpl")
public class ControlProjectServiceImpl
extends ServiceImpl<ControlProjectMapper, ControlProject>
implements ControlProjectService {
    @Autowired
    private ControlProjectMapper controlProjectMapper;
    @Resource
    private ControlProjectTypeService controlProjectTypeService;
    @Resource
    private IAnalysisInfoService iAnalysisInfoService;
    @Resource
    private IDictAPIService dictApiService;

    @Override
    public Long saveControlProject(ControlProjectDto dto) {
        ControlProject controlProject = (ControlProject)((Object)BeanUtil.copy((Object)((Object)dto), ControlProject.class));
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (HussarUtils.isEmpty((Object)controlProject.getControlProjectPK())) {
            String controlProjectId = CommonUtils.generateAssignId(ControlProject.class);
            Long controlProjectPK = Long.valueOf(controlProjectId);
            controlProject.setControlProjectPK(controlProjectPK);
            controlProject.setControlProjectId(controlProjectId);
            controlProject.setCreateTime(date);
            controlProject.setCreator(user.getUserId());
            controlProject.setCreatorName(user.getUserName());
        } else {
            controlProject.setLastEditor(user.getUserId());
            controlProject.setLastEditorName(user.getUserName());
            controlProject.setLastTime(date);
        }
        this.saveOrUpdate((Object)controlProject);
        return controlProject.getControlProjectPK();
    }

    @Override
    public ControlProject detail(Long controlProjectPK) {
        return (ControlProject)((Object)this.getById(controlProjectPK));
    }

    @Override
    public ApiResponse delete(ControlProjectDto dto) {
        long count = this.iAnalysisInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(AnalysisInfoEntity.class).eq(AnalysisInfoEntity::getControlProjectId, (Object)dto.getControlProjectId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (count > 0L) {
            return ApiResponse.fail((String)LangeTransactionUtil.transactionString(LangeTransactionEnum.CONTROL_PROJECT_DELETE_MESSAGE));
        }
        this.removeById(dto.getControlProjectPK());
        return ApiResponse.success();
    }

    @Override
    public Page<ControlProjectVo> queryPage(ControlProjectPageDto dto) {
        Page page = dto.getPage();
        if (HussarUtils.isNotEmpty((Object)dto.getControlProjectName())) {
            dto.setControlProjectName(dto.getControlProjectName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        }
        List<ControlProjectVo> list = this.controlProjectMapper.queryPage(page, dto);
        List controlChartTypeList = this.dictApiService.getDictList("control_chart_type");
        Map<String, Object> controlChartTypeMap = controlChartTypeList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        List featureTypeList = this.dictApiService.getDictList("feature_type");
        Map<String, Object> featureTypeMap = featureTypeList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        list.forEach(item -> {
            if (HussarUtils.isNotEmpty((Object)item.getChartType()) && controlChartTypeMap.containsKey(item.getChartType())) {
                item.setChartTypeLabel(controlChartTypeMap.get(item.getChartType()).toString());
            }
            if (HussarUtils.isNotEmpty((Object)item.getDataType()) && controlChartTypeMap.containsKey(item.getDataType())) {
                item.setDataTypeLabel(controlChartTypeMap.get(item.getDataType()).toString());
            }
            if (HussarUtils.isNotEmpty((Object)item.getFeatureType()) && featureTypeMap.containsKey(item.getFeatureType())) {
                item.setFeatureTypeLabel(featureTypeMap.get(item.getFeatureType()).toString());
            }
        });
        page.setRecords(list);
        return page;
    }

    @Override
    public ApiResponse updateType(ControlProjectDto controlProjectDto) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(ControlProject::getControlProjectId, controlProjectDto.getControlProjectIdList())).set(ControlProject::getTypeId, (Object)controlProjectDto.getTypeId()));
        return ApiResponse.success();
    }

    @Override
    public void downLoadTemplate(HttpServletResponse response) {
        String fileName = LangeTransactionUtil.transactionString(LangeTransactionEnum.CONTROL_PROJECT_IMPORT_TEMPLATE);
        ClassPathResource resource = new ClassPathResource("template/" + fileName + ".xlsx");
        try (InputStream in = resource.getInputStream();
             ServletOutputStream out = response.getOutputStream();){
            int len;
            if (!resource.exists()) {
                response.sendError(404, LangeTransactionUtil.transactionString(LangeTransactionEnum.CONTROL_PROJECT_IMPORT_TEMPLATE_MESSAGE));
                return;
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileNameExport = URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
            response.setHeader("Content-Disposition", "attachment;filename*=utf-8''" + fileNameExport + ".xlsx");
            response.setContentLengthLong(resource.contentLength());
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            throw new BaseException(LangeTransactionUtil.transactionString(LangeTransactionEnum.IMPORT_FILE_IS_NOT_EXIST) + "\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            throw new BaseException(LangeTransactionUtil.transactionString(LangeTransactionEnum.DOWNLOAD_FAIL) + "\uff1a" + e.getMessage());
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<ImportResultVo> importExcel(MultipartFile file) {
        ImportResultVo importResultVo = new ImportResultVo();
        ArrayList<ControlProject> controlProjectList = new ArrayList<ControlProject>();
        ArrayList<ControlProjectType> addTypeList = new ArrayList<ControlProjectType>();
        try {
            List<ControlProjectImportDto> list = ReadControlProjectExcelUtil.getExcelInfo(file);
            if (CollectionUtil.isNotEmpty(list)) {
                List featureTypeDictList = this.dictApiService.getDictList("feature_type");
                Map<String, String> featureTypeDictMap = featureTypeDictList.stream().collect(Collectors.toMap(DictApiVo::getLabel, DictApiVo::getValue));
                List chartTypeDictList = this.dictApiService.getDictList("control_chart_type");
                Map<String, String> chartTypeDictMap = chartTypeDictList.stream().collect(Collectors.toMap(DictApiVo::getLabel, DictApiVo::getValue));
                List typeList = this.controlProjectTypeService.list((Wrapper)new LambdaQueryWrapper());
                Map<String, ControlProjectType> typePathMap = typeList.stream().collect(Collectors.toMap(ControlProjectType::getTypeNamePath, item -> item));
                Map<String, ControlProjectType> typeIdMap = typeList.stream().collect(Collectors.toMap(ControlProjectType::getTypeId, item -> item));
                for (int x = 0; x < list.size(); ++x) {
                    ControlProjectImportDto dto = list.get(x);
                    ControlProject controlProject = new ControlProject();
                    controlProject.setCreateTime(LocalDateTime.now());
                    controlProject.setCreator(BaseSecurityUtil.getUser().getUserId());
                    controlProject.setCreatorName(BaseSecurityUtil.getUser().getUserName());
                    controlProject.setControlProjectName(dto.getControlProjectName());
                    if (HussarUtils.isNotEmpty(chartTypeDictMap) && HussarUtils.isNotEmpty((Object)chartTypeDictMap.get(dto.getDataTypeName()))) {
                        controlProject.setDataType(chartTypeDictMap.get(dto.getDataTypeName()));
                    }
                    if (HussarUtils.isNotEmpty(featureTypeDictMap) && HussarUtils.isNotEmpty((Object)featureTypeDictMap.get(dto.getFeatureTypeName()))) {
                        controlProject.setFeatureType(featureTypeDictMap.get(dto.getFeatureTypeName()));
                    }
                    if (HussarUtils.isNotEmpty(chartTypeDictMap) && HussarUtils.isNotEmpty((Object)chartTypeDictMap.get(dto.getChartTypeName()))) {
                        controlProject.setChartType(chartTypeDictMap.get(dto.getChartTypeName()));
                    }
                    controlProject.setUsl(dto.getUsl());
                    controlProject.setSl(dto.getSl());
                    controlProject.setLsl(dto.getLsl());
                    if ("xmr".equals(controlProject.getChartType()) && dto.getSubgroupSize() != 1) {
                        throw new IllegalArgumentException(LangeTransactionUtil.transactionString(LangeTransactionEnum.ERROR_IN_LINE) + (x + 1) + LangeTransactionUtil.transactionString(LangeTransactionEnum.CONTROL_PROJECT_ERROR_MESSAGE));
                    }
                    controlProject.setSubgroupSize(dto.getSubgroupSize());
                    String[] levelArr = new String[]{dto.getOneLevelType(), dto.getTwoLevelType(), dto.getThreeLevelType(), dto.getFourLevelType(), dto.getFiveLevelType()};
                    String typePath = "";
                    for (String level : levelArr) {
                        if (!HussarUtils.isNotEmpty((Object)level)) break;
                        typePath = typePath + level + "/";
                    }
                    String isExistTypePath = "";
                    String isNotExistTypePath = "";
                    if (typePathMap.containsKey(typePath.substring(0, typePath.length() - 1))) {
                        controlProject.setTypeId(typePathMap.get(typePath.substring(0, typePath.length() - 1)).getTypeId());
                    } else {
                        String[] parts = typePath.split("/");
                        StringBuilder existingPath = new StringBuilder();
                        for (int i = 0; i < parts.length; ++i) {
                            existingPath.append(parts[i]).append("/");
                            String existingPathStr = existingPath.toString();
                            if (typePathMap.containsKey(existingPathStr.substring(0, existingPathStr.length() - 1))) continue;
                            if (i > 0) {
                                isExistTypePath = String.join((CharSequence)"/", Arrays.copyOfRange(parts, 0, i));
                            }
                            isNotExistTypePath = String.join((CharSequence)"/", Arrays.copyOfRange(parts, i, parts.length));
                            break;
                        }
                        String lastTypeId = null;
                        if (HussarUtils.isNotEmpty((Object)isNotExistTypePath)) {
                            List<String> isNotExistTypePathList = Arrays.asList(isNotExistTypePath.split("/"));
                            if (HussarUtils.isEmpty((Object)isExistTypePath)) {
                                lastTypeId = this.createSpcControlProjectType(isNotExistTypePathList, typeIdMap, null, null, 0, addTypeList, typePathMap);
                            } else {
                                ControlProjectType parentType = typePathMap.get(isExistTypePath);
                                lastTypeId = this.createSpcControlProjectType(isNotExistTypePathList, typeIdMap, parentType, parentType.getTypeId(), 0, addTypeList, typePathMap);
                            }
                        }
                        controlProject.setTypeId(lastTypeId);
                    }
                    controlProjectList.add(controlProject);
                }
                this.controlProjectTypeService.saveBatch(addTypeList);
                this.saveBatch(controlProjectList);
                for (ControlProject controlProject : controlProjectList) {
                    controlProject.setControlProjectId(String.valueOf(controlProject.getControlProjectPK()));
                }
                this.updateBatchById(controlProjectList);
                importResultVo.setControlProjectNum(controlProjectList.size());
                importResultVo.setControlProjectTypeNum(addTypeList.size());
                return ApiResponse.success((Object)importResultVo);
            }
            throw new IllegalArgumentException(LangeTransactionUtil.transactionString(LangeTransactionEnum.IMPORT_FILE_NONE_DATA));
        }
        catch (IllegalArgumentException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        catch (Exception e) {
            return ApiResponse.fail((String)LangeTransactionUtil.transactionString(LangeTransactionEnum.IMPORT_FAILED));
        }
    }

    @Override
    public List<ControlProjectVo> queryList(ControlProjectPageDto dto) {
        return this.controlProjectMapper.queryList(dto);
    }

    private String createSpcControlProjectType(List<String> isNotExistTypePathList, Map<String, ControlProjectType> typeIdMap, ControlProjectType controlProjectType, String parentTypeId, int level, List<ControlProjectType> addTypeList, Map<String, ControlProjectType> typePathMap) {
        if (level > isNotExistTypePathList.size() - 1) {
            return parentTypeId;
        }
        ControlProjectType createType = new ControlProjectType();
        String LastTypeId = CommonUtils.generateAssignId(ControlProjectType.class);
        if (HussarUtils.isEmpty((Object)parentTypeId)) {
            createType.setTypeLevel(1);
            createType.setTypeName(isNotExistTypePathList.get(0));
            createType.setTypeNamePath(isNotExistTypePathList.get(0));
            createType.setTypePath(LastTypeId.toString());
            createType.setTypeId(LastTypeId);
            createType.setTypePK(Long.parseLong(LastTypeId));
        } else {
            if (HussarUtils.isEmpty((Object)((Object)controlProjectType))) {
                controlProjectType = typeIdMap.get(parentTypeId);
            }
            createType.setTypeLevel(controlProjectType.getTypeLevel() + 1);
            createType.setTypeNamePath(controlProjectType.getTypeNamePath() + "/" + isNotExistTypePathList.get(level));
            createType.setParentId(HussarUtils.isEmpty((Object)controlProjectType.getTypeId()) ? parentTypeId : controlProjectType.getTypeId());
            createType.setTypePath(controlProjectType.getTypePath() + "/" + LastTypeId);
            createType.setTypeId(LastTypeId);
            createType.setTypePK(Long.parseLong(LastTypeId));
            createType.setTypeName(isNotExistTypePathList.get(level));
        }
        createType.setCreatorName(BaseSecurityUtil.getUser().getUserName());
        createType.setCreator(BaseSecurityUtil.getUser().getUserId());
        createType.setCreateTime(LocalDateTime.now());
        if (!typePathMap.containsKey(createType.getTypeNamePath())) {
            addTypeList.add(createType);
            typePathMap.put(createType.getTypeNamePath(), createType);
            typeIdMap.put(createType.getTypeId(), createType);
            controlProjectType = createType;
        } else {
            controlProjectType = typePathMap.get(createType.getTypeNamePath());
        }
        return this.createSpcControlProjectType(isNotExistTypePathList, typeIdMap, controlProjectType, controlProjectType.getTypeId(), level + 1, addTypeList, typePathMap);
    }
}

