/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.baseManage.baseConfig.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.adapter.lang.service.ILangApiService;
import com.jxdinfo.spc.core.baseManage.baseConfig.dto.BaseConfigDto;
import com.jxdinfo.spc.core.baseManage.baseConfig.model.ProcessVariableEntity;
import com.jxdinfo.spc.core.baseManage.baseConfig.service.IBaseConfigService;
import com.jxdinfo.spc.core.baseManage.baseConfig.service.IProcessVariableService;
import com.jxdinfo.spc.core.baseManage.baseConfig.vo.BaseConfigVo;
import com.jxdinfo.spc.core.baseManage.baseConfig.vo.ProcessVariableVo;
import com.jxdinfo.spc.core.baseManage.baseConfig.vo.ProjectLabelConfigVo;
import com.jxdinfo.spc.core.baseManage.baseConfig.vo.UpdateCron;
import com.jxdinfo.spc.core.common.service.ISpcBaseConfigService;
import com.jxdinfo.spc.core.common.util.LangeTransactionUtil;
import com.jxdinfo.spc.core.common.vo.SpcBaseConfigVo;
import com.jxdinfo.spc.core.dataPool.dao.DataPoolDataMapper;
import com.jxdinfo.spc.core.dataPool.model.DataPoolDataEntity;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseConfigServiceImpl
implements IBaseConfigService {
    @Autowired
    private IProcessVariableService processVariableService;
    @Autowired
    private ISpcBaseConfigService spcBaseConfigService;
    @Autowired
    private DataPoolDataMapper dataPoolDataMapper;
    @Resource
    private ILangApiService langApiService;

    @Override
    @Transactional
    public Boolean save(BaseConfigDto baseConfigDto) {
        boolean isSuccess = false;
        try {
            List<ProcessVariableVo> processVariableVoList = baseConfigDto.getProcessVariableList();
            List processVariableEntityList = HussarUtils.copyProperties(processVariableVoList, ProcessVariableEntity.class);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            processVariableEntityList.stream().forEach(processVariableEntity -> {
                processVariableEntity.setLastEditor(securityUser.getUserId());
                if (processVariableEntity.getVariableId() == null) {
                    processVariableEntity.setCreator(securityUser.getUserId());
                }
                int index = processVariableEntityList.indexOf(processVariableEntity) + 1;
                processVariableEntity.setVariableFileName("field" + index);
            });
            isSuccess = this.processVariableService.saveOrUpdateBatch(processVariableEntityList);
            if (!isSuccess) {
                return false;
            }
            List spcBaseConfigList = this.spcBaseConfigService.list();
            UpdateCron updateCron = baseConfigDto.getUpdateCron();
            String updateCronStr = updateCron != null && updateCron.getNum() != null ? JSONObject.toJSONString((Object)updateCron) : baseConfigDto.getUpdateCronStr();
            if (HussarUtils.isNotEmpty((Object)updateCronStr)) {
                spcBaseConfigList.forEach(spcBaseConfig -> {
                    if ("update_cron".equals(spcBaseConfig.getConfigKey())) {
                        spcBaseConfig.setConfigValue(updateCronStr);
                    }
                });
            }
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getDecimalNum())) {
                spcBaseConfigList.forEach(spcBaseConfig -> {
                    if ("decimal_num".equals(spcBaseConfig.getConfigKey())) {
                        spcBaseConfig.setConfigValue(baseConfigDto.getDecimalNum());
                    }
                });
            }
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getVirtualSubGroupSize())) {
                spcBaseConfigList.forEach(spcBaseConfig -> {
                    if ("virtual_sub_group_size".equals(spcBaseConfig.getConfigKey())) {
                        spcBaseConfig.setConfigValue(baseConfigDto.getVirtualSubGroupSize());
                    }
                });
            }
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getControlProjectIdLabel())) {
                spcBaseConfigList.forEach(spcBaseConfig -> {
                    if ("control_project_id".equals(spcBaseConfig.getConfigKey())) {
                        spcBaseConfig.setConfigValue(baseConfigDto.getControlProjectIdLabel());
                    }
                });
            }
            spcBaseConfigList.forEach(spcBaseConfig -> {
                if ("control_project_id_key".equals(spcBaseConfig.getConfigKey())) {
                    spcBaseConfig.setConfigValue(baseConfigDto.getControlProjectIdKey());
                }
            });
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getControlProjectNameLabel())) {
                spcBaseConfigList.forEach(spcBaseConfig -> {
                    if ("control_project_name".equals(spcBaseConfig.getConfigKey())) {
                        spcBaseConfig.setConfigValue(baseConfigDto.getControlProjectNameLabel());
                    }
                });
            }
            spcBaseConfigList.forEach(spcBaseConfig -> {
                if ("control_project_name_key".equals(spcBaseConfig.getConfigKey())) {
                    spcBaseConfig.setConfigValue(baseConfigDto.getControlProjectNameKey());
                }
            });
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getProjectTypeNameLabel())) {
                spcBaseConfigList.forEach(spcBaseConfig -> {
                    if ("project_type_name".equals(spcBaseConfig.getConfigKey())) {
                        spcBaseConfig.setConfigValue(baseConfigDto.getProjectTypeNameLabel());
                    }
                });
            }
            spcBaseConfigList.forEach(spcBaseConfig -> {
                if ("project_type_name_key".equals(spcBaseConfig.getConfigKey())) {
                    spcBaseConfig.setConfigValue(baseConfigDto.getProjectTypeNameKey());
                }
            });
            isSuccess = this.spcBaseConfigService.updateConfigBatch(spcBaseConfigList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isSuccess;
    }

    @Override
    public BaseConfigVo formQuery() {
        List processVariableList = this.processVariableService.list();
        List processVariableVoList = HussarUtils.copyProperties((Collection)processVariableList, ProcessVariableVo.class);
        LangeTransactionUtil.transactionList(processVariableVoList, ProcessVariableVo::getVariableNameKey, ProcessVariableVo::setVariableName);
        BaseConfigVo baseConfigVo = new BaseConfigVo();
        baseConfigVo.setProcessVariableVoList(processVariableVoList);
        SpcBaseConfigVo updateCronConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("update_cron");
        UpdateCron updateCron = (UpdateCron)JSONObject.parseObject((String)updateCronConfig.getConfigValue(), UpdateCron.class);
        baseConfigVo.setUpdateCron(updateCron);
        SpcBaseConfigVo decimalNumConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("decimal_num");
        baseConfigVo.setDecimalNum(decimalNumConfig.getConfigValue());
        SpcBaseConfigVo virtualSubGroupSizeConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("virtual_sub_group_size");
        baseConfigVo.setVirtualSubGroupSize(virtualSubGroupSizeConfig.getConfigValue());
        ProjectLabelConfigVo projectLabelConfigVo = this.getProjectLabelConfig();
        baseConfigVo.setControlProjectId(projectLabelConfigVo.getControlProjectId());
        baseConfigVo.setControlProjectName(projectLabelConfigVo.getControlProjectName());
        baseConfigVo.setProjectTypeName(projectLabelConfigVo.getProjectTypeName());
        baseConfigVo.setControlProjectIdKey(projectLabelConfigVo.getControlProjectIdKey());
        baseConfigVo.setControlProjectNameKey(projectLabelConfigVo.getControlProjectNameKey());
        baseConfigVo.setProjectTypeNameKey(projectLabelConfigVo.getProjectTypeNameKey());
        LangeTransactionUtil.transactionList(Collections.singletonList(baseConfigVo), BaseConfigVo::getControlProjectIdKey, BaseConfigVo::setControlProjectId);
        LangeTransactionUtil.transactionList(Collections.singletonList(baseConfigVo), BaseConfigVo::getControlProjectNameKey, BaseConfigVo::setControlProjectName);
        LangeTransactionUtil.transactionList(Collections.singletonList(baseConfigVo), BaseConfigVo::getProjectTypeNameKey, BaseConfigVo::setProjectTypeName);
        return baseConfigVo;
    }

    @Override
    public List<ProcessVariableVo> filedList(BaseConfigDto baseConfigDto) {
        List<ProcessVariableVo> processVariableVoList = this.filedShortList();
        if (CollectionUtil.isEmpty(processVariableVoList)) {
            return processVariableVoList;
        }
        List enumList = processVariableVoList.stream().filter(processVariableVo -> processVariableVo.getVariableType().equals("2")).collect(Collectors.toList());
        List<DataPoolDataEntity> dataPoolDataList = this.dataPoolDataMapper.listByTypeOrProjectId(baseConfigDto);
        if (CollectionUtil.isNotEmpty(dataPoolDataList)) {
            for (ProcessVariableVo processVariableVo2 : enumList) {
                List<String> enumOptionList = this.getFieldValues(dataPoolDataList, processVariableVo2.getVariableFileName());
                processVariableVo2.setEnumOptionList(enumOptionList);
            }
        }
        return processVariableVoList;
    }

    @Override
    public List<ProcessVariableVo> filedShortList() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ProcessVariableEntity::getIsShow, (Object)"1");
        List processVariableList = this.processVariableService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)processVariableList)) {
            return new ArrayList<ProcessVariableVo>();
        }
        return HussarUtils.copyProperties((Collection)processVariableList, ProcessVariableVo.class);
    }

    private List<String> getFieldValues(List<DataPoolDataEntity> dataPoolDataList, String fileName) {
        Class<DataPoolDataEntity> clazz = DataPoolDataEntity.class;
        ArrayList<String> fieldValuesList = new ArrayList<String>();
        try {
            Field field = clazz.getDeclaredField(fileName);
            for (DataPoolDataEntity dataPoolDataEntity : dataPoolDataList) {
                field.setAccessible(true);
                String fileValue = (String)field.get(dataPoolDataEntity);
                fieldValuesList.add(fileValue);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (CollectionUtil.isNotEmpty(fieldValuesList)) {
            return fieldValuesList.stream().distinct().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public ProjectLabelConfigVo getProjectLabelConfig() {
        SpcBaseConfigVo projectTypeNameKeyConfig;
        SpcBaseConfigVo controlProjectIdKeyConfig;
        SpcBaseConfigVo controlProjectNameKeyConfig;
        SpcBaseConfigVo controlProjectNameConfig;
        SpcBaseConfigVo controlProjecIdtConfig;
        ProjectLabelConfigVo projectLabelConfig = new ProjectLabelConfigVo();
        SpcBaseConfigVo projectTypeConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("project_type_name");
        if (HussarUtils.isNotEmpty((Object)projectTypeConfig)) {
            projectLabelConfig.setProjectTypeName(projectTypeConfig.getConfigValue());
        }
        if (HussarUtils.isNotEmpty((Object)(controlProjecIdtConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("control_project_id")))) {
            projectLabelConfig.setControlProjectId(controlProjecIdtConfig.getConfigValue());
        }
        if (HussarUtils.isNotEmpty((Object)(controlProjectNameConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("control_project_name")))) {
            projectLabelConfig.setControlProjectName(controlProjectNameConfig.getConfigValue());
        }
        if (HussarUtils.isNotEmpty((Object)(controlProjectNameKeyConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("control_project_name_key")))) {
            projectLabelConfig.setControlProjectNameKey(controlProjectNameKeyConfig.getConfigValue());
        }
        if (HussarUtils.isNotEmpty((Object)(controlProjectIdKeyConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("control_project_id_key")))) {
            projectLabelConfig.setControlProjectIdKey(controlProjectIdKeyConfig.getConfigValue());
        }
        if (HussarUtils.isNotEmpty((Object)(projectTypeNameKeyConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("project_type_name_key")))) {
            projectLabelConfig.setProjectTypeNameKey(projectTypeNameKeyConfig.getConfigValue());
        }
        return projectLabelConfig;
    }
}

