/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.strategy;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.ChartStatistic;
import com.jxdinfo.spc.core.analysisManage.analysisTool.service.SpcService;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.ControlChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.ControlChartDataVO;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import com.jxdinfo.spc.formula.api.util.quantity.XRControlChartUtil;
import com.jxdinfo.spc.formula.api.util.quantity.XSControlChartUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
@Lazy
public class XbarSChartStrategy
extends ControlChartStrategy {
    public XbarSChartStrategy(SpcService spcService) {
        super(spcService);
    }

    @Override
    public void dataCheck() {
        this.commonDataChecked();
        AnalysisParamDto param = this.getAnalysisParam();
        int subGroupNum = Integer.parseInt(param.getSubgroupSize());
        if (this.getNodeList().size() < 2 || subGroupNum < 2) {
            throw new RuntimeException("\u5747\u503c\u6807\u51c6\u5dee\u56fe\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u5b50\u7ec4\uff01");
        }
    }

    @Override
    public void generateControlData(AnalysisResultVO analysisResultVO) {
        ArrayList<ControlData> controlDataList = new ArrayList<ControlData>();
        AnalysisParamDto param = this.getAnalysisParam();
        List<List<BigDecimal>> nodeValueList = this.getNodeBigList();
        ArrayList<AbnormalData> allAbnormalDataList = new ArrayList<AbnormalData>();
        this.processAnalysisForXbarS(nodeValueList, this.getTotalNodeBigList(), param, analysisResultVO);
        String ucl = analysisResultVO.getControlChartDataVO().getUcl();
        String lcl = analysisResultVO.getControlChartDataVO().getLcl();
        String cl = analysisResultVO.getControlChartDataVO().getCl();
        String ucls = analysisResultVO.getControlChartDataVO().getSucl();
        String lcls = analysisResultVO.getControlChartDataVO().getSlcl();
        String cls = analysisResultVO.getControlChartDataVO().getScl();
        String sigmaXBar = analysisResultVO.getControlChartDataVO().getSigmaXBar();
        String sigmaS = analysisResultVO.getControlChartDataVO().getSigmaS();
        String uclDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)ucl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String lclDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)lcl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String clDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)cl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String uclsDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)ucls), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String lclsDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)lcls), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String clsDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)cls), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        List<BigDecimal> xbarChartValueData = this.xbarChartAnalysis(nodeValueList);
        List<ChartStatistic> xBrStatisticList = this.generateData(xbarChartValueData, param, cl, sigmaXBar);
        ControlData xbarControlData = this.generateControlData("1", xBrStatisticList, uclDecimal, clDecimal, lclDecimal);
        controlDataList.add(xbarControlData);
        List<BigDecimal> sChartValueData = this.sChartAnalysis(nodeValueList);
        List<ChartStatistic> sStatisticList = this.generateData(sChartValueData, param, cls, sigmaS);
        ControlData sControlData = this.generateControlData("5", sStatisticList, uclsDecimal, clsDecimal, lclsDecimal);
        controlDataList.add(sControlData);
        List<AbnormalData> xBarAnalysisDataSourceList = this.generateAbnormalDataSource(xBrStatisticList, uclDecimal, lclDecimal, clDecimal, "1");
        List<AbnormalData> sAnalysisDataSourceList = this.generateAbnormalDataSource(sStatisticList, uclsDecimal, lclsDecimal, clsDecimal, "5");
        if (HussarUtils.isNotEmpty(xBarAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(xBarAnalysisDataSourceList);
        }
        if (HussarUtils.isNotEmpty(sAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(sAnalysisDataSourceList);
        }
        analysisResultVO.setAbnormalData(allAbnormalDataList);
        analysisResultVO.setControlData(controlDataList);
    }

    private void processAnalysisForXbarS(List<List<BigDecimal>> valueList, List<BigDecimal> totalValueList, AnalysisParamDto params, AnalysisResultVO analysisResultVO) {
        BigDecimal USL = StringUtils.isNotEmpty((CharSequence)params.getUsl()) ? new BigDecimal(params.getUsl()) : null;
        BigDecimal LSL = StringUtils.isNotEmpty((CharSequence)params.getLsl()) ? new BigDecimal(params.getLsl()) : null;
        BigDecimal c4 = new BigDecimal(params.getControlCoefficient().getCenterLineC4());
        BigDecimal A3 = new BigDecimal(params.getControlCoefficient().getControlLimitA3());
        BigDecimal B3 = new BigDecimal(Objects.equals(params.getControlCoefficient().getControlLimitB3(), "-") ? "0" : params.getControlCoefficient().getControlLimitB3());
        BigDecimal B4 = new BigDecimal(params.getControlCoefficient().getControlLimitB4());
        BigDecimal cl = !HussarUtils.isEmpty((Object)params.getCl()) ? new BigDecimal(params.getCl()) : XRControlChartUtil.calculateTotalAvgXBar(totalValueList);
        List batchStdev = valueList.stream().map(batch -> Calc.getBigDecimal((Object)CommonUtil.getStdev((List)batch))).collect(Collectors.toList());
        BigDecimal clGroup = XRControlChartUtil.calculateTotalAvgXBar(batchStdev);
        BigDecimal cls = !HussarUtils.isEmpty((Object)params.getClr()) ? new BigDecimal(params.getClr()) : clGroup;
        BigDecimal sigmaTotal = CommonUtil.calculateOverallSigma(totalValueList);
        BigDecimal sigmaGroup = XSControlChartUtil.estimateProcessStdevBySBar((BigDecimal)clGroup, (BigDecimal)c4);
        BigDecimal ucl = !HussarUtils.isEmpty((Object)params.getUcl()) ? new BigDecimal(params.getUcl()) : XSControlChartUtil.calculateXBarChartUCL((BigDecimal)cl, (BigDecimal)A3, (BigDecimal)cls);
        BigDecimal lcl = !HussarUtils.isEmpty((Object)params.getLcl()) ? new BigDecimal(params.getLcl()) : XSControlChartUtil.calculateXBarChartLCL((BigDecimal)cl, (BigDecimal)A3, (BigDecimal)cls);
        BigDecimal ucls = !HussarUtils.isEmpty((Object)params.getUclr()) ? new BigDecimal(params.getUclr()) : XSControlChartUtil.calculateSChartUCL((BigDecimal)B4, (BigDecimal)cls);
        BigDecimal lcls = !HussarUtils.isEmpty((Object)params.getLclr()) ? new BigDecimal(params.getLclr()) : XSControlChartUtil.calculateSChartLCL((BigDecimal)B3, (BigDecimal)cls);
        BigDecimal sigmaXBar = CommonUtil.calculateChartStdev((BigDecimal)ucl, (BigDecimal)lcl, (BigDecimal)cl);
        BigDecimal sigmaS = CommonUtil.calculateChartStdev((BigDecimal)ucls, (BigDecimal)lcls, (BigDecimal)cls);
        int batchCount = valueList.size();
        Long belowLslCount = LSL != null ? Long.valueOf(totalValueList.stream().filter(data -> data.compareTo(LSL) < 0).count()) : null;
        Long aboveUslCount = USL != null ? Long.valueOf(totalValueList.stream().filter(data -> data.compareTo(USL) > 0).count()) : null;
        ControlChartDataVO controlChartDataVO = new ControlChartDataVO();
        controlChartDataVO.setUcl(ucl.toPlainString());
        controlChartDataVO.setLcl(lcl.toPlainString());
        controlChartDataVO.setCl(cl.toPlainString());
        controlChartDataVO.setSucl(ucls.toPlainString());
        controlChartDataVO.setSlcl(lcls.toPlainString());
        controlChartDataVO.setScl(cls.toPlainString());
        controlChartDataVO.setSigmaXBar(sigmaXBar.toPlainString());
        controlChartDataVO.setSigmaS(sigmaS.toPlainString());
        controlChartDataVO.setBatchCount(batchCount);
        controlChartDataVO.setSigmaGroup(sigmaGroup.toPlainString());
        controlChartDataVO.setSigmaTotal(sigmaTotal.toPlainString());
        controlChartDataVO.setAboveUslCount(aboveUslCount);
        controlChartDataVO.setBelowLslCount(belowLslCount);
        analysisResultVO.setControlChartDataVO(controlChartDataVO);
    }

    private List<BigDecimal> sChartAnalysis(List<List<BigDecimal>> nodeValueList) {
        return nodeValueList.stream().map(batch -> {
            List collect = batch.stream().filter(b -> b.compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            return Calc.getBigDecimal((Object)CommonUtil.getStdev(collect));
        }).collect(Collectors.toList());
    }
}

