/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.strategy;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.ChartStatistic;
import com.jxdinfo.spc.core.analysisManage.analysisTool.service.SpcService;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.ControlChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.ControlChartDataVO;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import com.jxdinfo.spc.formula.api.util.quantity.XMedRControlChartUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
@Lazy
public class XMedRChartStrategy
extends ControlChartStrategy {
    public XMedRChartStrategy(SpcService spcService) {
        super(spcService);
    }

    @Override
    public void dataCheck() {
        this.commonDataChecked();
        AnalysisParamDto param = this.getAnalysisParam();
        int subGroupNum = Integer.parseInt(param.getSubgroupSize());
        if (this.getNodeList().size() < 2 || subGroupNum < 2) {
            throw new RuntimeException("\u4e2d\u4f4d\u6570\u6781\u5dee\u56fe\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u5b50\u7ec4\uff01");
        }
    }

    @Override
    public void generateControlData(AnalysisResultVO analysisResultVO) {
        ArrayList<ControlData> controlDataList = new ArrayList<ControlData>();
        AnalysisParamDto param = this.getAnalysisParam();
        List<List<BigDecimal>> nodeValueList = this.getNodeBigList();
        ArrayList<AbnormalData> allAbnormalDataList = new ArrayList<AbnormalData>();
        this.processAnalysisForXMedR(nodeValueList, this.getTotalNodeBigList(), param, analysisResultVO);
        String ucl = analysisResultVO.getControlChartDataVO().getUcl();
        String lcl = analysisResultVO.getControlChartDataVO().getLcl();
        String cl = analysisResultVO.getControlChartDataVO().getCl();
        String uclr = analysisResultVO.getControlChartDataVO().getRucl();
        String lclr = analysisResultVO.getControlChartDataVO().getRlcl();
        String clr = analysisResultVO.getControlChartDataVO().getRcl();
        String sigmaXMed = analysisResultVO.getControlChartDataVO().getSigmaXMed();
        String sigmaR = analysisResultVO.getControlChartDataVO().getSigmaR();
        String uclDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)ucl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String lclDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)lcl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String clDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)cl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String uclrDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)uclr), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String lclrDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)lclr), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String clrDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)clr), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        List<BigDecimal> xMedChartValueData = this.xMedChartAnalysis(nodeValueList);
        List<ChartStatistic> xBrStatisticList = this.generateData(xMedChartValueData, param, cl, sigmaXMed);
        ControlData xbarControlData = this.generateControlData("6", xBrStatisticList, uclDecimal, clDecimal, lclDecimal);
        controlDataList.add(xbarControlData);
        List<BigDecimal> rChartValueData = this.rChartAnalysis(nodeValueList);
        List<ChartStatistic> rStatisticList = this.generateData(rChartValueData, param, clr, sigmaR);
        ControlData rControlData = this.generateControlData("2", rStatisticList, uclrDecimal, clrDecimal, lclrDecimal);
        controlDataList.add(rControlData);
        List<AbnormalData> xMedAnalysisDataSourceList = this.generateAbnormalDataSource(xBrStatisticList, uclDecimal, lclDecimal, clDecimal, "6");
        List<AbnormalData> rAnalysisDataSourceList = this.generateAbnormalDataSource(rStatisticList, uclrDecimal, lclrDecimal, clrDecimal, "2");
        if (HussarUtils.isNotEmpty(xMedAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(xMedAnalysisDataSourceList);
        }
        if (HussarUtils.isNotEmpty(rAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(rAnalysisDataSourceList);
        }
        analysisResultVO.setAbnormalData(allAbnormalDataList);
        analysisResultVO.setControlData(controlDataList);
    }

    private void processAnalysisForXMedR(List<List<BigDecimal>> valueList, List<BigDecimal> totalValueList, AnalysisParamDto params, AnalysisResultVO analysisResultVO) {
        BigDecimal USL = StringUtils.isNotEmpty((CharSequence)params.getUsl()) ? new BigDecimal(params.getUsl()) : null;
        BigDecimal LSL = StringUtils.isNotEmpty((CharSequence)params.getLsl()) ? new BigDecimal(params.getLsl()) : null;
        BigDecimal d2 = new BigDecimal(params.getControlCoefficient().getCenterLineD2());
        BigDecimal A2 = new BigDecimal(params.getControlCoefficient().getControlLimitA2());
        BigDecimal D3 = new BigDecimal(Objects.equals(params.getControlCoefficient().getControlLimitD3(), "-") ? "0" : params.getControlCoefficient().getControlLimitD3());
        BigDecimal D4 = new BigDecimal(params.getControlCoefficient().getControlLimitD4());
        BigDecimal cl = !HussarUtils.isEmpty((Object)params.getCl()) ? new BigDecimal(params.getCl()) : XMedRControlChartUtil.calculateXMedChartCL(valueList);
        BigDecimal rcGroup = XMedRControlChartUtil.calculateRChartCL(valueList);
        BigDecimal rcl = !HussarUtils.isEmpty((Object)params.getClr()) ? new BigDecimal(params.getClr()) : rcGroup;
        BigDecimal sigmaTotal = CommonUtil.calculateOverallSigma(totalValueList);
        BigDecimal sigmaGroup = XMedRControlChartUtil.estimateProcessStdevByRBar((BigDecimal)rcGroup, (BigDecimal)d2);
        BigDecimal ucl = !HussarUtils.isEmpty((Object)params.getUcl()) ? new BigDecimal(params.getUcl()) : XMedRControlChartUtil.calculateXMedChartUCL((BigDecimal)cl, (BigDecimal)A2, (BigDecimal)rcl);
        BigDecimal lcl = !HussarUtils.isEmpty((Object)params.getLcl()) ? new BigDecimal(params.getLcl()) : XMedRControlChartUtil.calculateXMedChartLCL((BigDecimal)cl, (BigDecimal)A2, (BigDecimal)rcl);
        BigDecimal rUcl = !HussarUtils.isEmpty((Object)params.getUclr()) ? new BigDecimal(params.getUclr()) : XMedRControlChartUtil.calculateRChartUCL((BigDecimal)D4, (BigDecimal)rcl);
        BigDecimal rLcl = !HussarUtils.isEmpty((Object)params.getLclr()) ? new BigDecimal(params.getLclr()) : XMedRControlChartUtil.calculateRChartLCL((BigDecimal)D3, (BigDecimal)rcl);
        BigDecimal sigmaXMed = CommonUtil.calculateChartStdev((BigDecimal)ucl, (BigDecimal)lcl, (BigDecimal)cl);
        BigDecimal sigmaR = CommonUtil.calculateChartStdev((BigDecimal)rUcl, (BigDecimal)rLcl, (BigDecimal)rcl);
        int batchCount = valueList.size();
        Long belowLslCount = LSL != null ? Long.valueOf(totalValueList.stream().filter(data -> data.compareTo(LSL) < 0).count()) : null;
        Long aboveUslCount = USL != null ? Long.valueOf(totalValueList.stream().filter(data -> data.compareTo(USL) > 0).count()) : null;
        ControlChartDataVO controlChartDataVO = new ControlChartDataVO();
        controlChartDataVO.setUcl(ucl.toPlainString());
        controlChartDataVO.setLcl(lcl.toPlainString());
        controlChartDataVO.setCl(cl.toPlainString());
        controlChartDataVO.setRucl(rUcl.toPlainString());
        controlChartDataVO.setRlcl(rLcl.toPlainString());
        controlChartDataVO.setRcl(rcl.toPlainString());
        controlChartDataVO.setSigmaXMed(sigmaXMed.toPlainString());
        controlChartDataVO.setSigmaR(sigmaR.toPlainString());
        controlChartDataVO.setBatchCount(batchCount);
        controlChartDataVO.setSigmaGroup(sigmaGroup.toPlainString());
        controlChartDataVO.setSigmaTotal(sigmaTotal.toPlainString());
        controlChartDataVO.setAboveUslCount(aboveUslCount);
        controlChartDataVO.setBelowLslCount(belowLslCount);
        analysisResultVO.setControlChartDataVO(controlChartDataVO);
    }
}

