/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.strategy;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.BinomialProbability;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.Boxplot;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.NormalTest;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ProcessCapability;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import com.jxdinfo.spc.core.analysisManage.analysisTool.dto.AnalysisContextDTO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.dto.BasicStatisticDataDto;
import com.jxdinfo.spc.core.analysisManage.analysisTool.dto.KlmValueDto;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.AnomalyAnalysisResult;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.ChartStatistic;
import com.jxdinfo.spc.core.analysisManage.analysisTool.service.SpcService;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.CapacityVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.FittingActualPointVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.NormalCurvePointVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.PointVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.PpmDataVO;
import com.jxdinfo.spc.core.analysisManage.relationRule.vo.RelationRuleVO;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import com.jxdinfo.spc.formula.api.util.quantity.BinomialProbabilityUtil;
import com.jxdinfo.spc.formula.api.util.quantity.CapabilityUtil;
import com.jxdinfo.spc.formula.api.util.quantity.FittingNormalUtil;
import com.jxdinfo.spc.formula.api.util.quantity.XMedRControlChartUtil;
import com.jxdinfo.spc.formula.api.util.quantity.entity.NormalCurvePoint;
import com.jxdinfo.spc.formula.api.util.quantity.entity.NormalPlotResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public abstract class ControlChartStrategy {
    private final AnalysisContextDTO analysisContext = new AnalysisContextDTO();
    private final SpcService spcService;

    protected ControlChartStrategy(SpcService spcService) {
        if (spcService == null) {
            throw new HussarException("SpcService\u6ce8\u5165\u5931\u8d25");
        }
        this.spcService = spcService;
    }

    protected List<List<AnalysisDataSource>> getSourceNodeList() {
        return Collections.unmodifiableList(this.analysisContext.getSourceNodeList());
    }

    protected List<List<String>> getNodeList() {
        return Collections.unmodifiableList(this.analysisContext.getNodeList());
    }

    protected List<String> getTotalNodeList() {
        return Collections.unmodifiableList(this.analysisContext.getTotalNodeList());
    }

    protected List<List<BigDecimal>> getNodeBigList() {
        return Collections.unmodifiableList(this.analysisContext.getNodeBigList());
    }

    protected List<BigDecimal> getTotalNodeBigList() {
        return Collections.unmodifiableList(this.analysisContext.getTotalNodeBigList());
    }

    protected AnalysisParamDto getAnalysisParam() {
        return this.analysisContext.getAnalysisParam();
    }

    protected SpcService getSpcService() {
        return this.spcService;
    }

    protected List<Integer> getFailNodeList() {
        return Collections.unmodifiableList(this.analysisContext.getFailNodeList());
    }

    protected List<List<Integer>> getFailNodeGroupList() {
        return Collections.unmodifiableList(this.analysisContext.getFailNodeGroupList());
    }

    protected List<Integer> getDetectNodeList() {
        return Collections.unmodifiableList(this.analysisContext.getDetectNodeList());
    }

    protected List<List<Integer>> getDetectNodeGroupList() {
        return Collections.unmodifiableList(this.analysisContext.getDetectNodeGroupList());
    }

    public void handleBasicCalculationData(AnalysisParamDto analysisParam) {
        this.analysisContext.setAnalysisParam(analysisParam);
        BasicStatisticDataDto basicStatisticDataDto = this.spcService.getBasicStatisticData(analysisParam);
        this.analysisContext.setSourceNodeList(basicStatisticDataDto.getSourceNodeList());
        if ("0".equals(analysisParam.getDataType())) {
            this.analysisContext.setNodeList(basicStatisticDataDto.getNodeList());
            this.analysisContext.setTotalNodeList(basicStatisticDataDto.getTotalNodeList());
            this.analysisContext.setNodeBigList(basicStatisticDataDto.getNodeBigList());
            this.analysisContext.setTotalNodeBigList(basicStatisticDataDto.getTotalNodeBigList());
        } else {
            this.analysisContext.setFailNodeGroupList(basicStatisticDataDto.getFailNodeGroupList());
            this.analysisContext.setDetectNodeGroupList(basicStatisticDataDto.getDetectNodeGroupList());
            this.analysisContext.setFailNodeList(basicStatisticDataDto.getFailNodeList());
            this.analysisContext.setDetectNodeList(basicStatisticDataDto.getDetectNodeList());
        }
    }

    public abstract void dataCheck();

    protected void commonDataChecked() {
        AnalysisParamDto analysisParam = this.getAnalysisParam();
        String usl = analysisParam.getUsl();
        String lsl = analysisParam.getLsl();
        if (HussarUtils.isEmpty((Object)usl) && HussarUtils.isEmpty((Object)lsl)) {
            throw new HussarException("\u89c4\u683c\u4e0a\u9650USL\u548c\u89c4\u683c\u4e0b\u9650LSL\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (!HussarUtils.isEmpty((Object)usl) && !HussarUtils.isEmpty((Object)lsl) && Calc.getBigDecimal((Object)usl).compareTo(Calc.getBigDecimal((Object)lsl)) <= 0) {
            throw new HussarException("\u89c4\u683c\u4e0a\u9650USL\u5fc5\u987b\u5927\u4e8e\u89c4\u683c\u4e0b\u9650LSL\uff01");
        }
    }

    public abstract void generateControlData(AnalysisResultVO var1);

    public void generateProcessCapability(AnalysisResultVO analysisResultVO) {
        BigDecimal ppk;
        BigDecimal cpk;
        List<BigDecimal> totalNodeList = this.getTotalNodeBigList();
        List<List<BigDecimal>> nodeBigList = this.getNodeBigList();
        ProcessCapability processCapability = new ProcessCapability();
        AnalysisParamDto analysisParam = this.getAnalysisParam();
        int decimalNum = analysisParam.getDecimalNum();
        BigDecimal usl = StringUtils.isNotEmpty((CharSequence)analysisParam.getUsl()) ? new BigDecimal(analysisParam.getUsl()) : null;
        BigDecimal lsl = StringUtils.isNotEmpty((CharSequence)analysisParam.getLsl()) ? new BigDecimal(analysisParam.getLsl()) : null;
        BigDecimal sl = StringUtils.isNotEmpty((CharSequence)analysisParam.getSl()) ? new BigDecimal(analysisParam.getSl()) : null;
        BigDecimal cl = new BigDecimal(analysisResultVO.getControlChartDataVO().getCl());
        BigDecimal sigmaGroup = new BigDecimal(analysisResultVO.getControlChartDataVO().getSigmaGroup());
        int dataCount = totalNodeList.size();
        Integer batchCount = analysisResultVO.getControlChartDataVO().getBatchCount();
        BigDecimal totalAvg = CommonUtil.getAverage(totalNodeList);
        BigDecimal sigmaTotal = new BigDecimal(analysisResultVO.getControlChartDataVO().getSigmaTotal());
        Long aboveUslCount = analysisResultVO.getControlChartDataVO().getAboveUslCount();
        Long belowLslCount = analysisResultVO.getControlChartDataVO().getBelowLslCount();
        BigDecimal Cp = null;
        BigDecimal pp = null;
        if (usl != null && lsl != null) {
            if (HussarUtils.isNotEmpty((Object)sigmaGroup)) {
                Cp = CapabilityUtil.cp((BigDecimal)usl, (BigDecimal)lsl, (BigDecimal)sigmaGroup);
            }
            if (HussarUtils.isNotEmpty((Object)sigmaTotal)) {
                pp = CapabilityUtil.pp((BigDecimal)usl, (BigDecimal)lsl, (BigDecimal)sigmaTotal);
            }
        }
        BigDecimal Cpu = null;
        BigDecimal ppu = null;
        if (usl != null) {
            if (HussarUtils.isNotEmpty((Object)sigmaGroup) && HussarUtils.isNotEmpty((Object)totalAvg)) {
                Cpu = CapabilityUtil.cpu((BigDecimal)usl, (BigDecimal)totalAvg, (BigDecimal)sigmaGroup);
            }
            if (HussarUtils.isNotEmpty((Object)sigmaGroup) && HussarUtils.isNotEmpty((Object)totalAvg)) {
                ppu = CapabilityUtil.ppu((BigDecimal)usl, (BigDecimal)totalAvg, (BigDecimal)sigmaTotal);
            }
        }
        BigDecimal Cpl = null;
        BigDecimal ppl = null;
        if (lsl != null) {
            if (HussarUtils.isNotEmpty((Object)sigmaGroup) && HussarUtils.isNotEmpty((Object)totalAvg)) {
                Cpl = CapabilityUtil.cpl((BigDecimal)lsl, (BigDecimal)totalAvg, (BigDecimal)sigmaGroup);
            }
            if (HussarUtils.isNotEmpty((Object)sigmaGroup) && HussarUtils.isNotEmpty((Object)totalAvg)) {
                ppl = CapabilityUtil.ppl((BigDecimal)lsl, (BigDecimal)totalAvg, (BigDecimal)sigmaTotal);
            }
        }
        if (usl == null) {
            cpk = Cpl;
            ppk = ppl;
        } else if (lsl == null) {
            cpk = Cpu;
            ppk = ppu;
        } else {
            cpk = CapabilityUtil.cpk((BigDecimal)usl, (BigDecimal)lsl, (BigDecimal)Cpu, (BigDecimal)Cpl);
            ppk = CapabilityUtil.ppk((BigDecimal)usl, (BigDecimal)lsl, (BigDecimal)ppu, (BigDecimal)ppl);
        }
        BigDecimal cv = null;
        if (HussarUtils.isNotEmpty((Object)sigmaTotal) && HussarUtils.isNotEmpty((Object)totalAvg)) {
            cv = CapabilityUtil.cov((BigDecimal)sigmaTotal, (BigDecimal)totalAvg);
        }
        BigDecimal ca = null;
        BigDecimal cpm = null;
        if (usl != null && lsl != null && HussarUtils.isNotEmpty((Object)totalAvg)) {
            ca = CapabilityUtil.ca((BigDecimal)usl, (BigDecimal)lsl, (BigDecimal)totalAvg);
        }
        if (HussarUtils.isNotEmpty(nodeBigList) && HussarUtils.isNotEmpty((Object)sl)) {
            cpm = CapabilityUtil.cpm((BigDecimal)usl, (BigDecimal)lsl, (BigDecimal)sl, nodeBigList, (BigDecimal)new BigDecimal("6"));
        }
        PpmDataVO ppmDataVO = new PpmDataVO();
        BigDecimal ppmLsl = null;
        if (HussarUtils.isNotEmpty((Object)belowLslCount) && HussarUtils.isNotEmpty((Object)dataCount)) {
            ppmLsl = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)CapabilityUtil.belowSpecificationObservationPercentage((BigDecimal)new BigDecimal(belowLslCount), (BigDecimal)new BigDecimal(dataCount))), (Integer)decimalNum, (Boolean)true);
        }
        BigDecimal ppmUsl = null;
        if (HussarUtils.isNotEmpty((Object)aboveUslCount) && HussarUtils.isNotEmpty((Object)dataCount)) {
            ppmUsl = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)CapabilityUtil.aboveSpecificationObservationPercentage((BigDecimal)new BigDecimal(aboveUslCount), (BigDecimal)new BigDecimal(dataCount))), (Integer)decimalNum, (Boolean)true);
        }
        BigDecimal ppmTotal = null;
        if ((HussarUtils.isNotEmpty((Object)belowLslCount) || HussarUtils.isNotEmpty((Object)aboveUslCount)) && HussarUtils.isNotEmpty((Object)dataCount)) {
            belowLslCount = belowLslCount == null ? 0L : belowLslCount;
            aboveUslCount = aboveUslCount == null ? 0L : aboveUslCount;
            ppmTotal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)CapabilityUtil.exceedingSpecificationObservationPercentage((BigDecimal)new BigDecimal(belowLslCount), (BigDecimal)new BigDecimal(aboveUslCount), (BigDecimal)new BigDecimal(dataCount))), (Integer)decimalNum, (Boolean)true);
        }
        BigDecimal exPpmLslGroup = null;
        if (lsl != null && HussarUtils.isNotEmpty((Object)totalAvg) && HussarUtils.isNotEmpty((Object)sigmaGroup)) {
            exPpmLslGroup = CapabilityUtil.belowSpecificationGroupPercentage((BigDecimal)lsl, (BigDecimal)totalAvg, (BigDecimal)sigmaGroup);
        }
        BigDecimal exPpmUslGroup = null;
        if (usl != null && HussarUtils.isNotEmpty((Object)totalAvg) && HussarUtils.isNotEmpty((Object)sigmaGroup)) {
            exPpmUslGroup = CapabilityUtil.aboveSpecificationGroupPercentage((BigDecimal)usl, (BigDecimal)totalAvg, (BigDecimal)sigmaGroup);
        }
        String exPpmLslGroupStr = exPpmLslGroup == null ? "" : Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal(exPpmLslGroup), (Integer)decimalNum, (Boolean)true).toPlainString();
        String exPpmUslGroupStr = exPpmUslGroup == null ? "" : Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal(exPpmUslGroup), (Integer)decimalNum, (Boolean)true).toPlainString();
        String exPpmTotalGroup = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)CapabilityUtil.exceedingSpecificationGroupPercentage((BigDecimal)exPpmLslGroup, (BigDecimal)exPpmUslGroup)), (Integer)decimalNum, (Boolean)true).toPlainString();
        BigDecimal exPpmLsl = null;
        if (lsl != null && HussarUtils.isNotEmpty((Object)totalAvg) && HussarUtils.isNotEmpty((Object)sigmaGroup)) {
            exPpmLsl = CapabilityUtil.belowSpecificationGroupPercentage((BigDecimal)lsl, (BigDecimal)totalAvg, (BigDecimal)sigmaTotal);
        }
        BigDecimal exPpmUsl = null;
        if (usl != null && HussarUtils.isNotEmpty((Object)totalAvg) && HussarUtils.isNotEmpty((Object)sigmaGroup)) {
            exPpmUsl = CapabilityUtil.aboveSpecificationGroupPercentage((BigDecimal)usl, (BigDecimal)totalAvg, (BigDecimal)sigmaTotal);
        }
        String exPpmLslStr = exPpmLsl == null ? "" : Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal(exPpmLsl), (Integer)decimalNum, (Boolean)true).toPlainString();
        String exPpmUslStr = exPpmUsl == null ? "" : Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal(exPpmUsl), (Integer)decimalNum, (Boolean)true).toPlainString();
        String exPpmTotal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)CapabilityUtil.exceedingSpecificationGroupPercentage((BigDecimal)exPpmLsl, (BigDecimal)exPpmUsl)), (Integer)decimalNum, (Boolean)true).toPlainString();
        ppmDataVO.setPpmLsl(ppmLsl == null ? "" : ppmLsl.toPlainString());
        ppmDataVO.setPpmUsl(ppmUsl == null ? "" : ppmUsl.toPlainString());
        ppmDataVO.setPpmTotal(ppmTotal == null ? "" : ppmTotal.toPlainString());
        ppmDataVO.setExPpmLslGroup(exPpmLslGroupStr);
        ppmDataVO.setExPpmUslGroup(exPpmUslGroupStr);
        ppmDataVO.setExPpmTotalGroup(exPpmTotalGroup);
        ppmDataVO.setExPpmLsl(exPpmLslStr);
        ppmDataVO.setExPpmUsl(exPpmUslStr);
        ppmDataVO.setExPpmTotal(exPpmTotal);
        List histogramBarList = null;
        if (HussarUtils.isNotEmpty(totalNodeList)) {
            histogramBarList = CapabilityUtil.generateProcessHistogram(totalNodeList, (BigDecimal)usl, (BigDecimal)lsl);
        }
        NormalCurvePoint normalCurvePointList = null;
        if (HussarUtils.isNotEmpty((Object)totalAvg) && HussarUtils.isNotEmpty((Object)sigmaTotal) && HussarUtils.isNotEmpty((Object)sigmaGroup) && HussarUtils.isNotEmpty((Object)histogramBarList) && HussarUtils.isNotEmpty(totalNodeList)) {
            normalCurvePointList = CapabilityUtil.generateNormalCurves(totalNodeList, (BigDecimal)Calc.getBigDecimal((Object)totalAvg), (BigDecimal)Calc.getBigDecimal((Object)sigmaTotal), (BigDecimal)Calc.getBigDecimal((Object)sigmaGroup), (int)decimalNum, (List)histogramBarList, (BigDecimal)usl, (BigDecimal)lsl);
        }
        int startIndex = Math.max(0, nodeBigList.size() - 25);
        List lastDataList = IntStream.range(startIndex, nodeBigList.size()).mapToObj(nodeBigList::get).map(list -> list.stream().distinct().collect(Collectors.toList())).collect(Collectors.toList());
        ArrayList<String> lastXList = new ArrayList<String>();
        ArrayList<String> lastYList = new ArrayList<String>();
        for (int i = 0; i < lastDataList.size(); ++i) {
            List nodeBig = (List)lastDataList.get(i);
            int finalI = i + startIndex;
            nodeBig.forEach(node -> {
                lastXList.add(String.valueOf(finalI + 1));
                lastYList.add(Calc.tidyDecimal((BigDecimal)node, (Integer)decimalNum, (Boolean)true).toPlainString());
            });
        }
        PointVO pointVO = new PointVO();
        pointVO.setX(lastXList);
        pointVO.setY(lastYList);
        processCapability.setLastData(JSONObject.toJSONString((Object)pointVO));
        ArrayList<String> capacityTotalList = new ArrayList<String>();
        ArrayList<String> capacityGroupList = new ArrayList<String>();
        CapacityVO capacityVO = new CapacityVO();
        if (HussarUtils.isNotEmpty((Object)cl) && HussarUtils.isNotEmpty((Object)sigmaTotal)) {
            capacityTotalList.add(Calc.tidyDecimal((BigDecimal)cl.subtract(sigmaTotal.multiply(BigDecimal.valueOf(3L))), (Integer)decimalNum, (Boolean)true).toPlainString());
            capacityTotalList.add(Calc.tidyDecimal((BigDecimal)cl, (Integer)decimalNum, (Boolean)true).toPlainString());
            capacityTotalList.add(Calc.tidyDecimal((BigDecimal)cl.add(sigmaTotal.multiply(BigDecimal.valueOf(3L))), (Integer)decimalNum, (Boolean)true).toPlainString());
            capacityVO.setCapacityTotal(capacityTotalList);
        }
        if (HussarUtils.isNotEmpty((Object)cl) && HussarUtils.isNotEmpty((Object)sigmaGroup)) {
            capacityGroupList.add(Calc.tidyDecimal((BigDecimal)cl.subtract(sigmaGroup.multiply(BigDecimal.valueOf(3L))), (Integer)decimalNum, (Boolean)true).toPlainString());
            capacityGroupList.add(Calc.tidyDecimal((BigDecimal)cl, (Integer)decimalNum, (Boolean)true).toPlainString());
            capacityGroupList.add(Calc.tidyDecimal((BigDecimal)cl.add(sigmaGroup.multiply(BigDecimal.valueOf(3L))), (Integer)decimalNum, (Boolean)true).toPlainString());
            capacityVO.setCapacityGroup(capacityGroupList);
        }
        if (HussarUtils.isNotEmpty((Object)capacityVO)) {
            processCapability.setCapacity(JSONObject.toJSONString((Object)capacityVO));
        }
        processCapability.setAnalysisId(analysisParam.getAnalysisId());
        if (Cp != null) {
            processCapability.setCp(Calc.tidyDecimal((BigDecimal)Cp, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (Cpu != null) {
            processCapability.setCpu(Calc.tidyDecimal((BigDecimal)Cpu, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (Cpl != null) {
            processCapability.setCpl(Calc.tidyDecimal((BigDecimal)Cpl, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (cpk != null) {
            processCapability.setCpk(Calc.tidyDecimal((BigDecimal)cpk, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (pp != null) {
            processCapability.setPp(Calc.tidyDecimal((BigDecimal)pp, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (ppu != null) {
            processCapability.setPpu(Calc.tidyDecimal((BigDecimal)ppu, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (ppl != null) {
            processCapability.setPpl(Calc.tidyDecimal((BigDecimal)ppl, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (ppk != null) {
            processCapability.setPpk(Calc.tidyDecimal((BigDecimal)ppk, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (cv != null) {
            processCapability.setCv(Calc.tidyDecimal((BigDecimal)cv, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (ca != null) {
            processCapability.setCa(Calc.tidyDecimal((BigDecimal)ca, (Integer)decimalNum, (Boolean)true).toPlainString() + '%');
        }
        if (cpm != null) {
            processCapability.setCpm(Calc.tidyDecimal((BigDecimal)cpm, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (usl != null) {
            processCapability.setUsl(Calc.tidyDecimal((BigDecimal)usl, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (lsl != null) {
            processCapability.setLsl(Calc.tidyDecimal((BigDecimal)lsl, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        if (sl != null) {
            processCapability.setTv(Calc.tidyDecimal((BigDecimal)sl, (Integer)decimalNum, (Boolean)true).toPlainString());
        }
        processCapability.setSampleAvg(Calc.tidyDecimal((BigDecimal)totalAvg, (Integer)decimalNum, (Boolean)true).toPlainString());
        processCapability.setSampleNum(dataCount);
        processCapability.setSigmaTotal(Calc.tidyDecimal((BigDecimal)sigmaTotal, (Integer)decimalNum, (Boolean)true).toPlainString());
        processCapability.setSigmaGroup(Calc.tidyDecimal((BigDecimal)sigmaGroup, (Integer)decimalNum, (Boolean)true).toPlainString());
        processCapability.setPerformance(JSONObject.toJSONString((Object)ppmDataVO));
        if (HussarUtils.isNotEmpty((Object)histogramBarList)) {
            processCapability.setProcessColumn(JSONObject.toJSONString((Object)histogramBarList));
        }
        if (HussarUtils.isNotEmpty((Object)normalCurvePointList)) {
            NormalCurvePointVO normalCurvePointVO = new NormalCurvePointVO();
            List<String> xList = normalCurvePointList.getX().stream().map(BigDecimal::toPlainString).collect(Collectors.toList());
            List<String> overallDensityList = normalCurvePointList.getOverallDensity().stream().map(BigDecimal::toPlainString).collect(Collectors.toList());
            List<String> withinDensityList = normalCurvePointList.getWithinDensity().stream().map(BigDecimal::toPlainString).collect(Collectors.toList());
            normalCurvePointVO.setX(xList);
            normalCurvePointVO.setOverallDensity(overallDensityList);
            normalCurvePointVO.setWithinDensity(withinDensityList);
            processCapability.setProcessCurve(JSONObject.toJSONString((Object)normalCurvePointVO));
        }
        processCapability.setCreateTime(analysisParam.getCreateTime());
        processCapability.setCreator(analysisParam.getCreator());
        processCapability.setCreatorName(analysisParam.getCreatorName());
        analysisResultVO.setProcessCapability(processCapability);
    }

    public void generateFittingNormalChart(AnalysisResultVO analysisResultVO) {
        NormalTest normalTest = new NormalTest();
        AnalysisParamDto analysisParam = this.getAnalysisParam();
        List<BigDecimal> totalNodeList = this.getTotalNodeBigList();
        List<List<BigDecimal>> totalNodeBigList = this.getNodeBigList();
        int decimalNum = analysisParam.getDecimalNum();
        List<Object> dataList = "xs".equals(analysisParam.getChartType()) || "xr".equals(analysisParam.getChartType()) ? totalNodeBigList.stream().map(batch -> Calc.tidyDecimal((BigDecimal)CommonUtil.getAverage((List)batch), (Integer)decimalNum, (Boolean)true)).collect(Collectors.toList()) : ("x_r".equals(analysisParam.getChartType()) ? this.xMedChartAnalysis(totalNodeBigList) : new ArrayList<BigDecimal>(totalNodeList));
        normalTest.setAnalysisId(analysisParam.getAnalysisId());
        normalTest.setCreateTime(analysisParam.getCreateTime());
        normalTest.setCreator(analysisParam.getCreator());
        normalTest.setCreatorName(analysisParam.getCreatorName());
        if (HussarUtils.isNotEmpty(dataList)) {
            String totalAvg = analysisResultVO.getProcessCapability().getSampleAvg();
            normalTest.setAvgValue(totalAvg);
            BigDecimal avgValue = Calc.getBigDecimal((Object)totalAvg);
            BigDecimal sigmaTotalBig = Calc.getBigDecimal((Object)Math.sqrt(dataList.stream().mapToDouble(x -> Math.pow(x.subtract(avgValue).doubleValue(), 2.0)).sum() / (double)(dataList.size() - 1)));
            if (dataList.size() >= 3 && sigmaTotalBig.compareTo(BigDecimal.ZERO) != 0) {
                String sigmaTotal = Calc.tidyDecimal((BigDecimal)sigmaTotalBig, (Integer)decimalNum, (Boolean)true).toPlainString();
                normalTest.setSigmaValue(sigmaTotal);
                Integer n = dataList.size();
                normalTest.setnValue(String.valueOf(n));
                BigDecimal ad = FittingNormalUtil.calculateADStat(dataList, (BigDecimal)Calc.getBigDecimal((Object)totalAvg), (BigDecimal)Calc.getBigDecimal((Object)sigmaTotal));
                BigDecimal pValue = FittingNormalUtil.estimatePValue((BigDecimal)ad, (int)n);
                normalTest.setAdValue(String.valueOf(Calc.tidyDecimal((BigDecimal)ad, (Integer)decimalNum, (Boolean)true)));
                normalTest.setpValue(String.valueOf(Calc.tidyDecimal((BigDecimal)pValue, (Integer)decimalNum, (Boolean)true)));
                NormalPlotResult generateReferenceLine = FittingNormalUtil.calculateNormalPlotData(dataList, (BigDecimal)Calc.getBigDecimal((Object)totalAvg), (BigDecimal)Calc.getBigDecimal((Object)sigmaTotal), (int)decimalNum);
                List<String> x2 = generateReferenceLine.getTheoreticalQuantiles().stream().map(BigDecimal::toPlainString).collect(Collectors.toList());
                List<String> actualPercent = generateReferenceLine.getActualZScores().stream().map(BigDecimal::toPlainString).collect(Collectors.toList());
                NormalPlotResult idealPointList = FittingNormalUtil.calculateRegressionParams((BigDecimal)avgValue, (BigDecimal)Calc.getBigDecimal((Object)sigmaTotal), (int)decimalNum);
                List<String> idealXAxisData = idealPointList.getTheoreticalQuantiles().stream().map(BigDecimal::toPlainString).collect(Collectors.toList());
                List<String> idealYAxisData = idealPointList.getActualZScores().stream().map(BigDecimal::toPlainString).collect(Collectors.toList());
                FittingActualPointVO idealPointVO = new FittingActualPointVO();
                idealPointVO.setxRealityPoint(idealXAxisData);
                idealPointVO.setyRealityPoint(idealYAxisData);
                FittingActualPointVO actualPointVO = new FittingActualPointVO();
                actualPointVO.setxRealityPoint(x2);
                actualPointVO.setyRealityPoint(actualPercent);
                normalTest.setRealityPoint(JSONObject.toJSONString((Object)actualPointVO));
                normalTest.setIdealFitting(JSONObject.toJSONString((Object)idealPointVO));
                analysisResultVO.setNormalTest(normalTest);
            } else {
                analysisResultVO.setNormalTest(normalTest);
            }
        } else {
            analysisResultVO.setNormalTest(normalTest);
        }
    }

    public void generateBinomialChart(AnalysisResultVO analysisResultVO) {
        List<Integer> failList = this.getFailNodeList();
        List<Integer> detectList = this.getDetectNodeList();
        AnalysisParamDto analysisParam = this.getAnalysisParam();
        int decimalNum = analysisParam.getDecimalNum();
        BinomialProbability binomialProbability = new BinomialProbability();
        binomialProbability.setAnalysisId(analysisParam.getAnalysisId());
        binomialProbability.setCreateTime(analysisParam.getCreateTime());
        binomialProbability.setCreator(analysisParam.getCreator());
        binomialProbability.setCreatorName(analysisParam.getCreatorName());
        if (HussarUtils.isNotEmpty(failList) && HussarUtils.isNotEmpty(detectList)) {
            BigDecimal nBar = Calc.getBigDecimal((Object)BinomialProbabilityUtil.calculateNBar(detectList));
            BigDecimal pBar = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)BinomialProbabilityUtil.calculatePBar(failList, detectList)), (Integer)4, (Boolean)true);
            List scatterData = BinomialProbabilityUtil.calculateScatterData(failList, detectList, (BigDecimal)nBar, (int)decimalNum);
            BigDecimal binomialStdDev = BinomialProbabilityUtil.calculateSampleStdDev((BigDecimal)nBar);
            BigDecimal regressionDev = BinomialProbabilityUtil.calculateObservedVariation((List)scatterData);
            BigDecimal sampleStdDev = Calc.tidyDecimal((BigDecimal)regressionDev, (Integer)6, (Boolean)true);
            BigDecimal variationRatio = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)(sampleStdDev.doubleValue() / Calc.tidyDecimal((BigDecimal)binomialStdDev, (Integer)8, (Boolean)true).doubleValue() * 100.0)), (Integer)1, (Boolean)true);
            BigDecimal limit = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)(Math.exp(0.185 + 5.62 / (double)failList.size() + 0.274 / (pBar.doubleValue() * nBar.doubleValue())) * 100.0)), (Integer)1, (Boolean)true);
            List<String> xAxisData = scatterData.stream().map(x -> Calc.tidyDecimal((BigDecimal)x.getX(), (Integer)decimalNum, (Boolean)true).toPlainString()).collect(Collectors.toList());
            List<String> yAxisData = scatterData.stream().map(y -> Calc.tidyDecimal((BigDecimal)y.getY(), (Integer)decimalNum, (Boolean)true).toPlainString()).collect(Collectors.toList());
            List xList = scatterData.stream().map(x -> x.getX().doubleValue()).collect(Collectors.toList());
            double mean = xList.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            double std = Math.sqrt(xList.stream().mapToDouble(x -> Math.pow(x - mean, 2.0)).sum() / (double)(xList.size() - 1));
            NormalPlotResult idealPointList = FittingNormalUtil.calculateRegressionParams((BigDecimal)Calc.getBigDecimal((Object)mean), (BigDecimal)Calc.getBigDecimal((Object)std), (int)decimalNum);
            List<String> z = idealPointList.getTheoreticalQuantiles().stream().map(BigDecimal::toPlainString).collect(Collectors.toList());
            List<String> idealYList = idealPointList.getzList().stream().map(BigDecimal::toPlainString).collect(Collectors.toList());
            FittingActualPointVO idealPointVO = new FittingActualPointVO();
            idealPointVO.setxRealityPoint(z);
            idealPointVO.setyRealityPoint(idealYList);
            FittingActualPointVO actualPointVO = new FittingActualPointVO();
            actualPointVO.setxRealityPoint(xAxisData);
            actualPointVO.setyRealityPoint(yAxisData);
            binomialProbability.setRealityPoint(JSONObject.toJSONString((Object)actualPointVO));
            binomialProbability.setIdealPoint(JSONObject.toJSONString((Object)idealPointVO));
            binomialProbability.setStdDev(sampleStdDev.toPlainString());
            binomialProbability.setBinomialStdDev(Calc.tidyDecimal((BigDecimal)binomialStdDev, (Integer)4, (Boolean)true).toPlainString());
            binomialProbability.setVariationRatio(variationRatio.toPlainString());
            binomialProbability.setConfidenceLimit(limit.toPlainString());
            analysisResultVO.setBinomialProbability(binomialProbability);
        } else {
            analysisResultVO.setBinomialProbability(binomialProbability);
        }
    }

    public void generateBoxplot(AnalysisResultVO analysisResultVO) {
        AnalysisParamDto analysisParam = this.getAnalysisParam();
        List<BigDecimal> totalNodeList = this.getTotalNodeBigList();
        List<List<BigDecimal>> nodeGroupList = this.getNodeBigList();
        List<Integer> failList = this.getFailNodeList();
        List<Integer> detectList = this.getDetectNodeList();
        List<Boxplot> boxplotList = this.getSpcService().generateBoxplot(analysisParam, totalNodeList, nodeGroupList, failList, detectList);
        analysisResultVO.setBoxplotList(boxplotList);
    }

    protected List<ChartStatistic> generateAnalysisChartStatistic(List<BigDecimal> chartData) {
        ArrayList<ChartStatistic> statisticList = new ArrayList<ChartStatistic>();
        for (int i = 0; i < chartData.size(); ++i) {
            ChartStatistic statistic = new ChartStatistic();
            statistic.setxControl(i + 1 + "");
            statistic.setControlNumber(i + 1);
            statistic.setyControl(Calc.tidyDecimal((BigDecimal)chartData.get(i), (Integer)4, (Boolean)true).toPlainString());
            statisticList.add(statistic);
        }
        return statisticList;
    }

    protected List<AbnormalData> generateAbnormalDataSource(List<ChartStatistic> statisticList, String ucl, String lcl, String cl, String chartType) {
        List<List<AnalysisDataSource>> sourceNodeList = this.getSourceNodeList();
        AnalysisParamDto analysisParam = this.getAnalysisParam();
        if (HussarUtils.isEmpty(statisticList)) {
            return new ArrayList<AbnormalData>();
        }
        ArrayList<AbnormalData> abnormalDataSourceList = new ArrayList<AbnormalData>();
        for (int i = 0; i < statisticList.size(); ++i) {
            if (!"1".equals(statisticList.get(i).getIsAbnormal())) continue;
            AbnormalData abnormalData = new AbnormalData();
            abnormalData.setUcl(ucl);
            abnormalData.setLcl(lcl);
            abnormalData.setCl(cl);
            abnormalData.setUsl(analysisParam.getUsl());
            abnormalData.setLsl(analysisParam.getLsl());
            abnormalData.setSl(analysisParam.getSl());
            abnormalData.setAnalysisId(analysisParam.getAnalysisId());
            abnormalData.setChartType(chartType);
            abnormalData.setAnalysisDataSource(JSONObject.toJSONString(sourceNodeList.get(i)));
            abnormalData.setAbnormalNum(statisticList.get(i).getyControl());
            abnormalData.setRuleDictId(statisticList.get(i).getRuleDictId());
            abnormalData.setJudgmentRuleExplain(statisticList.get(i).getJudgmentRuleName());
            abnormalData.setAbnormalReason(statisticList.get(i).getAbnormalReason());
            abnormalData.setCreatorName(analysisParam.getCreatorName());
            abnormalData.setLastEditorName(analysisParam.getCreatorName());
            abnormalData.setCreator(analysisParam.getCreator());
            abnormalData.setLastEditor(analysisParam.getCreator());
            abnormalData.setCreateTime(analysisParam.getCreateTime());
            abnormalData.setLastTime(analysisParam.getCreateTime());
            abnormalData.setHandleState("0");
            abnormalData.setAbnormalSort(statisticList.get(i).getControlNumber());
            abnormalData.setIsWarning(statisticList.get(i).getIsWarning());
            abnormalData.setRuleExplainKey(statisticList.get(i).getRuleExplainKey());
            abnormalData.setKlmValue(statisticList.get(i).getKlmValue());
            abnormalDataSourceList.add(abnormalData);
        }
        return abnormalDataSourceList;
    }

    protected ControlData generateControlData(String analysisType, List<ChartStatistic> statisticList, String ucl, String cl, String lcl) {
        AnalysisParamDto analysisParamDto = this.getAnalysisParam();
        ControlData xbarControlData = new ControlData();
        xbarControlData.setAnalysisId(analysisParamDto.getAnalysisId());
        xbarControlData.setChartType(analysisType);
        xbarControlData.setUcl(ucl);
        xbarControlData.setCl(cl);
        xbarControlData.setLcl(lcl);
        if (HussarUtils.isNotEmpty(statisticList)) {
            xbarControlData.setAnalysisResult(JSONObject.toJSONString(statisticList));
        }
        HashMap<String, List> ruleXControlMap = new HashMap<String, List>(statisticList.size());
        for (ChartStatistic statistic : statisticList) {
            String[] rules;
            String judgmentNames = statistic.getJudgmentName();
            String xControl = statistic.getxControl();
            if (judgmentNames == null || judgmentNames.trim().isEmpty() || xControl == null || xControl.trim().isEmpty()) continue;
            for (String rule : rules = judgmentNames.split(";")) {
                if ((rule = rule.trim()).isEmpty()) continue;
                ruleXControlMap.computeIfAbsent(rule, k -> new ArrayList()).add(xControl.trim());
            }
        }
        ArrayList groupedByJudgment = new ArrayList(ruleXControlMap.size());
        for (Map.Entry entry : ruleXControlMap.entrySet()) {
            String ruleKey = (String)entry.getKey();
            List xControls = (List)entry.getValue();
            String[] relation = ruleKey.split("-");
            if (relation.length < 4) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            map.put("judgmentName", relation[0]);
            map.put("nodes", xControls);
            map.put("relationRuleId", relation[1]);
            map.put("ruleExplainKey", relation[2]);
            map.put("klmValue", relation[3]);
            groupedByJudgment.add(map);
        }
        if (HussarUtils.isNotEmpty(groupedByJudgment)) {
            xbarControlData.setJudgmentResult(JSONObject.toJSONString(groupedByJudgment));
        }
        xbarControlData.setCreateTime(analysisParamDto.getCreateTime());
        xbarControlData.setCreatorName(analysisParamDto.getCreatorName());
        xbarControlData.setCreator(analysisParamDto.getCreator());
        return xbarControlData;
    }

    protected List<ChartStatistic> generateData(List<BigDecimal> chartValueData, AnalysisParamDto param, String cl, String sigma) {
        List<ChartStatistic> chartStatisticList = this.generateAnalysisChartStatistic(chartValueData);
        AnomalyAnalysisResult anomalyResult = this.getSpcService().anomalyAnalysis(chartValueData, param, Calc.getBigDecimal((Object)cl), Calc.getBigDecimal((Object)sigma));
        if (HussarUtils.isEmpty(anomalyResult.getDataList())) {
            return chartStatisticList;
        }
        this.updateAbnormalInformation(chartStatisticList, anomalyResult.getDataList());
        return chartStatisticList;
    }

    protected void updateAbnormalInformation(List<ChartStatistic> analysisChartStatisticList, List<AnalysisNode> analysisNodeList) {
        List<RelationRuleVO> relationRuleEntities = this.getAnalysisParam().getRelationRuleList();
        if (analysisChartStatisticList.isEmpty() || analysisNodeList.isEmpty() || relationRuleEntities.isEmpty()) {
            return;
        }
        Map<Integer, RelationRuleVO> relationRuleMap = relationRuleEntities.stream().collect(Collectors.toMap(RelationRuleVO::getJudgmentDictNum, v -> v));
        for (int i = 0; i < analysisChartStatisticList.size(); ++i) {
            List<String> abnormalList = analysisNodeList.get(i).getAbnormalTags();
            List<String> abnormalNumList = analysisNodeList.get(i).getAbnormalNum();
            ChartStatistic statistic = analysisChartStatisticList.get(i);
            statistic.setIsAbnormal(abnormalList == null || abnormalList.isEmpty() ? "0" : "1");
            if (abnormalNumList == null || abnormalNumList.isEmpty()) continue;
            StringBuilder ruleDictBuilder = new StringBuilder();
            StringBuilder abnormalReasonBuilder = new StringBuilder();
            StringBuilder judgmentNameBuilder = new StringBuilder();
            StringBuilder judgmentRuleNameBuilder = new StringBuilder();
            StringBuilder ruleExplainKeyBuilder = new StringBuilder();
            ArrayList<KlmValueDto> klmValueDtos = new ArrayList<KlmValueDto>();
            int num = 1;
            String warningFlag = "0";
            for (int j = 0; j < abnormalNumList.size(); ++j) {
                Integer ruleNum = Integer.valueOf(abnormalNumList.get(j));
                RelationRuleVO ruleEntity = relationRuleMap.get(ruleNum);
                if (ruleEntity == null) continue;
                if ("0".equals(ruleEntity.getIsWarning())) {
                    warningFlag = "1";
                }
                ruleDictBuilder.append(ruleEntity.getRuleDictId());
                if (HussarUtils.isNotEmpty((Object)ruleEntity.getAbnormalReason())) {
                    abnormalReasonBuilder.append(ruleEntity.getAbnormalReason());
                }
                KlmValueDto klmValueDto = new KlmValueDto();
                if (HussarUtils.isNotEmpty((Object)ruleEntity.getkValue())) {
                    klmValueDto.setK(ruleEntity.getkValue());
                }
                if (HussarUtils.isNotEmpty((Object)ruleEntity.getlValue())) {
                    klmValueDto.setL(ruleEntity.getlValue());
                }
                if (HussarUtils.isNotEmpty((Object)ruleEntity.getmValue())) {
                    klmValueDto.setM(ruleEntity.getmValue());
                }
                if (HussarUtils.isNotEmpty((Object)ruleEntity.getJudgmentRuleExplain())) {
                    judgmentNameBuilder.append(ControlChartStrategy.getReplaceColumn(ruleEntity)).append("-").append(ruleEntity.getRelationRuleId()).append("-").append(ruleEntity.getRuleExplainKey()).append("-").append(JSONObject.toJSONString((Object)klmValueDto));
                }
                if (HussarUtils.isNotEmpty((Object)ruleEntity.getJudgmentRuleExplain())) {
                    judgmentRuleNameBuilder.append("\u3010").append(num).append("\u3011").append(ControlChartStrategy.getReplaceColumn(ruleEntity));
                    ++num;
                }
                if (HussarUtils.isNotEmpty((Object)ruleEntity.getRuleExplainKey())) {
                    ruleExplainKeyBuilder.append(ruleEntity.getRuleExplainKey());
                }
                klmValueDtos.add(klmValueDto);
                if (j >= abnormalNumList.size() - 1) continue;
                ruleDictBuilder.append(",");
                if (HussarUtils.isNotEmpty((Object)ruleEntity.getAbnormalReason())) {
                    abnormalReasonBuilder.append(",");
                }
                if (HussarUtils.isNotEmpty((Object)ruleEntity.getJudgmentRuleExplain())) {
                    judgmentNameBuilder.append(";");
                    judgmentRuleNameBuilder.append(";\n");
                }
                if (!HussarUtils.isNotEmpty((Object)ruleEntity.getRuleExplainKey())) continue;
                ruleExplainKeyBuilder.append(",");
            }
            String ruleDicts = ruleDictBuilder.toString();
            String abnormalReasons = abnormalReasonBuilder.toString();
            String judgmentNames = judgmentNameBuilder.toString();
            String judgmentRuleNames = judgmentRuleNameBuilder.toString();
            String ruleExplainKeys = ruleExplainKeyBuilder.toString();
            if (HussarUtils.isNotEmpty((Object)ruleDicts) && ruleDicts.endsWith(",")) {
                ruleDicts = ruleDicts.substring(0, ruleDicts.length() - 1);
            }
            if (HussarUtils.isNotEmpty((Object)abnormalReasons) && abnormalReasons.endsWith(",")) {
                abnormalReasons = abnormalReasons.substring(0, abnormalReasons.length() - 1);
            }
            if (HussarUtils.isNotEmpty((Object)judgmentNames) && judgmentNames.endsWith(",")) {
                judgmentNames = judgmentNames.substring(0, judgmentNames.length() - 1);
            }
            if (HussarUtils.isNotEmpty((Object)judgmentRuleNames) && judgmentRuleNames.endsWith(";\n")) {
                judgmentRuleNames = judgmentRuleNames.substring(0, judgmentRuleNames.length() - 1);
            }
            if (HussarUtils.isNotEmpty((Object)ruleExplainKeys) && ruleExplainKeys.endsWith(",")) {
                ruleExplainKeys = ruleExplainKeys.substring(0, ruleExplainKeys.length() - 1);
            }
            statistic.setRuleDictId(ruleDicts);
            statistic.setAbnormalReason(abnormalReasons);
            statistic.setJudgmentName(judgmentNames);
            statistic.setJudgmentRuleName(judgmentRuleNames);
            statistic.setIsWarning(warningFlag);
            statistic.setRuleExplainKey(ruleExplainKeys);
            statistic.setKlmValue(JSONObject.toJSONString(klmValueDtos));
        }
    }

    protected List<BigDecimal> xbarChartAnalysis(List<List<BigDecimal>> nodeValueList) {
        return nodeValueList.stream().map(batch -> {
            List collect = batch.stream().filter(b -> b.compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            return Calc.getBigDecimal((Object)CommonUtil.getAverage(collect));
        }).collect(Collectors.toList());
    }

    protected List<BigDecimal> rChartAnalysis(List<List<BigDecimal>> nodeValueList) {
        return nodeValueList.stream().map(batch -> Calc.getBigDecimal((Object)CommonUtil.getRange((List)batch))).collect(Collectors.toList());
    }

    protected List<BigDecimal> xMedChartAnalysis(List<List<BigDecimal>> nodeValueList) {
        return nodeValueList.stream().map(batch -> {
            List filteredBatch = batch.stream().filter(b -> b.compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            return Calc.getBigDecimal((Object)XMedRControlChartUtil.getMedian(filteredBatch));
        }).collect(Collectors.toList());
    }

    protected List<BigDecimal> countingChartAnalysis(List<Integer> failList, List<Integer> detectList, AnalysisParamDto param) {
        ArrayList<BigDecimal> countingList = new ArrayList<BigDecimal>(failList.size());
        for (int i = 0; i < failList.size(); ++i) {
            countingList.add(Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)(failList.get(i).doubleValue() / detectList.get(i).doubleValue())), (Integer)param.getDecimalNum(), (Boolean)true));
        }
        return countingList;
    }

    private static String getReplaceColumn(RelationRuleVO ruleEntity) {
        String ruleExplain = ruleEntity.getJudgmentRuleExplain();
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (ruleEntity.getkValue() != null) {
            replacements.put("${K}", ruleEntity.getkValue());
        }
        if (ruleEntity.getlValue() != null) {
            replacements.put("${L}", ruleEntity.getlValue());
        }
        if (ruleEntity.getmValue() != null) {
            replacements.put("${M}", ruleEntity.getmValue());
        }
        if (ruleEntity.getkValue() != null) {
            replacements.put("${K-1}", String.valueOf(Integer.parseInt(ruleEntity.getkValue()) - 1));
        }
        for (Map.Entry entry : replacements.entrySet()) {
            ruleExplain = ruleExplain.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return ruleExplain;
    }

    public boolean areAllElementsSame(List<Integer> detectList) {
        if (detectList == null) {
            return false;
        }
        if (detectList.size() <= 1) {
            return true;
        }
        Integer first = detectList.get(0);
        for (int i = 1; i < detectList.size(); ++i) {
            Integer current = detectList.get(i);
            if (Objects.equals(first, current)) continue;
            return false;
        }
        return true;
    }
}

