/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.strategy;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.ChartStatistic;
import com.jxdinfo.spc.core.analysisManage.analysisTool.service.SpcService;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.ControlChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.ControlChartDataVO;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.counting.CChartUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
@Lazy
public class CChartStrategy
extends ControlChartStrategy {
    public CChartStrategy(SpcService spcService) {
        super(spcService);
    }

    @Override
    public void dataCheck() {
        List<List<Integer>> failList = this.getFailNodeGroupList();
        List<List<Integer>> detectList = this.getDetectNodeGroupList();
        if (failList.get(0).size() != 1 || detectList.get(0).size() != 1) {
            throw new HussarException("C\u56fe\u5e94\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u5b50\u7ec4\uff01");
        }
    }

    @Override
    public void generateControlData(AnalysisResultVO analysisResultVO) {
        ArrayList<ControlData> controlDataList = new ArrayList<ControlData>();
        AnalysisParamDto param = this.getAnalysisParam();
        List<Integer> failList = this.getFailNodeList();
        BigDecimal cl = !HussarUtils.isEmpty((Object)param.getCl()) ? Calc.getBigDecimal((Object)param.getCl()) : CChartUtils.calculateCBar(failList);
        BigDecimal sigma = CChartUtils.calculateSigma((BigDecimal)cl);
        BigDecimal ucl = !HussarUtils.isEmpty((Object)param.getUcl()) ? Calc.getBigDecimal((Object)param.getUcl()) : CChartUtils.calculateUCL((BigDecimal)cl, (BigDecimal)sigma);
        BigDecimal lcl = !HussarUtils.isEmpty((Object)param.getLcl()) ? Calc.getBigDecimal((Object)param.getLcl()) : CChartUtils.calculateLCL((BigDecimal)cl, (BigDecimal)sigma);
        BigDecimal uclDecimal = Calc.tidyDecimal((BigDecimal)ucl, (Integer)param.getDecimalNum(), (Boolean)true);
        BigDecimal lclDecimal = Calc.tidyDecimal((BigDecimal)lcl, (Integer)param.getDecimalNum(), (Boolean)true);
        BigDecimal clDecimal = Calc.tidyDecimal((BigDecimal)cl, (Integer)param.getDecimalNum(), (Boolean)true);
        ControlChartDataVO controlChartDataVO = new ControlChartDataVO();
        controlChartDataVO.setCl(clDecimal.toPlainString());
        controlChartDataVO.setSigma(Calc.tidyDecimal((BigDecimal)sigma, (Integer)param.getDecimalNum(), (Boolean)true).toPlainString());
        controlChartDataVO.setUcl(uclDecimal.toPlainString());
        controlChartDataVO.setLcl(lclDecimal.toPlainString());
        List<BigDecimal> cList = failList.stream().map(Calc::getBigDecimal).collect(Collectors.toList());
        List<ChartStatistic> cStatisticList = this.generateData(cList, param, cl.toPlainString(), sigma.toPlainString());
        ControlData cControlData = this.generateControlData("10", cStatisticList, uclDecimal.toPlainString(), clDecimal.toPlainString(), lclDecimal.toPlainString());
        ArrayList<AbnormalData> allAbnormalDataList = new ArrayList<AbnormalData>();
        List<AbnormalData> pAnalysisDataSourceList = this.generateAbnormalDataSource(cStatisticList, uclDecimal.toPlainString(), lclDecimal.toPlainString(), clDecimal.toPlainString(), "10");
        if (HussarUtils.isNotEmpty(pAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(pAnalysisDataSourceList);
            analysisResultVO.setAbnormalData(allAbnormalDataList);
        }
        controlDataList.add(cControlData);
        analysisResultVO.setControlChartDataVO(controlChartDataVO);
        analysisResultVO.setControlData(controlDataList);
    }
}

