/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.Boxplot;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.Pattern;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.dto.AbnormalPatternDto;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.entity.PatternEntity;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.entity.PatternParam;
import com.jxdinfo.spc.core.analysisManage.analysisTool.dto.BasicStatisticDataDto;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.AnomalyAnalysisResult;
import com.jxdinfo.spc.core.analysisManage.analysisTool.service.SpcService;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.BoxplotGroupVO;
import com.jxdinfo.spc.core.analysisManage.relationRule.service.IRelationRuleService;
import com.jxdinfo.spc.core.analysisManage.relationRule.vo.RelationRuleVO;
import com.jxdinfo.spc.core.common.util.CommonUtils;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.quantity.BoxplotUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SpcServiceImpl
implements SpcService {
    @Resource
    private IRelationRuleService iRelationRuleService;

    @Override
    public AnomalyAnalysisResult anomalyAnalysis(List<BigDecimal> dataList, AnalysisParamDto params, BigDecimal cl, BigDecimal sigma) {
        AnomalyAnalysisResult result = new AnomalyAnalysisResult();
        List<RelationRuleVO> relationRuleEntities = params.getRelationRuleList();
        if (HussarUtils.isEmpty(relationRuleEntities)) {
            return result;
        }
        ArrayList<PatternEntity> patternEntities = new ArrayList<PatternEntity>();
        relationRuleEntities.forEach(relationRuleEntity -> {
            PatternEntity patternEntity = new PatternEntity();
            patternEntity.setName("pattern" + relationRuleEntity.getJudgmentDictNum());
            ArrayList<PatternParam> patternParams = new ArrayList<PatternParam>();
            patternParams.add(new PatternParam("kValue", relationRuleEntity.getkValue()));
            patternParams.add(new PatternParam("lValue", relationRuleEntity.getlValue()));
            patternParams.add(new PatternParam("mValue", relationRuleEntity.getmValue()));
            patternEntity.setParams(patternParams);
            patternEntities.add(patternEntity);
        });
        AbnormalPatternDto abnormalPatternDto = new AbnormalPatternDto();
        abnormalPatternDto.setCl(cl);
        abnormalPatternDto.setStdDev(sigma);
        if (HussarUtils.isNotEmpty((Object)params.getUsl())) {
            abnormalPatternDto.setUsl(Calc.getBigDecimal((Object)params.getUsl()));
        }
        if (HussarUtils.isNotEmpty((Object)params.getLsl())) {
            abnormalPatternDto.setLsl(Calc.getBigDecimal((Object)params.getLsl()));
        }
        if (HussarUtils.isNotEmpty((Object)params.getUsl()) && HussarUtils.isNotEmpty((Object)params.getLsl())) {
            abnormalPatternDto.setT(Calc.getBigDecimal((Object)params.getUsl()).subtract(Calc.getBigDecimal((Object)params.getLsl())));
        }
        abnormalPatternDto.setPatternList(patternEntities);
        if (dataList.isEmpty() || abnormalPatternDto.getPatternList().isEmpty()) {
            return result;
        }
        ArrayList<AnalysisNode> analysisNodes = new ArrayList<AnalysisNode>(dataList.size());
        for (int i = 0; i < dataList.size(); ++i) {
            analysisNodes.add(new AnalysisNode(i, dataList.get(i)));
        }
        Map<String, Integer> abnormalitiesNum = Pattern.analyze(abnormalPatternDto, analysisNodes);
        result.setDataList(analysisNodes);
        result.setAbnormalitiesNum(abnormalitiesNum);
        return result;
    }

    @Override
    public List<Boxplot> generateBoxplot(AnalysisParamDto analysisParam, List<BigDecimal> totalNodeList, List<List<BigDecimal>> nodeGroupList, List<Integer> failList, List<Integer> detectList) {
        int n;
        List<Object> dataList = new ArrayList();
        List<Object> groupDataList = new ArrayList();
        if ("0".equals(analysisParam.getDataType())) {
            dataList = totalNodeList;
            groupDataList = nodeGroupList;
        } else if ("np".equals(analysisParam.getChartType()) || "c".equals(analysisParam.getChartType())) {
            dataList = failList.stream().map(Calc::getBigDecimal).collect(Collectors.toList());
        } else {
            for (int i = 0; i < failList.size(); ++i) {
                dataList.add(Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)(failList.get(i).doubleValue() / detectList.get(i).doubleValue())), (Integer)analysisParam.getDecimalNum(), (Boolean)true));
            }
        }
        ArrayList<Boxplot> boxplotList = new ArrayList<Boxplot>();
        int decimalNum = analysisParam.getDecimalNum();
        Map<Integer, Object> nodeGroup = new LinkedHashMap<Integer, Object>();
        if ("xr".equals(analysisParam.getChartType()) || "xs".equals(analysisParam.getChartType()) || "x_r".equals(analysisParam.getChartType())) {
            n = ((List)groupDataList.get(0)).size();
            for (int i = 0; i < groupDataList.size(); ++i) {
                nodeGroup.put(i + 1, groupDataList.get(i));
            }
        } else {
            n = analysisParam.getBoxplotGroupSize();
            nodeGroup = CommonUtils.groupEquallyWithIndex(dataList, n);
        }
        for (Map.Entry entry : nodeGroup.entrySet()) {
            BoxplotGroupVO boxplotGroupVO = new BoxplotGroupVO();
            List valueList = ((List)entry.getValue()).stream().sorted().collect(Collectors.toList());
            BigDecimal Q2 = Calc.tidyDecimal((BigDecimal)BoxplotUtil.calculateMedian(valueList), (Integer)decimalNum, (Boolean)true);
            BigDecimal Q1 = Calc.tidyDecimal((BigDecimal)BoxplotUtil.calculatePercentile(valueList, (double)0.25), (Integer)decimalNum, (Boolean)true);
            BigDecimal Q3 = Calc.tidyDecimal((BigDecimal)BoxplotUtil.calculatePercentile(valueList, (double)0.75), (Integer)decimalNum, (Boolean)true);
            BigDecimal iqr = Calc.tidyDecimal((BigDecimal)BoxplotUtil.iqr((BigDecimal)Q1, (BigDecimal)Q3), (Integer)decimalNum, (Boolean)true);
            BigDecimal upperBound = Calc.tidyDecimal((BigDecimal)BoxplotUtil.upperBound((BigDecimal)Q3, (BigDecimal)iqr), (Integer)decimalNum, (Boolean)true);
            BigDecimal lowerBound = Calc.tidyDecimal((BigDecimal)BoxplotUtil.lowerBound((BigDecimal)Q1, (BigDecimal)iqr), (Integer)decimalNum, (Boolean)true);
            BigDecimal maxValue = (BigDecimal)valueList.get(valueList.size() - 1);
            BigDecimal minValue = (BigDecimal)valueList.get(0);
            BigDecimal upperWhisker = Calc.tidyDecimal((BigDecimal)(maxValue.compareTo(upperBound) > 0 ? upperBound : maxValue), (Integer)decimalNum, (Boolean)true);
            BigDecimal lowerWhisker = Calc.tidyDecimal((BigDecimal)(minValue.compareTo(lowerBound) < 0 ? lowerBound : minValue), (Integer)decimalNum, (Boolean)true);
            ArrayList<BigDecimal> outliers = new ArrayList<BigDecimal>();
            for (BigDecimal value : valueList) {
                if (value.compareTo(upperWhisker) <= 0 && value.compareTo(lowerWhisker) >= 0) continue;
                outliers.add(value);
            }
            if (HussarUtils.isNotEmpty(outliers)) {
                String outliersStr = outliers.stream().map(BigDecimal::toPlainString).collect(Collectors.joining(","));
                boxplotGroupVO.setOutliers(outliersStr);
            }
            boxplotGroupVO.setQ1(Q1.toPlainString());
            boxplotGroupVO.setQ2(Q2.toPlainString());
            boxplotGroupVO.setQ3(Q3.toPlainString());
            boxplotGroupVO.setIQR(iqr.toPlainString());
            boxplotGroupVO.setUpperWhisker(upperWhisker.toPlainString());
            boxplotGroupVO.setLowerWhisker(lowerWhisker.toPlainString());
            boxplotGroupVO.setN(n);
            Boxplot boxplot = new Boxplot();
            boxplot.setAnalysisId(analysisParam.getAnalysisId());
            boxplot.setUsl(analysisParam.getUsl());
            boxplot.setLsl(analysisParam.getLsl());
            boxplot.setBoxplotSort((Integer)entry.getKey());
            if (HussarUtils.isNotEmpty((Object)boxplotGroupVO)) {
                boxplot.setBoxplotGroup(JSONObject.toJSONString((Object)boxplotGroupVO));
            }
            boxplot.setCreateTime(analysisParam.getCreateTime());
            boxplot.setCreator(analysisParam.getCreator());
            boxplot.setCreatorName(analysisParam.getCreatorName());
            boxplotList.add(boxplot);
        }
        return boxplotList;
    }

    @Override
    public BasicStatisticDataDto getBasicStatisticData(AnalysisParamDto analysisParam) {
        BasicStatisticDataDto basicStatisticDataDto = new BasicStatisticDataDto();
        List<List<AnalysisDataSource>> sourceNodeList = analysisParam.getDataList();
        basicStatisticDataDto.setSourceNodeList(sourceNodeList);
        if ("0".equals(analysisParam.getDataType())) {
            ArrayList<List<String>> nodeList = new ArrayList<List<String>>(sourceNodeList.size());
            for (List<AnalysisDataSource> sourceList : sourceNodeList) {
                ArrayList<String> sampleValues = new ArrayList<String>(sourceList.size());
                for (AnalysisDataSource source : sourceList) {
                    sampleValues.add(source.getSampleValue());
                }
                nodeList.add(sampleValues);
            }
            List<String> totalNodeList = nodeList.stream().flatMap(Collection::stream).collect(Collectors.toList());
            List<List<BigDecimal>> nodeBigList = nodeList.stream().map(subgroup -> subgroup.stream().map(Calc::getBigDecimal).collect(Collectors.toList())).collect(Collectors.toList());
            List<BigDecimal> totalNodeBigList = nodeBigList.stream().flatMap(Collection::stream).collect(Collectors.toList());
            basicStatisticDataDto.setNodeList(nodeList);
            basicStatisticDataDto.setTotalNodeList(totalNodeList);
            basicStatisticDataDto.setNodeBigList(nodeBigList);
            basicStatisticDataDto.setTotalNodeBigList(totalNodeBigList);
        } else {
            ArrayList<List<Integer>> failNodeList = new ArrayList<List<Integer>>(sourceNodeList.size());
            ArrayList<List<Integer>> detectNodeList = new ArrayList<List<Integer>>(sourceNodeList.size());
            for (List<AnalysisDataSource> sourceList : sourceNodeList) {
                ArrayList<Integer> failValues = new ArrayList<Integer>(sourceList.size());
                ArrayList<Integer> detectValues = new ArrayList<Integer>(sourceList.size());
                for (AnalysisDataSource source : sourceList) {
                    failValues.add(source.getFailNum());
                    detectValues.add(source.getDetectNum());
                }
                failNodeList.add(failValues);
                detectNodeList.add(detectValues);
            }
            ArrayList<List<Integer>> failNodeGroupList = failNodeList;
            ArrayList<List<Integer>> detectNodeGroupList = detectNodeList;
            List<Integer> failNodeListResult = failNodeList.stream().flatMap(Collection::stream).collect(Collectors.toList());
            List<Integer> detectNodeListResult = detectNodeList.stream().flatMap(Collection::stream).collect(Collectors.toList());
            basicStatisticDataDto.setDetectNodeGroupList(detectNodeGroupList);
            basicStatisticDataDto.setFailNodeGroupList(failNodeGroupList);
            basicStatisticDataDto.setDetectNodeList(detectNodeListResult);
            basicStatisticDataDto.setFailNodeList(failNodeListResult);
        }
        return basicStatisticDataDto;
    }
}

