/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.factory;

import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.spc.core.analysisManage.analysisTool.service.SpcService;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.CChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.ControlChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.IMRChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.NpChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.PChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.UChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.XMedRChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.XbarRChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.XbarSChartStrategy;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ChartStrategyFactory {
    @Resource
    private SpcService spcService;

    public ControlChartStrategy createStrategy(String chartType) {
        switch (chartType) {
            case "xr": {
                return new XbarRChartStrategy(this.spcService);
            }
            case "x_r": {
                return new XMedRChartStrategy(this.spcService);
            }
            case "xmr": {
                return new IMRChartStrategy(this.spcService);
            }
            case "xs": {
                return new XbarSChartStrategy(this.spcService);
            }
            case "np": {
                return new NpChartStrategy(this.spcService);
            }
            case "p": {
                return new PChartStrategy(this.spcService);
            }
            case "u": {
                return new UChartStrategy(this.spcService);
            }
            case "c": {
                return new CChartStrategy(this.spcService);
            }
        }
        throw new HussarException("\u4e0d\u652f\u6301\u7684\u63a7\u5236\u56fe\u7c7b\u578b\uff1a" + chartType + "\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
    }
}

