/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.patterns;

import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.Pattern;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalAnalysis;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalJudgmentFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisUtils;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.dto.AbnormalPatternDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedDeque;

public class Pattern9
extends Pattern {
    @Override
    public AbnormalAnalysis getAnalysis(AbnormalPatternDto dto) {
        String kValue = this.getParam(dto, "pattern9", "kValue", "10");
        String mValue = this.getParam(dto, "pattern9", "mValue", "1.5");
        if (!this.checkPositiveNumber(mValue, false)) {
            throw new HussarException("\u5224\u5f02\u51c6\u52199\uff1aM\u503c\u5fc5\u987b\u4e3a\u6b63\u6570\uff08\u5f53\u524d\u503c\uff1a" + mValue + "\uff09");
        }
        int k = (int)Math.floor(Double.parseDouble(kValue));
        double m = Double.parseDouble(mValue);
        ConcurrentLinkedDeque window = new ConcurrentLinkedDeque();
        AnalysisFunction analysisFunc = (nodes, index, buffer) -> {
            AnalysisNode current = (AnalysisNode)nodes.get(index);
            window.addLast(current);
            if (window.size() > k) {
                window.removeFirst();
            }
            if (window.size() == k) {
                BigDecimal windowMean = AnalysisUtils.calculateWindowMean(new ArrayList<AnalysisNode>(window));
                BigDecimal cl = dto.getCl();
                BigDecimal stdDev = dto.getStdDev();
                if (cl == null || stdDev == null) {
                    return Collections.emptyList();
                }
                BigDecimal offset = windowMean.subtract(cl).abs();
                double sigmaMultiple = offset.divide(stdDev, 6, 4).doubleValue();
                if (sigmaMultiple > m) {
                    current.addTag("pattern9", "9");
                    return Collections.singletonList(current);
                }
            }
            return Collections.emptyList();
        };
        return new AbnormalAnalysis(analysisFunc, AbnormalJudgmentFunction::commonJudge);
    }
}

