/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis;

import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalJudgmentFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AbnormalAnalysis {
    private static final int DEFAULT_BUFFER_CAPACITY = 1000;
    private final AnalysisFunction analysisFunction;
    private final AbnormalJudgmentFunction judgmentFunction;
    private final List<AnalysisNode> tempBuffer;
    private final List<List<AnalysisNode>> abnormalEvents;

    public AbnormalAnalysis(AnalysisFunction analysisFunction, AbnormalJudgmentFunction judgmentFunction) {
        this.analysisFunction = analysisFunction;
        this.judgmentFunction = judgmentFunction;
        this.tempBuffer = new ArrayList<AnalysisNode>(1000);
        this.abnormalEvents = new ArrayList<List<AnalysisNode>>(100);
    }

    public synchronized void analyze(List<AnalysisNode> nodes) {
        this.clear();
        for (int i = 0; i < nodes.size(); ++i) {
            List<AnalysisNode> currentAbnormals = this.analysisFunction.apply(nodes, i, this.tempBuffer);
            currentAbnormals = currentAbnormals == null ? Collections.emptyList() : currentAbnormals;
            this.judgmentFunction.apply(this.abnormalEvents, currentAbnormals);
        }
    }

    public synchronized void clear() {
        this.tempBuffer.clear();
        this.abnormalEvents.clear();
    }

    public synchronized int getAbnormalEventCount() {
        return this.abnormalEvents.size();
    }

    public synchronized List<List<AnalysisNode>> getAbnormalEvents() {
        return new ArrayList<List<AnalysisNode>>(this.abnormalEvents);
    }
}

