/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisInfo.util;

import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.baseManage.baseConfig.model.ProcessVariableEntity;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.ReflectionUtils;

public class ImportUtil {
    public static Map<Integer, String> buildFieldMap(List<ProcessVariableEntity> visibleVariables, List<String> templateAliases) {
        List sortedVariables = visibleVariables.stream().sorted(Comparator.comparing(ProcessVariableEntity::getVariableId)).collect(Collectors.toList());
        HashMap<Integer, String> fieldMap = new HashMap<Integer, String>();
        block0: for (int i = 0; i < templateAliases.size(); ++i) {
            String templateAlias = templateAliases.get(i);
            for (ProcessVariableEntity variable : sortedVariables) {
                if (!variable.getVariableName().equals(templateAlias)) continue;
                fieldMap.put(i, variable.getVariableFileName());
                continue block0;
            }
        }
        return fieldMap;
    }

    public static void setFieldValues(AnalysisDataSource entity, Map<Integer, String> fieldMap, List<String> templateValues) {
        for (Map.Entry<Integer, String> entry : fieldMap.entrySet()) {
            int valueIndex = entry.getKey();
            String fieldName = entry.getValue();
            if (valueIndex >= templateValues.size()) continue;
            String value = templateValues.get(valueIndex);
            Field field = ReflectionUtils.findField(AnalysisDataSource.class, (String)fieldName);
            if (field == null) continue;
            ReflectionUtils.makeAccessible((Field)field);
            ReflectionUtils.setField((Field)field, (Object)((Object)entity), (Object)value);
        }
    }
}

