/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisInfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisBaseDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AnalysisInfoEntity;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AbnormalDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AsyncAnalysisInfoService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.ControlDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.IAnalysisInfoService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.relationRule.model.RelationRuleEntity;
import com.jxdinfo.spc.core.changeAnalysisRecord.model.ChangeAnalysisRecordEntity;
import com.jxdinfo.spc.core.changeAnalysisRecord.service.IChangeAnalysisRecordService;
import com.jxdinfo.spc.core.common.util.CommonUtils;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AsyncAnalysisInfoServiceImpl
implements AsyncAnalysisInfoService {
    @Resource
    private IAnalysisInfoService analysisInfoService;
    @Resource
    private ControlDataService controlDataService;
    @Resource
    private AbnormalDataService abnormalDataService;
    @Resource
    private IChangeAnalysisRecordService changeAnalysisRecordService;

    @Override
    @Async
    public AnalysisResultVO analysis(AnalysisInfoEntity analysisInfo, SecurityUser user, LocalDateTime date, List<AnalysisDataSource> analysisDataSourceList, List<RelationRuleEntity> relationRuleEntityList) {
        Long analysisId = analysisInfo.getAnalysisId();
        String analysisType = this.analysisInfoService.determineAnalysisType(analysisInfo);
        AnalysisBaseDto analysisBaseDto = this.analysisInfoService.initializeBaseInfo(analysisInfo, analysisDataSourceList, relationRuleEntityList);
        AnalysisParamDto analysisParamDto = this.analysisInfoService.initializeParamDto(analysisInfo, user, date, analysisBaseDto.getRelationRuleVOList(), analysisBaseDto.getAnalysisDataSourceList());
        AnalysisResultVO analysisResultVO = this.controlDataService.chartAnalysis(analysisParamDto);
        String historyId = "";
        historyId = HussarUtils.isEmpty((Object)analysisType) ? analysisInfo.getHistoryAnalysisId() : CommonUtils.generateAssignId(AnalysisInfoEntity.class);
        List<AbnormalData> abnormalDataList = analysisResultVO.getAbnormalData();
        if (HussarUtils.isNotEmpty(abnormalDataList) && HussarUtils.isNotEmpty(analysisResultVO.getControlData())) {
            Map<String, String> snapshotMap = this.abnormalDataService.saveSnapshot(analysisResultVO);
            for (AbnormalData abnormalData : abnormalDataList) {
                String snapshotId = snapshotMap.get(abnormalData.getChartType());
                abnormalData.setAbnormalSnapshotId(snapshotId);
                abnormalData.setHistoryAnalysisId(historyId);
            }
            this.abnormalDataService.saveBatch(abnormalDataList);
            this.analysisInfoService.relationAbnormalData(analysisResultVO, analysisInfo, abnormalDataList);
        }
        if ("3".equals(analysisInfo.getSourceType())) {
            this.analysisInfoService.deleteAnalysisResult(analysisInfo);
        }
        this.analysisInfoService.saveAnalysisResult(analysisInfo, analysisResultVO);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisId)).set(AnalysisInfoEntity::getLastAnalysisTime, (Object)date)).set(HussarBaseEntity::getLastEditor, (Object)user.getId())).set(AnalysisInfoEntity::getLastEditorName, (Object)user.getUserName())).set(HussarBaseEntity::getLastTime, (Object)date)).set(AnalysisInfoEntity::getIsPolling, (Object)"1")).set(AnalysisInfoEntity::getHistoryAnalysisId, (Object)historyId);
        analysisInfo.setIsPolling("1");
        analysisInfo.setHistoryAnalysisId(historyId);
        if (HussarUtils.isNotEmpty((Object)analysisType)) {
            switch (analysisType) {
                case "1": 
                case "2": 
                case "3": 
                case "4": {
                    this.analysisInfoService.saveHistoryResult(analysisInfo, analysisResultVO);
                    this.analysisInfoService.saveHistoryAnalysis(analysisInfo, analysisResultVO, analysisBaseDto.getRelationRuleVOList(), analysisBaseDto.getRelationWarnObjectEntityList());
                    this.analysisInfoService.saveHistoryDataSource(analysisBaseDto.getAnalysisDataSourceList(), historyId);
                    ChangeAnalysisRecordEntity changeAnalysisRecordEntity = (ChangeAnalysisRecordEntity)BeanUtil.copyProperties((Object)((Object)analysisInfo), ChangeAnalysisRecordEntity.class);
                    assert (changeAnalysisRecordEntity != null);
                    changeAnalysisRecordEntity.setRecordType(analysisType);
                    changeAnalysisRecordEntity.setHistoryAnalysisId(historyId);
                    changeAnalysisRecordEntity.setCreator(user.getId());
                    changeAnalysisRecordEntity.setCreatorName(user.getUserName());
                    changeAnalysisRecordEntity.setCreateTime(LocalDateTime.now());
                    this.changeAnalysisRecordService.save(changeAnalysisRecordEntity);
                    break;
                }
            }
        }
        if ("3".equals(analysisInfo.getSourceType())) {
            updateWrapper.set(AnalysisInfoEntity::getAnalysisStatus, (Object)"2");
            if (HussarUtils.isEmpty((Object)analysisInfo.getRefreshInterval())) {
                updateWrapper.set(AnalysisInfoEntity::getAnalysisStatus, (Object)"4");
                updateWrapper.set(AnalysisInfoEntity::getIsPause, (Object)"1");
            }
            analysisDataSourceList = analysisDataSourceList.stream().sorted(Comparator.comparing(AnalysisDataSource::getDataSort, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
            if ("2".equals(analysisInfo.getAnalysisMode())) {
                int lastSort = analysisDataSourceList.get(analysisInfo.getSubgroupSize() - 1).getDataSort();
                updateWrapper.set(AnalysisInfoEntity::getLastSort, (Object)lastSort);
            } else {
                int lastSort = analysisDataSourceList.get(analysisDataSourceList.size() - 1).getDataSort();
                updateWrapper.set(AnalysisInfoEntity::getLastSort, (Object)lastSort);
            }
        } else {
            updateWrapper.set(AnalysisInfoEntity::getAnalysisStatus, (Object)"3");
        }
        this.analysisInfoService.update((Wrapper)updateWrapper);
        CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> this.analysisInfoService.generateWarningMessage(analysisResultVO, analysisInfo, analysisBaseDto.getRelationWarnObjectEntityList()));
        return analysisResultVO;
    }
}

