/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisInfo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.adapter.dict.service.IDictAPIService;
import com.jxdinfo.spc.adapter.dict.vo.DictApiVo;
import com.jxdinfo.spc.adapter.lang.service.ILangApiService;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisDataSource.service.IAnalysisDataSourceService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dao.AbnormalDataMapper;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AbnormalDataDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AbnormalSnapshotDocument;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.repository.AbnormalSnapshotRepository;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AbnormalDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.ControlDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AbnormalDataVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.dto.KlmValueDto;
import com.jxdinfo.spc.core.common.util.LangeTransactionUtil;
import com.jxdinfo.spc.core.common.util.TimeFlagTransferUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class AbnormalDataServiceImpl
extends ServiceImpl<AbnormalDataMapper, AbnormalData>
implements AbnormalDataService {
    @Autowired
    private AbnormalDataMapper abnormalDataMapper;
    @Autowired
    private AbnormalSnapshotRepository abnormalSnapshotRepository;
    @Autowired
    private ControlDataService controlDataService;
    @Resource
    private IAnalysisDataSourceService analysisDataSourceService;
    @Resource
    private IDictAPIService dictAPIService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private ILangApiService langApiService;

    @Override
    public Page<AbnormalDataVo> queryPageByAnalysisId(AbnormalDataDto dto) {
        Page page = dto.getPage();
        this.transfer(dto);
        Page<AbnormalDataVo> abnormalDataVoPage = this.abnormalDataMapper.queryPageByAnalysisId(page, dto);
        List abnormalDataVoList = abnormalDataVoPage.getRecords();
        for (AbnormalDataVo abnormalDataVo : abnormalDataVoList) {
            String analysisDataSource = abnormalDataVo.getAnalysisDataSource();
            if (!HussarUtils.isNotEmpty((Object)analysisDataSource)) continue;
            abnormalDataVo.setAnalysisDataSourcesList(JSONObject.parseArray((String)analysisDataSource, AnalysisDataSource.class));
        }
        this.transferDict(abnormalDataVoList);
        if (LangeTransactionUtil.getEnableLange()) {
            for (AbnormalDataVo abnormalDataVo : abnormalDataVoList) {
                String isWarnLabel;
                if (HussarUtils.isNotEmpty((Object)abnormalDataVo.getRuleExplainKey())) {
                    String[] keys = abnormalDataVo.getRuleExplainKey().split(",");
                    List klmValueDtos = JSONObject.parseArray((String)abnormalDataVo.getKlmValue(), KlmValueDto.class);
                    StringBuilder judgmentRuleNameBuilder = new StringBuilder();
                    int num = 1;
                    for (int i = 0; i < keys.length; ++i) {
                        judgmentRuleNameBuilder.append("\u3010").append(num).append("\u3011").append(AbnormalDataServiceImpl.getReplaceColumn(this.langApiService.getTranslateName(keys[i], abnormalDataVo.getJudgmentRuleExplain()), (KlmValueDto)klmValueDtos.get(i)));
                        ++num;
                        if (i >= keys.length - 1) continue;
                        judgmentRuleNameBuilder.append(";\n");
                    }
                    abnormalDataVo.setJudgmentRuleExplain(judgmentRuleNameBuilder.toString());
                }
                if (!HussarUtils.isNotEmpty((Object)abnormalDataVo.getIsWarning()) || !HussarUtils.isNotEmpty((Object)(isWarnLabel = this.langApiService.getTranslateName("\u662f".equals(abnormalDataVo.getIsWarning()) ? "spc.yes" : "spc.no", abnormalDataVo.getIsWarning())))) continue;
                abnormalDataVo.setIsWarning(isWarnLabel);
            }
        }
        return abnormalDataVoPage;
    }

    @Override
    public boolean handle(AbnormalDataDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(AbnormalData::getAbnormalDataId, dto.getAbnormalDataIdList());
        updateWrapper.set(AbnormalData::getHandleState, (Object)"1");
        updateWrapper.set(AbnormalData::getHandleMeasure, (Object)dto.getHandleMeasure());
        updateWrapper.set(AbnormalData::getAbnormalReason, (Object)dto.getAbnormalReason());
        updateWrapper.set(AbnormalData::getHandlerId, (Object)user.getUserId());
        updateWrapper.set(AbnormalData::getHandlerName, (Object)user.getUserName());
        updateWrapper.set(AbnormalData::getHandleTime, (Object)LocalDateTime.now());
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public Map<String, String> saveSnapshot(AnalysisResultVO analysisResultVO) {
        List<AbnormalData> abnormalDataList = analysisResultVO.getAbnormalData();
        List<ControlData> controlDataList = analysisResultVO.getControlData();
        Map<String, List<AbnormalData>> abnormalDataMap = abnormalDataList.stream().collect(Collectors.groupingBy(AbnormalData::getChartType));
        Map<String, List<ControlData>> controlDataMap = controlDataList.stream().collect(Collectors.groupingBy(ControlData::getChartType));
        HashMap<String, String> abnormalSnapshotMap = new HashMap<String, String>();
        for (Map.Entry<String, List<AbnormalData>> map : abnormalDataMap.entrySet()) {
            List<ControlData> thisControlDataList;
            if (!HussarUtils.isNotEmpty(map.getValue()) || !CollectionUtil.isNotEmpty(thisControlDataList = controlDataMap.get(map.getKey()))) continue;
            AbnormalSnapshotDocument abnormalSnapshotDocument = new AbnormalSnapshotDocument();
            String controlDataJson = JSONObject.toJSONString((Object)thisControlDataList.get(0));
            abnormalSnapshotDocument.setAbnormalData(controlDataJson);
            abnormalSnapshotDocument = (AbnormalSnapshotDocument)this.abnormalSnapshotRepository.save(abnormalSnapshotDocument);
            abnormalSnapshotMap.put(map.getKey(), abnormalSnapshotDocument.getId());
        }
        return abnormalSnapshotMap;
    }

    @Override
    public Page<AbnormalDataVo> queryPage(AbnormalDataDto dto) {
        Page page = dto.getPage();
        this.transfer(dto);
        if (HussarUtils.isNotEmpty((Object)dto.getKeyword())) {
            dto.setKeyword(dto.getKeyword().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getTypePath())) {
            dto.setTypePath(dto.getTypePath().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        dto.setIsWarning("1");
        Page<AbnormalDataVo> abnormalDataVoPage = this.abnormalDataMapper.queryPage(page, dto);
        List abnormalDataVoList = abnormalDataVoPage.getRecords();
        for (AbnormalDataVo abnormalDataVo : abnormalDataVoList) {
            String analysisDataSource = abnormalDataVo.getAnalysisDataSource();
            if (!HussarUtils.isNotEmpty((Object)analysisDataSource)) continue;
            abnormalDataVo.setAnalysisDataSourcesList(JSONObject.parseArray((String)analysisDataSource, AnalysisDataSource.class));
        }
        this.transferDict(abnormalDataVoList);
        if (LangeTransactionUtil.getEnableLange()) {
            for (AbnormalDataVo abnormalDataVo : abnormalDataVoList) {
                String isWarnLabel;
                if (HussarUtils.isNotEmpty((Object)abnormalDataVo.getRuleExplainKey())) {
                    String[] keys = abnormalDataVo.getRuleExplainKey().split(",");
                    List klmValueDtos = JSONObject.parseArray((String)abnormalDataVo.getKlmValue(), KlmValueDto.class);
                    StringBuilder judgmentRuleNameBuilder = new StringBuilder();
                    int num = 1;
                    for (int i = 0; i < keys.length; ++i) {
                        judgmentRuleNameBuilder.append("\u3010").append(num).append("\u3011").append(AbnormalDataServiceImpl.getReplaceColumn(this.langApiService.getTranslateName(keys[i], abnormalDataVo.getJudgmentRuleExplain()), (KlmValueDto)klmValueDtos.get(i)));
                        ++num;
                        if (i >= keys.length - 1) continue;
                        judgmentRuleNameBuilder.append(";\n");
                    }
                    abnormalDataVo.setJudgmentRuleExplain(judgmentRuleNameBuilder.toString());
                }
                if (!HussarUtils.isNotEmpty((Object)abnormalDataVo.getIsWarning()) || !HussarUtils.isNotEmpty((Object)(isWarnLabel = this.langApiService.getTranslateName("\u662f".equals(abnormalDataVo.getIsWarning()) ? "spc.yes" : "spc.no", abnormalDataVo.getIsWarning())))) continue;
                abnormalDataVo.setIsWarning(isWarnLabel);
            }
        }
        return abnormalDataVoPage;
    }

    @Override
    public ControlData getSnapshot(Long abnormalDataId) {
        AbnormalData abnormalData = (AbnormalData)((Object)this.getById(abnormalDataId));
        if (abnormalData != null) {
            try {
                AbnormalSnapshotDocument document = (AbnormalSnapshotDocument)this.abnormalSnapshotRepository.findById(abnormalData.getAbnormalSnapshotId()).get();
                ControlData controlData = (ControlData)JSONObject.parseObject((String)document.getAbnormalData(), ControlData.class);
                try {
                    Locale locale;
                    String lang;
                    if (LangeTransactionUtil.getEnableLange() && !"zh-CN".equals(lang = (locale = LocaleContextHolder.getLocale()).toLanguageTag())) {
                        JSONArray jsonArray = JSON.parseArray((String)controlData.getJudgmentResult());
                        ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>();
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            jsonObjectList.add(jsonArray.getJSONObject(i));
                        }
                        if (HussarUtils.isNotEmpty(jsonObjectList)) {
                            this.langApiService.translateBatch(jsonObjectList, jsonObj -> jsonObj.getString("ruleExplainKey"), (jsonObj, translatedText) -> jsonObj.put("judgmentNameInternation", translatedText));
                            controlData.setJudgmentResult(JSON.toJSONString(jsonObjectList));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return controlData;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void transfer(AbnormalDataDto dto) {
        dto.setCreateTime(TimeFlagTransferUtil.transfer(dto.getCreateTime()));
        if ("1".equals(dto.getAbnormalScenes())) {
            dto.setHandlerStateList(Collections.singletonList("0"));
        } else if ("2".equals(dto.getAbnormalScenes())) {
            dto.setHandlerStateList(Collections.singletonList("1"));
        }
    }

    @Override
    public AbnormalDataVo getAbnormalDataDetailById(Long abnormalDataId) {
        AbnormalData abnormalData = (AbnormalData)((Object)this.getById(abnormalDataId));
        if (HussarUtils.isNotEmpty((Object)((Object)abnormalData))) {
            AbnormalDataVo abnormalDataVo = (AbnormalDataVo)((Object)BeanUtil.copyProperties((Object)((Object)abnormalData), AbnormalDataVo.class));
            List analysisDataSourcesList = this.analysisDataSourceService.list((Wrapper)new LambdaQueryWrapper().eq(AnalysisDataSource::getAnalysisId, (Object)abnormalData.getAnalysisId()));
            if (HussarUtils.isNotEmpty((Object)analysisDataSourcesList)) {
                assert (abnormalDataVo != null);
                abnormalDataVo.setAnalysisDataSourcesList(analysisDataSourcesList);
            }
            return abnormalDataVo;
        }
        return null;
    }

    private void transferDict(List<AbnormalDataVo> abnormalDataVoList) {
        List chartTypeList = this.dictAPIService.getDictList("chart_type");
        Map<String, Object> chartTypeMap = chartTypeList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        List isWarnList = this.dictAPIService.getDictList("yes_no");
        Map<String, Object> isWarnMap = isWarnList.stream().collect(Collectors.toMap(DictApiVo::getValue, DictApiVo::getLabel));
        abnormalDataVoList.forEach(abnormalDataVo -> {
            if (HussarUtils.isNotEmpty((Object)abnormalDataVo.getChartType()) && chartTypeMap.containsKey(abnormalDataVo.getChartType())) {
                abnormalDataVo.setChartTypeLabel(chartTypeMap.get(abnormalDataVo.getChartType()).toString());
                abnormalDataVo.setIsWarning(isWarnMap.get(HussarUtils.isNotEmpty((Object)abnormalDataVo.getIsWarning()) ? abnormalDataVo.getIsWarning() : "0").toString());
            }
        });
    }

    private static String getReplaceColumn(String ruleExplain, KlmValueDto klmValue) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        if (klmValue.getK() != null) {
            replacements.put("${K}", klmValue.getK());
        }
        if (klmValue.getL() != null) {
            replacements.put("${L}", klmValue.getL());
        }
        if (klmValue.getM() != null) {
            replacements.put("${M}", klmValue.getM());
        }
        if (klmValue.getK() != null) {
            replacements.put("${K-1}", String.valueOf(Integer.parseInt(klmValue.getK()) - 1));
        }
        for (Map.Entry entry : replacements.entrySet()) {
            ruleExplain = ruleExplain.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return ruleExplain;
    }
}

