/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.operatelog.context;

import com.jxdinfo.spc.core.operatelog.dto.OperateLogAPIDTO;
import java.time.LocalDateTime;

public class OperateLogContext {
    private final OperateLogAPIDTO logDTO;
    private final Long operatorId;
    private final String operatorName;
    private final LocalDateTime operateTime;

    OperateLogContext(OperateLogAPIDTO logDTO, Long operatorId, String operatorName, LocalDateTime operateTime) {
        this.logDTO = logDTO;
        this.operatorId = operatorId;
        this.operatorName = operatorName;
        this.operateTime = operateTime;
    }

    public static OperateLogContext from(OperateLogAPIDTO dto) {
        return new OperateLogContext(dto, null, null, null);
    }

    public OperateLogContext withOperator(Long id, String name) {
        return new OperateLogContext(this.logDTO, id, name, this.operateTime);
    }

    public OperateLogContext withOperateTime(LocalDateTime time) {
        return new OperateLogContext(this.logDTO, this.operatorId, this.operatorName, time);
    }

    public OperateLogAPIDTO getLogDTO() {
        return this.logDTO;
    }

    public Long getOperatorId() {
        return this.operatorId;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public LocalDateTime getOperateTime() {
        return this.operateTime;
    }
}

