/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.dataPool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.spc.core.dataPool.dto.DataPoolDataDto;
import com.jxdinfo.spc.core.dataPool.service.IDataPoolDataService;
import com.jxdinfo.spc.core.dataPool.vo.DataPoolDataVo;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/spc/dataPool"})
public class DataPoolDataController {
    @Autowired
    private IDataPoolDataService dataPoolDataService;

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u539f\u59cb\u6570\u636e\u5206\u9875\u67e5\u8be2", notes="\u539f\u59cb\u6570\u636e\u5206\u9875\u67e5\u8be2")
    @AuditLog(moduleName="\u539f\u59cb\u6570\u636e", eventDesc="\u539f\u59cb\u6570\u636e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<DataPoolDataVo>> queryPage(@RequestBody DataPoolDataDto dto) {
        Page page = this.dataPoolDataService.queryPage(dto);
        if (page != null) {
            return ApiResponse.success(page);
        }
        page = new Page();
        page.setRecords(new ArrayList());
        page.setTotal(0L);
        return ApiResponse.success((Object)page);
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u539f\u59cb\u6570\u636e\u5bfc\u51fa", notes="\u539f\u59cb\u6570\u636e\u5bfc\u51fa")
    @AuditLog(moduleName="\u539f\u59cb\u6570\u636e", eventDesc="\u539f\u59cb\u6570\u636e", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<List<DataPoolDataVo>> export(@RequestBody DataPoolDataDto dto) {
        List<DataPoolDataVo> dataPoolDataVoList = this.dataPoolDataService.getExportList(dto);
        if (CollectionUtil.isNotEmpty(dataPoolDataVoList)) {
            return ApiResponse.success(dataPoolDataVoList);
        }
        return ApiResponse.success(new ArrayList());
    }
}

