/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.common.util;

import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CommonUtils {
    private static IdentifierGenerator identifierGenerator = new DefaultIdentifierGenerator();
    public static final ObjectMapper objectMapper = new ObjectMapper();
    public static final char ESCAPE_CHAR = '/';

    public static String generateAssignId() {
        return identifierGenerator.nextId(new Object()).toString();
    }

    public static Map<Integer, List<BigDecimal>> groupEquallyWithIndex(List<BigDecimal> list, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("\u6bcf\u7ec4\u5927\u5c0fn\u5fc5\u987b\u5927\u4e8e0\uff0c\u5f53\u524dn=" + n);
        }
        if (list == null || list.isEmpty()) {
            return new LinkedHashMap<Integer, List<BigDecimal>>();
        }
        int totalSize = list.size();
        int validSize = totalSize / n * n;
        ArrayList<BigDecimal> validList = new ArrayList<BigDecimal>(list.subList(0, validSize));
        LinkedHashMap<Integer, List<BigDecimal>> groupedMap = new LinkedHashMap<Integer, List<BigDecimal>>();
        for (int i = 0; i < validList.size(); i += n) {
            int groupIndex = i / n + 1;
            List currentGroup = validList.subList(i, i + n);
            groupedMap.put(groupIndex, new ArrayList(currentGroup));
        }
        return groupedMap;
    }

    public static <T> List<List<T>> arrayStructureConversion(List<List<T>> valueList) {
        List totalValueList = valueList.stream().flatMap(Collection::stream).collect(Collectors.toList());
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int width = valueList.get(0).size();
        int height = valueList.size();
        for (int i = 0; i < width; ++i) {
            ArrayList data = new ArrayList();
            for (int j = 0; j < height; ++j) {
                data.add(totalValueList.get(i + j * width));
            }
            result.add(data);
        }
        return result;
    }

    public static String numberToString(Number value) {
        if (value == null) {
            return "";
        }
        return Calc.getBigDecimal((Object)value).toPlainString();
    }

    public static <T> T copyJsonVarToObject(String jsonStr, T vo) {
        if (HussarUtils.isEmpty((Object)jsonStr) || HussarUtils.isEmpty(vo)) {
            return vo;
        }
        try {
            String existingJson = objectMapper.writeValueAsString(vo);
            JsonNode existingNode = objectMapper.readTree(existingJson);
            JsonNode inputNode = objectMapper.readTree(jsonStr);
            JsonNode mergedNode = CommonUtils.mergeJsonNodes(existingNode, inputNode);
            vo = objectMapper.treeToValue((TreeNode)mergedNode, vo.getClass());
            return vo;
        }
        catch (Exception e) {
            System.err.println("jsonStr: " + e.getMessage());
            return vo;
        }
    }

    public static List<String> convertJsonToList(String jsonStr) {
        try {
            ArrayList<String> jsonStringList = new ArrayList<String>();
            JsonNode jsonNode = objectMapper.readTree(jsonStr);
            if (jsonNode.isArray()) {
                for (JsonNode node : jsonNode) {
                    jsonStringList.add(node.toString());
                }
                return jsonStringList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static JsonNode mergeJsonNodes(JsonNode existing, JsonNode input) {
        ObjectNode result = objectMapper.createObjectNode();
        existing.fields().forEachRemaining(entry -> result.set((String)entry.getKey(), (JsonNode)entry.getValue()));
        input.fields().forEachRemaining(entry -> result.set((String)entry.getKey(), (JsonNode)entry.getValue()));
        return result;
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        objectMapper.setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE);
    }
}

