/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.common.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.spc.adapter.notice.dto.SpcMessageApiDto;
import com.jxdinfo.spc.adapter.notice.service.INoticeApiService;
import com.jxdinfo.spc.core.common.dto.SpcMessageDto;
import com.jxdinfo.spc.core.common.service.ISpcMessageService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SpcMessageServiceImpl
implements ISpcMessageService {
    @Autowired
    INoticeApiService noticeApiService;

    @Override
    public void sendSpcMessage(SpcMessageDto spcMessageDto) {
        String userIdStr = spcMessageDto.getUserId();
        List<Object> userIdList = new ArrayList();
        if (StringUtil.isNotEmpty((Object)userIdStr)) {
            userIdList = Arrays.stream(userIdStr.split(",")).map(String::trim).filter(StringUtil::isNotBlank).distinct().collect(Collectors.toList());
        }
        SpcMessageApiDto addSysMessageDto = new SpcMessageApiDto();
        addSysMessageDto.setMessageTypeId(spcMessageDto.getMessageTypeId());
        addSysMessageDto.setMessageTitle(spcMessageDto.getMessageTitle());
        addSysMessageDto.setReleaseDate(LocalDateTime.parse(spcMessageDto.getReleaseDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        addSysMessageDto.setMessageContent(spcMessageDto.getMessageContent());
        addSysMessageDto.setDepartmentId(spcMessageDto.getDepartmentId());
        addSysMessageDto.setRoleId(spcMessageDto.getRoleId());
        if (HussarUtils.isNotEmpty((Object)spcMessageDto.getCreatoeDepartmentId())) {
            addSysMessageDto.setCreatoeDepartmentId(Long.valueOf(Long.parseLong(spcMessageDto.getCreatoeDepartmentId())));
        }
        addSysMessageDto.setMessageIssue(spcMessageDto.getMessageIssue());
        addSysMessageDto.setCreator(spcMessageDto.getCreator());
        addSysMessageDto.setLastEditor(spcMessageDto.getLastEditor());
        addSysMessageDto.setReadFlag(addSysMessageDto.getReadFlag());
        addSysMessageDto.setDelFlag(addSysMessageDto.getDelFlag());
        addSysMessageDto.setBusinessAddress(spcMessageDto.getBusinessAddress());
        addSysMessageDto.setOpenWay("0");
        if (userIdList.isEmpty()) {
            addSysMessageDto.setUserId(spcMessageDto.getUserId());
            this.noticeApiService.sendMessage(addSysMessageDto);
        } else {
            int batchSize = 50;
            for (int i = 0; i < userIdList.size(); i += batchSize) {
                int end = Math.min(i + batchSize, userIdList.size());
                ArrayList<Object> batch = new ArrayList<Object>(userIdList.subList(i, end));
                SpcMessageApiDto batchDto = new SpcMessageApiDto();
                BeanUtils.copyProperties((Object)addSysMessageDto, (Object)batchDto);
                batchDto.setUserId(StringUtil.join(batch, (String)","));
                this.noticeApiService.sendMessage(batchDto);
            }
        }
    }
}

