/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.spc.core.common.dao.SpcBaseConfigMapper;
import com.jxdinfo.spc.core.common.model.SpcBaseConfig;
import com.jxdinfo.spc.core.common.service.ISpcBaseConfigService;
import com.jxdinfo.spc.core.common.vo.SpcBaseConfigVo;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SpcBaseConfigServiceImpl
extends HussarServiceImpl<SpcBaseConfigMapper, SpcBaseConfig>
implements ISpcBaseConfigService {
    @Resource
    private SpcBaseConfigMapper spcBaseConfigMapper;

    @Override
    public SpcBaseConfigVo getSpcBaseConfigByKey(String configKey) {
        if (StringUtil.isEmpty((Object)configKey)) {
            return null;
        }
        SpcBaseConfigVo SpcBaseConfigVo2 = (SpcBaseConfigVo)DefaultCacheUtil.get((Object)("spc_config_prefix:" + configKey), SpcBaseConfigVo.class);
        if (SpcBaseConfigVo2 != null) {
            return SpcBaseConfigVo2;
        }
        return this.getInfoAndPutToRedis(configKey);
    }

    private SpcBaseConfigVo getInfoAndPutToRedis(String configKey) {
        List<SpcBaseConfig> configList = this.spcBaseConfigMapper.selectByConfigKey(configKey);
        if (CollectionUtil.isEmpty(configList)) {
            return null;
        }
        SpcBaseConfigVo SpcBaseConfigVo2 = this.makeCrmBaseConfigTree(configList, configKey);
        DefaultCacheUtil.put((Object)("spc_config_prefix:" + configKey), (Object)SpcBaseConfigVo2);
        return SpcBaseConfigVo2;
    }

    private void getInfoAndPutToRedisAndParent(String configKey) {
        List<SpcBaseConfig> configList = this.spcBaseConfigMapper.selectByConfigKey(configKey);
        if (CollectionUtil.isEmpty(configList)) {
            return;
        }
        SpcBaseConfigVo SpcBaseConfigVo2 = this.makeCrmBaseConfigTree(configList, configKey);
        DefaultCacheUtil.put((Object)("spc_config_prefix:" + configKey), (Object)SpcBaseConfigVo2);
        Long parentId = SpcBaseConfigVo2.getParentId();
        if (parentId != null) {
            SpcBaseConfig parentConfig = (SpcBaseConfig)((Object)this.spcBaseConfigMapper.selectById(parentId));
            this.getInfoAndPutToRedisAndParent(parentConfig.getConfigKey());
        }
    }

    private SpcBaseConfigVo makeCrmBaseConfigTree(List<SpcBaseConfig> configList, String configKey) {
        List SpcBaseConfigVoList = BeanUtil.copyProperties(configList, SpcBaseConfigVo.class);
        List configVoList = SpcBaseConfigVoList.stream().filter(SpcBaseConfigVo1 -> configKey.equals(SpcBaseConfigVo1.getConfigKey())).collect(Collectors.toList());
        SpcBaseConfigVo SpcBaseConfigVo2 = (SpcBaseConfigVo)configVoList.get(0);
        Long configVoId = SpcBaseConfigVo2.getId();
        List<SpcBaseConfigVo> childList = SpcBaseConfigVoList.stream().filter(SpcBaseConfigVo1 -> SpcBaseConfigVo1.getParentId() != null && configVoId.equals(SpcBaseConfigVo1.getParentId())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(childList)) {
            SpcBaseConfigVo2.setChildList(childList);
        }
        return SpcBaseConfigVo2;
    }

    @Override
    public List<SpcBaseConfigVo> getSpcBaseConfigByParentKey(String parentKey) {
        SpcBaseConfigVo SpcBaseConfigVo2 = this.getSpcBaseConfigByKey(parentKey);
        return SpcBaseConfigVo2.getChildList();
    }

    @Override
    public boolean updateConfigValue(String configValue, String configKey) {
        if (StringUtil.isEmpty((Object)configKey)) {
            return false;
        }
        List configList = this.spcBaseConfigMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SpcBaseConfig::getConfigKey, (Object)configKey));
        SpcBaseConfig config = null;
        if (CollectionUtil.isNotEmpty((Collection)configList)) {
            config = (SpcBaseConfig)((Object)configList.get(0));
        } else {
            config = new SpcBaseConfig();
            config.setConfigKey(configKey);
        }
        config.setConfigValue(configValue);
        this.saveOrUpdate((BaseEntity)config);
        this.getInfoAndPutToRedisAndParent(configKey);
        return true;
    }

    @Override
    @Transactional
    public Boolean updateConfigBatch(List<SpcBaseConfig> crmConfigList) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (SpcBaseConfig crmBaseConfig2 : crmConfigList) {
            crmBaseConfig2.setLastEditor(user.getId());
            crmBaseConfig2.setLastTime(date);
        }
        boolean saved = this.saveOrUpdateBatch(crmConfigList);
        crmConfigList.forEach(crmBaseConfig -> this.getInfoAndPutToRedisAndParent(crmBaseConfig.getConfigKey()));
        if (saved) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public Boolean updateBatchSecurity(List<SpcBaseConfig> crmConfigList) {
        if (ToolUtil.isEmpty(crmConfigList)) {
            throw new BaseException("\u672a\u4f20\u5165\u5b89\u5168\u914d\u7f6e\u4fe1\u606f");
        }
        return this.updateConfigBatch(crmConfigList);
    }

    private void collectConfigs(SpcBaseConfigVo configVo, List<SpcBaseConfig> allConfigs) {
        SpcBaseConfig crmBaseConfig = (SpcBaseConfig)((Object)BeanUtil.copyProperties((Object)configVo, SpcBaseConfig.class));
        allConfigs.add(crmBaseConfig);
        if (ToolUtil.isNotEmpty(configVo.getChildList())) {
            for (SpcBaseConfigVo child : configVo.getChildList()) {
                this.collectConfigs(child, allConfigs);
            }
        }
    }
}

