/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.baseManage.controlProjectManage.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dto.ControlProjectImportDto;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ReadControlProjectExcelUtil {
    private static int totalRows = 0;
    private static int totalCells = 0;
    private static String errorMsg;

    public static List<ControlProjectImportDto> getExcelInfo(MultipartFile mFile) {
        String fileName = mFile.getOriginalFilename();
        try {
            if (!ReadControlProjectExcelUtil.validateExcel(fileName)) {
                return null;
            }
            boolean isExcel2003 = true;
            if (ReadControlProjectExcelUtil.isExcel2007(fileName)) {
                isExcel2003 = false;
            }
            List<ControlProjectImportDto> userList = ReadControlProjectExcelUtil.createExcel(mFile.getInputStream(), isExcel2003);
            return userList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<ControlProjectImportDto> createExcel(InputStream is, boolean isExcel2003) {
        try {
            Object wb = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            List<ControlProjectImportDto> opportunityEntityList = ReadControlProjectExcelUtil.readExcelValue((Workbook)wb);
            return opportunityEntityList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<ControlProjectImportDto> readExcelValue(Workbook wb) {
        Sheet sheet = wb.getSheetAt(0);
        totalRows = sheet.getPhysicalNumberOfRows();
        if (totalRows > 1 && sheet.getRow(0) != null) {
            totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        ArrayList<ControlProjectImportDto> controlProjectList = new ArrayList<ControlProjectImportDto>();
        for (int r = 2; r < totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            Cell cell0 = row.getCell(0);
            if (row == null || cell0 == null || CellType.STRING.equals((Object)cell0.getCellType()) && "".equals(cell0.getStringCellValue())) continue;
            ControlProjectImportDto controlProject = new ControlProjectImportDto();
            block16: for (int c = 0; c < totalCells; ++c) {
                Cell cell = row.getCell(c);
                if (!ToolUtil.isNotEmpty((Object)cell)) continue;
                switch (c) {
                    case 0: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setControlProjectName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 1: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setDataTypeName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 2: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setFeatureTypeName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 3: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setChartTypeName(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                    }
                    case 4: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setUsl(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 5: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setSl(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 6: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setLsl(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 7: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        String includeTaxTotalPrice = cell.getStringCellValue().replaceAll("\\s*|\r|\n", "");
                        Integer includeTotalPrice = null;
                        if (StringUtil.isNotBlank((CharSequence)includeTaxTotalPrice)) {
                            includeTotalPrice = Integer.valueOf(includeTaxTotalPrice);
                        }
                        controlProject.setSubgroupSize(includeTotalPrice);
                        continue block16;
                    }
                    case 8: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setOneLevelType(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 9: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setTwoLevelType(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 10: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setThreeLevelType(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 11: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setFourLevelType(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                    case 12: {
                        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
                            cell.setCellType(CellType.STRING);
                        }
                        controlProject.setFiveLevelType(cell.getStringCellValue().replaceAll("\\s*|\r|\n", ""));
                        continue block16;
                    }
                }
            }
            controlProjectList.add(controlProject);
        }
        return controlProjectList;
    }

    public static boolean validateExcel(String filePath) {
        if (filePath == null || !ReadControlProjectExcelUtil.isExcel2003(filePath) && !ReadControlProjectExcelUtil.isExcel2007(filePath)) {
            errorMsg = "\u6587\u4ef6\u540d\u4e0d\u662fexcel\u683c\u5f0f";
            return false;
        }
        return true;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }
}

