/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.baseManage.baseConfig.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.baseManage.baseConfig.dto.BaseConfigDto;
import com.jxdinfo.spc.core.baseManage.baseConfig.model.ProcessVariableEntity;
import com.jxdinfo.spc.core.baseManage.baseConfig.service.IBaseConfigService;
import com.jxdinfo.spc.core.baseManage.baseConfig.service.IProcessVariableService;
import com.jxdinfo.spc.core.baseManage.baseConfig.vo.BaseConfigVo;
import com.jxdinfo.spc.core.baseManage.baseConfig.vo.ProcessVariableVo;
import com.jxdinfo.spc.core.baseManage.baseConfig.vo.ProjectLabelConfigVo;
import com.jxdinfo.spc.core.baseManage.baseConfig.vo.UpdateCron;
import com.jxdinfo.spc.core.common.service.ISpcBaseConfigService;
import com.jxdinfo.spc.core.common.vo.SpcBaseConfigVo;
import com.jxdinfo.spc.core.dataPool.dao.DataPoolDataMapper;
import com.jxdinfo.spc.core.dataPool.model.DataPoolDataEntity;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BaseConfigServiceImpl
implements IBaseConfigService {
    @Autowired
    private IProcessVariableService processVariableService;
    @Autowired
    private ISpcBaseConfigService spcBaseConfigService;
    @Autowired
    private DataPoolDataMapper dataPoolDataMapper;

    @Override
    @Transactional
    public Boolean save(BaseConfigDto baseConfigDto) {
        boolean isSuccess = false;
        try {
            List<ProcessVariableVo> processVariableVoList = baseConfigDto.getProcessVariableList();
            List processVariableEntityList = HussarUtils.copyProperties(processVariableVoList, ProcessVariableEntity.class);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            processVariableEntityList.stream().forEach(processVariableEntity -> {
                processVariableEntity.setLastEditor(securityUser.getUserId());
                if (processVariableEntity.getVariableId() == null) {
                    processVariableEntity.setCreator(securityUser.getUserId());
                }
                int index = processVariableEntityList.indexOf(processVariableEntity) + 1;
                processVariableEntity.setVariableFileName("field" + index);
            });
            isSuccess = this.processVariableService.saveOrUpdateBatch(processVariableEntityList);
            if (!isSuccess) {
                return false;
            }
            UpdateCron updateCron = baseConfigDto.getUpdateCron();
            String updateCronStr = baseConfigDto.getUpdateCronStr();
            if (updateCron != null && updateCron.getNum() != null) {
                updateCronStr = JSONObject.toJSONString((Object)updateCron);
            }
            if (HussarUtils.isNotEmpty((Object)updateCronStr)) {
                isSuccess = this.spcBaseConfigService.updateConfigValue(updateCronStr, "update_cron");
            }
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getDecimalNum())) {
                isSuccess = this.spcBaseConfigService.updateConfigValue(baseConfigDto.getDecimalNum(), "decimal_num");
            }
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getVirtualSubGroupSize())) {
                isSuccess = this.spcBaseConfigService.updateConfigValue(baseConfigDto.getVirtualSubGroupSize(), "virtual_sub_group_size");
            }
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getControlProjectIdLabel())) {
                isSuccess = this.spcBaseConfigService.updateConfigValue(baseConfigDto.getControlProjectIdLabel(), "control_project_id");
            }
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getControlProjectNameLabel())) {
                isSuccess = this.spcBaseConfigService.updateConfigValue(baseConfigDto.getControlProjectNameLabel(), "control_project_name");
            }
            if (HussarUtils.isNotEmpty((Object)baseConfigDto.getProjectTypeNameLabel())) {
                isSuccess = this.spcBaseConfigService.updateConfigValue(baseConfigDto.getProjectTypeNameLabel(), "project_type_name");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isSuccess;
    }

    @Override
    public BaseConfigVo formQuery() {
        List processVariableList = this.processVariableService.list();
        List processVariableVoList = HussarUtils.copyProperties((Collection)processVariableList, ProcessVariableVo.class);
        BaseConfigVo baseConfigVo = new BaseConfigVo();
        baseConfigVo.setProcessVariableVoList(processVariableVoList);
        SpcBaseConfigVo updateCronConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("update_cron");
        UpdateCron updateCron = (UpdateCron)JSONObject.parseObject((String)updateCronConfig.getConfigValue(), UpdateCron.class);
        baseConfigVo.setUpdateCron(updateCron);
        SpcBaseConfigVo decimalNumConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("decimal_num");
        baseConfigVo.setDecimalNum(decimalNumConfig.getConfigValue());
        SpcBaseConfigVo virtualSubGroupSizeConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("virtual_sub_group_size");
        baseConfigVo.setVirtualSubGroupSize(virtualSubGroupSizeConfig.getConfigValue());
        ProjectLabelConfigVo projectLabelConfigVo = this.getProjectLabelConfig();
        baseConfigVo.setControlProjectId(projectLabelConfigVo.getControlProjectId());
        baseConfigVo.setControlProjectName(projectLabelConfigVo.getControlProjectName());
        baseConfigVo.setProjectTypeName(projectLabelConfigVo.getProjectTypeName());
        return baseConfigVo;
    }

    @Override
    public List<ProcessVariableVo> filedList(BaseConfigDto baseConfigDto) {
        List<ProcessVariableVo> processVariableVoList = this.filedShortList();
        if (CollectionUtil.isEmpty(processVariableVoList)) {
            return processVariableVoList;
        }
        List enumList = processVariableVoList.stream().filter(processVariableVo -> processVariableVo.getVariableType().equals("2")).collect(Collectors.toList());
        List<DataPoolDataEntity> dataPoolDataList = this.dataPoolDataMapper.listByTypeOrProjectId(baseConfigDto);
        if (CollectionUtil.isNotEmpty(dataPoolDataList)) {
            for (ProcessVariableVo processVariableVo2 : enumList) {
                List<String> enumOptionList = this.getFieldValues(dataPoolDataList, processVariableVo2.getVariableFileName());
                processVariableVo2.setEnumOptionList(enumOptionList);
            }
        }
        return processVariableVoList;
    }

    @Override
    public List<ProcessVariableVo> filedShortList() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ProcessVariableEntity::getIsShow, (Object)"1");
        List processVariableList = this.processVariableService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)processVariableList)) {
            return new ArrayList<ProcessVariableVo>();
        }
        return HussarUtils.copyProperties((Collection)processVariableList, ProcessVariableVo.class);
    }

    private List<String> getFieldValues(List<DataPoolDataEntity> dataPoolDataList, String fileName) {
        Class<DataPoolDataEntity> clazz = DataPoolDataEntity.class;
        ArrayList<String> fieldValuesList = new ArrayList<String>();
        try {
            Field field = clazz.getDeclaredField(fileName);
            for (DataPoolDataEntity dataPoolDataEntity : dataPoolDataList) {
                field.setAccessible(true);
                String fileValue = (String)field.get(dataPoolDataEntity);
                fieldValuesList.add(fileValue);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        if (CollectionUtil.isNotEmpty(fieldValuesList)) {
            return fieldValuesList.stream().distinct().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public ProjectLabelConfigVo getProjectLabelConfig() {
        SpcBaseConfigVo controlProjectNameConfig;
        SpcBaseConfigVo controlProjecIdtConfig;
        ProjectLabelConfigVo projectLabelConfig = new ProjectLabelConfigVo();
        SpcBaseConfigVo projectTypeConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("project_type_name");
        if (HussarUtils.isNotEmpty((Object)projectTypeConfig)) {
            projectLabelConfig.setProjectTypeName(projectTypeConfig.getConfigValue());
        }
        if (HussarUtils.isNotEmpty((Object)(controlProjecIdtConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("control_project_id")))) {
            projectLabelConfig.setControlProjectId(controlProjecIdtConfig.getConfigValue());
        }
        if (HussarUtils.isNotEmpty((Object)(controlProjectNameConfig = this.spcBaseConfigService.getSpcBaseConfigByKey("control_project_name")))) {
            projectLabelConfig.setControlProjectName(controlProjectNameConfig.getConfigValue());
        }
        return projectLabelConfig;
    }
}

