/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.strategy;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.ChartStatistic;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.ControlChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.ControlChartDataVO;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import com.jxdinfo.spc.formula.api.util.quantity.XRControlChartUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class XbarRChartStrategy
extends ControlChartStrategy {
    @Override
    public void dataCheck() {
        this.commonDataChecked();
        AnalysisParamDto param = this.getAnalysisParam();
        int subGroupNum = Integer.parseInt(param.getSubgroupSize());
        if (this.getNodeList().size() < 2 || subGroupNum < 2) {
            throw new RuntimeException("\u5747\u503c\u6781\u5dee\u56fe\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u5b50\u7ec4\uff01");
        }
    }

    @Override
    public void generateControlData(AnalysisResultVO analysisResultVO) {
        ArrayList<ControlData> controlDataList = new ArrayList<ControlData>();
        AnalysisParamDto param = this.getAnalysisParam();
        List<List<BigDecimal>> nodeValueList = this.getNodeBigList();
        ArrayList<AbnormalData> allAbnormalDataList = new ArrayList<AbnormalData>();
        this.processAnalysisForXbarR(nodeValueList, this.getTotalNodeBigList(), param, analysisResultVO);
        String ucl = analysisResultVO.getControlChartDataVO().getUcl();
        String lcl = analysisResultVO.getControlChartDataVO().getLcl();
        String cl = analysisResultVO.getControlChartDataVO().getCl();
        String uclr = analysisResultVO.getControlChartDataVO().getRucl();
        String lclr = analysisResultVO.getControlChartDataVO().getRlcl();
        String clr = analysisResultVO.getControlChartDataVO().getRcl();
        String sigmaXBar = analysisResultVO.getControlChartDataVO().getSigmaXBar();
        String sigmaR = analysisResultVO.getControlChartDataVO().getSigmaR();
        String uclDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)ucl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String lclDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)lcl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String clDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)cl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String uclrDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)uclr), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String lclrDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)lclr), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String clrDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)clr), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        List<BigDecimal> xbarChartValueData = this.xbarChartAnalysis(nodeValueList);
        List<ChartStatistic> xBrStatisticList = this.generateData(xbarChartValueData, param, cl, sigmaXBar);
        ControlData xbarControlData = this.generateControlData("1", xBrStatisticList, uclDecimal, clDecimal, lclDecimal);
        controlDataList.add(xbarControlData);
        List<BigDecimal> rChartValueData = this.rChartAnalysis(nodeValueList);
        List<ChartStatistic> rStatisticList = this.generateData(rChartValueData, param, clr, sigmaR);
        ControlData rControlData = this.generateControlData("2", rStatisticList, uclrDecimal, clrDecimal, lclrDecimal);
        controlDataList.add(rControlData);
        List<AbnormalData> xBarAnalysisDataSourceList = this.generateAbnormalDataSource(xBrStatisticList, uclDecimal, lclDecimal, clDecimal, "1");
        List<AbnormalData> rAnalysisDataSourceList = this.generateAbnormalDataSource(rStatisticList, uclrDecimal, lclrDecimal, clrDecimal, "2");
        if (HussarUtils.isNotEmpty(xBarAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(xBarAnalysisDataSourceList);
        }
        if (HussarUtils.isNotEmpty(rAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(rAnalysisDataSourceList);
        }
        analysisResultVO.setAbnormalData(allAbnormalDataList);
        analysisResultVO.setControlData(controlDataList);
    }

    private void processAnalysisForXbarR(List<List<BigDecimal>> valueList, List<BigDecimal> totalValueList, AnalysisParamDto params, AnalysisResultVO analysisResultVO) {
        BigDecimal USL = StringUtils.isNotEmpty((CharSequence)params.getUsl()) ? new BigDecimal(params.getUsl()) : null;
        BigDecimal LSL = StringUtils.isNotEmpty((CharSequence)params.getLsl()) ? new BigDecimal(params.getLsl()) : null;
        BigDecimal d2 = new BigDecimal(params.getControlCoefficient().getCenterLineD2());
        BigDecimal A2 = new BigDecimal(params.getControlCoefficient().getControlLimitA2());
        BigDecimal D3 = new BigDecimal(Objects.equals(params.getControlCoefficient().getControlLimitD3(), "-") ? "0" : params.getControlCoefficient().getControlLimitD3());
        BigDecimal D4 = new BigDecimal(params.getControlCoefficient().getControlLimitD4());
        BigDecimal cl = !HussarUtils.isEmpty((Object)params.getCl()) ? new BigDecimal(params.getCl()) : XRControlChartUtil.calculateTotalAvgXBar(totalValueList);
        List batchRange = valueList.stream().map(batch -> Calc.getBigDecimal((Object)CommonUtil.getRange((List)batch))).collect(Collectors.toList());
        BigDecimal rclGroup = XRControlChartUtil.calculateTotalAvgXBar(batchRange);
        BigDecimal rcl = !HussarUtils.isEmpty((Object)params.getClr()) ? new BigDecimal(params.getClr()) : rclGroup;
        BigDecimal sigmaTotal = CommonUtil.calculateOverallSigma(totalValueList);
        BigDecimal sigmaGroup = XRControlChartUtil.calculateWithinGroupStdev((BigDecimal)rclGroup, (BigDecimal)d2);
        BigDecimal ucl = !HussarUtils.isEmpty((Object)params.getUcl()) ? new BigDecimal(params.getUcl()) : XRControlChartUtil.calculateXBarChartUCL((BigDecimal)cl, (BigDecimal)A2, (BigDecimal)rcl);
        BigDecimal lcl = !HussarUtils.isEmpty((Object)params.getLcl()) ? new BigDecimal(params.getLcl()) : XRControlChartUtil.calculateXBarChartLCL((BigDecimal)cl, (BigDecimal)A2, (BigDecimal)rcl);
        BigDecimal rUcl = !HussarUtils.isEmpty((Object)params.getUclr()) ? new BigDecimal(params.getUclr()) : XRControlChartUtil.calculateRChartUCL((BigDecimal)D4, (BigDecimal)rcl);
        BigDecimal rLcl = !HussarUtils.isEmpty((Object)params.getLclr()) ? new BigDecimal(params.getLclr()) : XRControlChartUtil.calculateRChartLCL((BigDecimal)D3, (BigDecimal)rcl);
        BigDecimal sigmaXBar = CommonUtil.calculateChartStdev((BigDecimal)ucl, (BigDecimal)lcl, (BigDecimal)cl);
        BigDecimal sigmaR = CommonUtil.calculateChartStdev((BigDecimal)rUcl, (BigDecimal)rLcl, (BigDecimal)rcl);
        int batchCount = valueList.size();
        long belowLslCount = LSL != null ? totalValueList.stream().filter(data -> data.compareTo(LSL) < 0).count() : 0L;
        long aboveUslCount = USL != null ? totalValueList.stream().filter(data -> data.compareTo(USL) > 0).count() : 0L;
        ControlChartDataVO controlChartDataVO = new ControlChartDataVO();
        controlChartDataVO.setUcl(ucl.toPlainString());
        controlChartDataVO.setLcl(lcl.toPlainString());
        controlChartDataVO.setCl(cl.toPlainString());
        controlChartDataVO.setRucl(rUcl.toPlainString());
        controlChartDataVO.setRlcl(rLcl.toPlainString());
        controlChartDataVO.setRcl(rcl.toPlainString());
        controlChartDataVO.setSigmaXBar(sigmaXBar.toPlainString());
        controlChartDataVO.setSigmaR(sigmaR.toPlainString());
        controlChartDataVO.setBatchCount(batchCount);
        controlChartDataVO.setSigmaGroup(sigmaGroup.toPlainString());
        controlChartDataVO.setSigmaTotal(sigmaTotal.toPlainString());
        controlChartDataVO.setAboveUslCount((int)aboveUslCount);
        controlChartDataVO.setBelowLslCount((int)belowLslCount);
        analysisResultVO.setControlChartDataVO(controlChartDataVO);
    }
}

