/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.strategy;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.ChartStatistic;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.ControlChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.ControlChartDataVO;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.common.CommonUtil;
import com.jxdinfo.spc.formula.api.util.quantity.IMRControlChartUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class IMRChartStrategy
extends ControlChartStrategy {
    @Override
    public void dataCheck() {
        this.commonDataChecked();
        List<List<String>> nodeList = this.getNodeList();
        if (nodeList.get(0).size() != 1) {
            throw new RuntimeException("\u5355\u503c\u79fb\u52a8\u6781\u5dee\u56fe\u5e94\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u5b50\u7ec4\uff01");
        }
    }

    @Override
    public void generateControlData(AnalysisResultVO analysisResultVO) {
        ArrayList<ControlData> controlDataList = new ArrayList<ControlData>();
        AnalysisParamDto param = this.getAnalysisParam();
        List<BigDecimal> nodeValueList = this.getTotalNodeBigList();
        ArrayList<AbnormalData> allAbnormalDataList = new ArrayList<AbnormalData>();
        this.processAnalysisForIMR(nodeValueList, param, analysisResultVO);
        String ucl = analysisResultVO.getControlChartDataVO().getUcl();
        String lcl = analysisResultVO.getControlChartDataVO().getLcl();
        String cl = analysisResultVO.getControlChartDataVO().getCl();
        String uclmr = analysisResultVO.getControlChartDataVO().getRucl();
        String lclmr = analysisResultVO.getControlChartDataVO().getRlcl();
        String clmr = analysisResultVO.getControlChartDataVO().getRcl();
        String sigma = analysisResultVO.getControlChartDataVO().getSigma();
        String sigmaMR = analysisResultVO.getControlChartDataVO().getSigmaMR();
        String uclDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)ucl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String lclDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)lcl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String clDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)cl), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String uclmrDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)uclmr), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String lclmrDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)lclmr), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        String clmrDecimal = Calc.tidyDecimal((BigDecimal)Calc.getBigDecimal((Object)clmr), (Integer)param.getDecimalNum(), (Boolean)true).toPlainString();
        List<ChartStatistic> iStatisticList = this.generateData(nodeValueList, param, cl, sigma);
        ControlData iControlData = this.generateControlData("3", iStatisticList, uclDecimal, clDecimal, lclDecimal);
        controlDataList.add(iControlData);
        List<BigDecimal> mrChartValueData = this.mrChartAnalysis(nodeValueList);
        List<ChartStatistic> mrStatisticList = this.generateData(mrChartValueData, param, clmr, sigmaMR);
        ControlData rControlData = this.generateControlData("4", mrStatisticList, uclmrDecimal, clmrDecimal, lclmrDecimal);
        controlDataList.add(rControlData);
        List<AbnormalData> iAnalysisDataSourceList = this.generateAbnormalDataSource(iStatisticList, uclDecimal, lclDecimal, clDecimal, "3");
        List<AbnormalData> mrAnalysisDataSourceList = this.generateAbnormalDataSource(mrStatisticList, uclmrDecimal, lclmrDecimal, clmrDecimal, "4");
        if (HussarUtils.isNotEmpty(iAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(iAnalysisDataSourceList);
        }
        if (HussarUtils.isNotEmpty(mrAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(mrAnalysisDataSourceList);
        }
        analysisResultVO.setAbnormalData(allAbnormalDataList);
        analysisResultVO.setControlData(controlDataList);
    }

    private void processAnalysisForIMR(List<BigDecimal> nodeValueList, AnalysisParamDto params, AnalysisResultVO analysisResultVO) {
        BigDecimal USL = StringUtils.isNotEmpty((CharSequence)params.getUsl()) ? new BigDecimal(params.getUsl()) : null;
        BigDecimal LSL = StringUtils.isNotEmpty((CharSequence)params.getLsl()) ? new BigDecimal(params.getLsl()) : null;
        BigDecimal d2 = new BigDecimal(params.getControlCoefficient().getCenterLineD2());
        BigDecimal E2 = new BigDecimal(params.getControlCoefficient().getControlLimitE2());
        BigDecimal D3 = new BigDecimal(Objects.equals(params.getControlCoefficient().getControlLimitD3(), "-") ? "0.00" : params.getControlCoefficient().getControlLimitD3());
        BigDecimal D4 = new BigDecimal(params.getControlCoefficient().getControlLimitD4());
        BigDecimal cl = !HussarUtils.isEmpty((Object)params.getCl()) ? new BigDecimal(params.getCl()) : CommonUtil.getAverage(nodeValueList);
        List<BigDecimal> movingRangeList = this.mrChartAnalysis(nodeValueList);
        BigDecimal clGroup = CommonUtil.getAverage(movingRangeList);
        BigDecimal clMr = !HussarUtils.isEmpty((Object)params.getClr()) ? new BigDecimal(params.getClr()) : clGroup;
        if (clMr.compareTo(BigDecimal.ZERO) == 0) {
            throw new HussarException("\u79fb\u52a8\u6781\u5dee\u5e73\u5747\u503c\u4e0d\u80fd\u4e3a0");
        }
        BigDecimal sigmaGroup = IMRControlChartUtil.estimateProcessStdevFromMRBar((BigDecimal)clGroup, (BigDecimal)d2);
        BigDecimal sigmaTotal = CommonUtil.calculateOverallSigma(nodeValueList);
        BigDecimal ucl = !HussarUtils.isEmpty((Object)params.getUcl()) ? new BigDecimal(params.getUcl()) : IMRControlChartUtil.calculateIChartUCL((BigDecimal)cl, (BigDecimal)E2, (BigDecimal)clMr);
        BigDecimal lcl = !HussarUtils.isEmpty((Object)params.getLcl()) ? new BigDecimal(params.getLcl()) : IMRControlChartUtil.calculateIChartLCL((BigDecimal)cl, (BigDecimal)E2, (BigDecimal)clMr);
        BigDecimal uclMr = !HussarUtils.isEmpty((Object)params.getUclr()) ? new BigDecimal(params.getUclr()) : IMRControlChartUtil.calculateMRChartUCL((BigDecimal)D4, (BigDecimal)clMr);
        BigDecimal lclMr = !HussarUtils.isEmpty((Object)params.getLclr()) ? new BigDecimal(params.getLclr()) : IMRControlChartUtil.calculateMRChartLCL((BigDecimal)D3, (BigDecimal)clMr);
        BigDecimal sigmaMR = CommonUtil.calculateChartStdev((BigDecimal)uclMr, (BigDecimal)lclMr, (BigDecimal)clMr);
        BigDecimal sigmaX = CommonUtil.calculateChartStdev((BigDecimal)ucl, (BigDecimal)lcl, (BigDecimal)cl);
        int batchCount = nodeValueList.size();
        long belowLslCount = LSL != null ? nodeValueList.stream().filter(data -> data.compareTo(LSL) < 0).count() : 0L;
        long aboveUslCount = USL != null ? nodeValueList.stream().filter(data -> data.compareTo(USL) > 0).count() : 0L;
        ControlChartDataVO imRControlChartDataVO = new ControlChartDataVO();
        imRControlChartDataVO.setUcl(ucl.toPlainString());
        imRControlChartDataVO.setLcl(lcl.toPlainString());
        imRControlChartDataVO.setCl(cl.toPlainString());
        imRControlChartDataVO.setRucl(uclMr.toPlainString());
        imRControlChartDataVO.setRlcl(lclMr.toPlainString());
        imRControlChartDataVO.setRcl(clMr.toPlainString());
        imRControlChartDataVO.setSigmaMR(sigmaMR.toPlainString());
        imRControlChartDataVO.setSigma(sigmaX.toPlainString());
        imRControlChartDataVO.setSigmaGroup(sigmaGroup.toPlainString());
        imRControlChartDataVO.setSigmaTotal(sigmaTotal.toPlainString());
        imRControlChartDataVO.setBatchCount(batchCount);
        imRControlChartDataVO.setBelowLslCount((int)belowLslCount);
        imRControlChartDataVO.setAboveUslCount((int)aboveUslCount);
        analysisResultVO.setControlChartDataVO(imRControlChartDataVO);
    }

    private List<BigDecimal> mrChartAnalysis(List<BigDecimal> valueList) {
        ArrayList<BigDecimal> movingRangeList = new ArrayList<BigDecimal>();
        for (int i = 1; i < valueList.size(); ++i) {
            BigDecimal data = valueList.get(i).subtract(valueList.get(i - 1));
            movingRangeList.add(Calc.getBigDecimal((Object)CommonUtil.getAbs((BigDecimal)data)));
        }
        return movingRangeList;
    }
}

