/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.factory;

import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.spc.core.analysisManage.analysisTool.service.SpcService;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.CChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.ControlChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.IMRChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.NpChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.PChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.UChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.XMedRChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.XbarRChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.XbarSChartStrategy;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ChartStrategyFactory {
    @Resource
    private SpcService spcService;
    @Resource
    private XbarRChartStrategy xbarRChartStrategy;
    @Resource
    private XMedRChartStrategy xmedrChartStrategy;
    @Resource
    private IMRChartStrategy imrChartStrategy;
    @Resource
    private XbarSChartStrategy xbarSChartStrategy;
    @Resource
    private NpChartStrategy npChartStrategy;
    @Resource
    private PChartStrategy pChartStrategy;
    @Resource
    private CChartStrategy cChartStrategy;
    @Resource
    private UChartStrategy uChartStrategy;

    public ControlChartStrategy createStrategy(String chartType) {
        switch (chartType) {
            case "xr": {
                this.xbarRChartStrategy.configure(this.spcService);
                return this.xbarRChartStrategy;
            }
            case "x_r": {
                this.xmedrChartStrategy.configure(this.spcService);
                return this.xmedrChartStrategy;
            }
            case "xmr": {
                this.imrChartStrategy.configure(this.spcService);
                return this.imrChartStrategy;
            }
            case "xs": {
                this.xbarSChartStrategy.configure(this.spcService);
                return this.xbarSChartStrategy;
            }
            case "np": {
                this.npChartStrategy.configure(this.spcService);
                return this.npChartStrategy;
            }
            case "p": {
                this.pChartStrategy.configure(this.spcService);
                return this.pChartStrategy;
            }
            case "u": {
                this.uChartStrategy.configure(this.spcService);
                return this.uChartStrategy;
            }
            case "c": {
                this.cChartStrategy.configure(this.spcService);
                return this.cChartStrategy;
            }
        }
        throw new HussarException("\u4e0d\u652f\u6301\u7684\u63a7\u5236\u56fe\u7c7b\u578b\uff1a" + chartType + "\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
    }
}

