/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.patterns;

import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.Pattern;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalAnalysis;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalJudgmentFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisUtils;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.dto.AbnormalPatternDto;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedDeque;

public class Pattern7
extends Pattern {
    @Override
    public AbnormalAnalysis getAnalysis(AbnormalPatternDto dto) {
        String kValue = this.getParam(dto, "pattern7", "kValue", "15");
        int k = (int)Math.floor(Double.parseDouble(kValue));
        ConcurrentLinkedDeque window = new ConcurrentLinkedDeque();
        AnalysisFunction analysisFunc = (nodes, index, buffer) -> {
            AnalysisNode node = (AnalysisNode)nodes.get(index);
            BigDecimal cl = dto.getCl();
            BigDecimal stdDev = dto.getStdDev();
            if (cl == null || stdDev == null) {
                return Collections.emptyList();
            }
            BigDecimal upper1Sigma = AnalysisUtils.upperBound(cl, stdDev, 1.0);
            BigDecimal lower1Sigma = AnalysisUtils.lowerBound(cl, stdDev, 1.0);
            boolean isInside = node.getValue().compareTo(lower1Sigma) >= 0 && node.getValue().compareTo(upper1Sigma) <= 0;
            window.addLast(isInside);
            if (window.size() > k) {
                window.removeFirst();
            }
            if (window.size() == k && window.stream().allMatch(b -> b)) {
                node.addTag("pattern7", "7");
                return Collections.singletonList(node);
            }
            return Collections.emptyList();
        };
        return new AbnormalAnalysis(analysisFunc, AbnormalJudgmentFunction::commonJudge);
    }
}

