/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.patterns;

import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.Pattern;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalAnalysis;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalJudgmentFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisUtils;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.dto.AbnormalPatternDto;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.dto.WindowPoint;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class Pattern5
extends Pattern {
    @Override
    public AbnormalAnalysis getAnalysis(AbnormalPatternDto dto) {
        String kValue = this.getParam(dto, "pattern5", "kValue", "2");
        int k = (int)Math.floor(Double.parseDouble(kValue));
        ArrayDeque window = new ArrayDeque(k);
        HashSet markedIndexes = new HashSet();
        AnalysisFunction analysisFunc = (nodes, index, buffer) -> {
            if (k < 2) {
                window.clear();
                markedIndexes.clear();
                return Collections.emptyList();
            }
            AnalysisNode currentNode = (AnalysisNode)nodes.get(index);
            BigDecimal cl = dto.getCl();
            BigDecimal stdDev = dto.getStdDev();
            if (cl == null || stdDev == null) {
                window.clear();
                markedIndexes.clear();
                return Collections.emptyList();
            }
            BigDecimal upper2Sigma = AnalysisUtils.upperBound(cl, stdDev, 2.0);
            BigDecimal lower2Sigma = AnalysisUtils.lowerBound(cl, stdDev, 2.0);
            boolean isAbove = AnalysisUtils.isAboveCl(currentNode, cl);
            boolean isBeyond = isAbove && currentNode.getValue().compareTo(upper2Sigma) > 0 || !isAbove && currentNode.getValue().compareTo(lower2Sigma) < 0;
            window.addLast(new WindowPoint(index, isBeyond, isAbove));
            if (window.size() > k) {
                window.removeFirst();
            }
            ArrayList<AnalysisNode> result = new ArrayList<AnalysisNode>(1);
            if (window.size() == k || index == k - 2) {
                AnalysisNode targetNode;
                int upperBeyondCount = 0;
                int lowerBeyondCount = 0;
                WindowPoint lastUpperBeyond = null;
                WindowPoint lastLowerBeyond = null;
                for (WindowPoint wp : window) {
                    if (!wp.isBeyond()) continue;
                    if (wp.getSide().booleanValue()) {
                        ++upperBeyondCount;
                        lastUpperBeyond = wp;
                        continue;
                    }
                    ++lowerBeyondCount;
                    lastLowerBeyond = wp;
                }
                if (upperBeyondCount >= k - 1 && lastUpperBeyond != null && !markedIndexes.contains(lastUpperBeyond.getIndex())) {
                    targetNode = (AnalysisNode)nodes.get(lastUpperBeyond.getIndex());
                    targetNode.addTag("pattern5", "5");
                    result.add(targetNode);
                    markedIndexes.add(lastUpperBeyond.getIndex());
                } else if (lowerBeyondCount >= k - 1 && lastLowerBeyond != null && !markedIndexes.contains(lastLowerBeyond.getIndex())) {
                    targetNode = (AnalysisNode)nodes.get(lastLowerBeyond.getIndex());
                    targetNode.addTag("pattern5", "5");
                    result.add(targetNode);
                    markedIndexes.add(lastLowerBeyond.getIndex());
                }
            }
            return result;
        };
        return new AbnormalAnalysis(analysisFunc, AbnormalJudgmentFunction::commonJudge);
    }
}

