/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.patterns;

import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.Pattern;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalAnalysis;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalJudgmentFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.dto.AbnormalPatternDto;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedDeque;

public class Pattern3
extends Pattern {
    private static final String PATTERN_TAG = "pattern3";
    private static final String TAG_PARAM = "3";
    private static final String K_VALUE_KEY = "kValue";
    private static final int DEFAULT_K = 6;
    private static final int MIN_K = 2;

    @Override
    public AbnormalAnalysis getAnalysis(AbnormalPatternDto dto) {
        int k = this.parseValidKValue(dto);
        ConcurrentLinkedDeque trendWindow = new ConcurrentLinkedDeque();
        AnalysisFunction analysisFunc = (nodes, index, buffer) -> {
            if (index == 0) {
                return Collections.emptyList();
            }
            AnalysisNode currentNode = (AnalysisNode)nodes.get(index);
            AnalysisNode prevNode = (AnalysisNode)nodes.get(index - 1);
            int valueCompare = currentNode.getValue().compareTo(prevNode.getValue());
            if (valueCompare == 0) {
                trendWindow.clear();
                return Collections.emptyList();
            }
            boolean isUpTrend = valueCompare > 0;
            trendWindow.addLast(isUpTrend);
            if (trendWindow.size() > k) {
                trendWindow.removeFirst();
            }
            if (trendWindow.size() == k) {
                boolean allUp = trendWindow.stream().allMatch(trend -> trend);
                boolean allDown = trendWindow.stream().noneMatch(trend -> trend);
                if (allUp || allDown) {
                    currentNode.addTag(PATTERN_TAG, TAG_PARAM);
                    return Collections.singletonList(currentNode);
                }
            }
            return Collections.emptyList();
        };
        return new AbnormalAnalysis(analysisFunc, AbnormalJudgmentFunction::commonJudge);
    }

    private int parseValidKValue(AbnormalPatternDto dto) {
        String kValueStr = this.getParam(dto, PATTERN_TAG, K_VALUE_KEY, String.valueOf(6));
        try {
            double kDouble = Double.parseDouble(kValueStr.trim());
            int parsedK = (int)Math.floor(kDouble);
            return Math.max(parsedK, 2);
        }
        catch (NullPointerException | NumberFormatException e) {
            return 6;
        }
    }
}

