/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.patterns;

import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.Pattern;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalAnalysis;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalJudgmentFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisUtils;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.dto.AbnormalPatternDto;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedDeque;

public class Pattern2
extends Pattern {
    @Override
    public AbnormalAnalysis getAnalysis(AbnormalPatternDto dto) {
        String kValue = this.getParam(dto, "pattern2", "kValue", "8");
        int k = (int)Math.floor(Double.parseDouble(kValue));
        ConcurrentLinkedDeque window = new ConcurrentLinkedDeque();
        AnalysisFunction analysisFunc = (nodes, index, buffer) -> {
            AnalysisNode node = (AnalysisNode)nodes.get(index);
            boolean isAbove = AnalysisUtils.isAboveCl(node, dto.getCl());
            window.addLast(isAbove);
            if (window.size() > k) {
                window.removeFirst();
            }
            if (window.size() == k) {
                boolean allAbove = window.stream().allMatch(b -> b);
                boolean allBelow = window.stream().noneMatch(b -> b);
                if (allAbove || allBelow) {
                    node.addTag("pattern2", "2");
                    return Collections.singletonList(node);
                }
            }
            return Collections.emptyList();
        };
        return new AbnormalAnalysis(analysisFunc, AbnormalJudgmentFunction::commonJudge);
    }
}

