/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class AnalysisNode {
    private final int index;
    private final BigDecimal value;
    private List<String> abnormalTags;
    private List<String> abnormalNum;
    private Map<String, String> tags;

    public AnalysisNode(int index, BigDecimal value) {
        this.index = index;
        this.value = value;
        this.tags = new ConcurrentHashMap<String, String>();
    }

    public synchronized void addTag(String tag, String num) {
        if (this.abnormalTags == null) {
            this.abnormalTags = new ArrayList<String>(12);
            this.abnormalNum = new ArrayList<String>(12);
        }
        if (!this.abnormalTags.contains(tag)) {
            this.abnormalTags.add(tag);
            this.abnormalNum.add(num);
        }
        this.tags.put(tag, num);
    }

    public int getIndex() {
        return this.index;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public synchronized List<String> getAbnormalTags() {
        return this.abnormalTags == null ? Collections.emptyList() : new ArrayList<String>(this.abnormalTags);
    }

    public synchronized List<String> getAbnormalNum() {
        return this.abnormalNum == null ? Collections.emptyList() : new ArrayList<String>(this.abnormalNum);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalysisNode that = (AnalysisNode)o;
        return this.index == that.index;
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }
}

