/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisInfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisBaseDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AnalysisInfoEntity;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AbnormalDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AsyncAnalysisInfoService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.ControlDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.IAnalysisInfoService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.relationRule.model.RelationRuleEntity;
import com.jxdinfo.spc.core.common.util.CommonUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AsyncAnalysisInfoServiceImpl
implements AsyncAnalysisInfoService {
    @Resource
    private IAnalysisInfoService analysisInfoService;
    @Resource
    private ControlDataService controlDataService;
    @Resource
    private AbnormalDataService abnormalDataService;

    @Override
    @Async
    public AnalysisResultVO analysis(AnalysisInfoEntity analysisInfo, SecurityUser user, LocalDateTime date, List<AnalysisDataSource> analysisDataSourceList, List<RelationRuleEntity> relationRuleEntityList) {
        AnalysisBaseDto analysisBaseDto;
        AnalysisParamDto analysisParamDto;
        AnalysisResultVO analysisResultVO;
        List<AbnormalData> abnormalDataList;
        Long analysisId = analysisInfo.getAnalysisId();
        String historyId = CommonUtils.generateAssignId();
        if ("2".equals(analysisInfo.getAnalysisStatus()) && "3".equals(analysisInfo.getSourceType())) {
            historyId = analysisInfo.getHistoryAnalysisId();
        }
        if (HussarUtils.isNotEmpty(abnormalDataList = (analysisResultVO = this.controlDataService.chartAnalysis(analysisParamDto = this.analysisInfoService.initializeParamDto(analysisInfo, user, date, (analysisBaseDto = this.analysisInfoService.initializeBaseInfo(analysisInfo, analysisDataSourceList, relationRuleEntityList)).getRelationRuleVOList(), analysisBaseDto.getAnalysisDataSourceList()))).getAbnormalData()) && HussarUtils.isNotEmpty(analysisResultVO.getControlData())) {
            Map<String, String> snapshotMap = this.abnormalDataService.saveSnapshot(analysisResultVO);
            for (AbnormalData abnormalData : abnormalDataList) {
                String snapshotId = snapshotMap.get(abnormalData.getChartType());
                abnormalData.setAbnormalSnapshotId(snapshotId);
                abnormalData.setHistoryAnalysisId(historyId);
            }
            this.abnormalDataService.saveBatch(abnormalDataList);
            this.analysisInfoService.relationAbnormalData(analysisResultVO, analysisInfo, abnormalDataList);
        }
        if ("3".equals(analysisInfo.getSourceType())) {
            this.analysisInfoService.deleteAnalysisResult(analysisInfo);
        }
        this.analysisInfoService.saveAnalysisResult(analysisInfo, analysisResultVO);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        if ("1".equals(analysisInfo.getAnalysisStatus())) {
            analysisInfo.setHistoryAnalysisId(historyId);
            analysisInfo.setIsPolling("1");
            this.analysisInfoService.saveHistoryResult(analysisInfo, analysisResultVO);
            this.analysisInfoService.saveHistoryAnalysis(analysisInfo, analysisResultVO, analysisBaseDto.getRelationRuleVOList(), analysisBaseDto.getRelationWarnObjectEntityList());
            this.analysisInfoService.saveHistoryDataSource(analysisBaseDto.getAnalysisDataSourceList(), historyId);
            ((LambdaUpdateWrapper)updateWrapper.set(AnalysisInfoEntity::getAnalysisStatus, (Object)"2")).set(AnalysisInfoEntity::getHistoryAnalysisId, (Object)historyId);
        }
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(AnalysisInfoEntity::getAnalysisId, (Object)analysisId)).set(AnalysisInfoEntity::getLastAnalysisTime, (Object)date)).set(HussarBaseEntity::getLastEditor, (Object)user.getId())).set(AnalysisInfoEntity::getLastEditorName, (Object)user.getUserName())).set(HussarBaseEntity::getLastTime, (Object)date)).set(AnalysisInfoEntity::getIsPolling, (Object)"1");
        if ("3".equals(analysisInfo.getSourceType())) {
            updateWrapper.set(AnalysisInfoEntity::getAnalysisStatus, (Object)"2");
        } else {
            updateWrapper.set(AnalysisInfoEntity::getAnalysisStatus, (Object)"3");
        }
        this.analysisInfoService.update((Wrapper)updateWrapper);
        CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(() -> this.analysisInfoService.generateWarningMessage(analysisResultVO, analysisInfo, analysisBaseDto.getRelationWarnObjectEntityList()));
        return analysisResultVO;
    }
}

