/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisInfo.job;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.spc.adapter.instance.service.InstanceApiService;
import com.jxdinfo.spc.adapter.instance.vo.InstanceInfoApiVo;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisDataSource.service.IAnalysisDataSourceService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AnalysisInfoEntity;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.AsyncAnalysisInfoService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.IAnalysisInfoService;
import com.jxdinfo.spc.core.dataPool.service.IDataPoolDataService;
import com.jxdinfo.spc.core.operatelog.service.OperateLogAPIService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DynamicAnalysisJob
implements BasicProcessor {
    @Autowired
    private IAnalysisInfoService analysisInfoService;
    @Autowired
    private IDataPoolDataService dataPoolDataService;
    @Autowired
    private IAnalysisDataSourceService analysisDataSourceService;
    @Resource
    private OperateLogAPIService operateLogAPIService;
    @Resource
    private AsyncAnalysisInfoService asyncAnalysisInfoService;
    @Resource
    private InstanceApiService instanceApiService;

    public ProcessResult process(TaskContext taskContext) throws Exception {
        InstanceInfoApiVo instance = this.instanceApiService.getInstanceInfo(taskContext.getInstanceId());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(AnalysisInfoEntity::getJobId, (Object)instance.getJobId());
        AnalysisInfoEntity analysisInfoEntity = (AnalysisInfoEntity)((Object)this.analysisInfoService.getOne((Wrapper)queryWrapper));
        SecurityUser user = new SecurityUser();
        user.setUserId(null);
        user.setUserName("\u7cfb\u7edf");
        LocalDateTime date = LocalDateTime.now();
        List<Object> dataSourceList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)((Object)analysisInfoEntity))) {
            List<AnalysisDataSource> analysisDataSourceList = this.analysisInfoService.getDataSuitableForAnalysis(analysisInfoEntity);
            if (HussarUtils.isEmpty(analysisDataSourceList)) {
                return new ProcessResult(true);
            }
            this.analysisDataSourceService.saveOrUpdateBatch(analysisDataSourceList);
            dataSourceList = analysisDataSourceList.stream().sorted(Comparator.comparing(AnalysisDataSource::getDataSort, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
            int lastSort = ((AnalysisDataSource)((Object)dataSourceList.get(dataSourceList.size() - 1))).getDataSort();
            analysisInfoEntity.setLastSort(lastSort);
            this.analysisInfoService.updateById((Object)analysisInfoEntity);
            this.asyncAnalysisInfoService.analysis(analysisInfoEntity, user, date, dataSourceList, null);
        }
        return new ProcessResult(true);
    }
}

