/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisDataSource.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.spc.core.analysisDataSource.dto.DataSourceDto;
import com.jxdinfo.spc.core.analysisDataSource.model.AnalysisDataSource;
import com.jxdinfo.spc.core.analysisDataSource.service.IAnalysisDataSourceService;
import com.jxdinfo.spc.core.analysisDataSource.vo.AnalysisDataSourcePageVo;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/spc/analysisDataSource"})
@AuditLog(moduleName="\u5206\u6790\u6570\u636e\u6e90")
public class AnalysisDataSourceController {
    @Resource
    private IAnalysisDataSourceService analysisDataSourceService;

    @PostMapping(value={"/queryList"})
    @ApiOperation(value="\u5206\u6790\u56fe\u8be6\u60c5\u6570\u636e\u6e90tab\u5206\u9875", notes="\u5206\u6790\u56fe\u8be6\u60c5\u6570\u636e\u6e90tab\u5206\u9875")
    @AuditLog(moduleName="\u5206\u6790\u6570\u636e\u6e90", eventDesc="\u5206\u6790\u56fe\u8be6\u60c5\u6570\u636e\u6e90tab\u5206\u9875", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<AnalysisDataSource>> queryList(@RequestBody DataSourceDto dto) {
        List<AnalysisDataSource> list = this.analysisDataSourceService.queryList(dto);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u5206\u6790\u56fe\u8be6\u60c5\u6570\u636e\u6e90tab\u5217\u8868", notes="\u5206\u6790\u56fe\u8be6\u60c5\u6570\u636e\u6e90tab\u5217\u8868")
    @AuditLog(moduleName="\u5206\u6790\u6570\u636e\u6e90", eventDesc="\u5206\u6790\u56fe\u8be6\u60c5\u6570\u636e\u6e90tab\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<AnalysisDataSourcePageVo> queryPage(@RequestBody DataSourceDto dto) {
        AnalysisDataSourcePageVo page = this.analysisDataSourceService.queryPage(dto);
        return ApiResponse.success((Object)page);
    }

    @PostMapping(value={"/excludeAnalysis"})
    @ApiOperation(value="\u6392\u9664/\u4e0d\u6392\u9664\u91cd\u65b0\u5206\u6790", notes="\u6392\u9664/\u4e0d\u6392\u9664\u91cd\u65b0\u5206\u6790")
    @AuditLog(moduleName="\u5206\u6790\u6570\u636e\u6e90", eventDesc="\u6392\u9664/\u4e0d\u6392\u9664\u91cd\u65b0\u5206\u6790", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> excludeAnalysis(@RequestBody DataSourceDto dto) {
        return ApiResponse.success((Object)this.analysisDataSourceService.excludeAnalysis(dto));
    }
}

