/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.organUserRoleSelector.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.spc.adapter.api.organUser.vo.OrganUserTreeApiVo;
import com.jxdinfo.spc.core.organUserRoleSelector.constant.OrganUserConstant;
import com.jxdinfo.spc.core.organUserRoleSelector.service.IOrganUserService;
import com.jxdinfo.spc.core.organUserRoleSelector.vo.RoleTreeVo;
import com.jxdinfo.spc.core.organUserRoleSelector.vo.SearchOrganUserRoleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9009\u7ec4\u7ec7\u9009\u4eba\u5458\u7ec4\u4ef6"})
@RequestMapping(value={"/selector/organAndUserAndRole"})
public class OrganUserRoleController {
    @Resource
    private IOrganUserService organUserService;

    @GetMapping(value={"/lazyOrganUserTree"})
    @ApiOperation(value="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7ed3\u6784\u6811", notes="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7ed3\u6784\u6811")
    @AuditLog(moduleName="\u9009\u7ec4\u7ec7\u9009\u4eba\u5458\u7ec4\u4ef6", eventDesc="\u61d2\u52a0\u8f7d\u7ec4\u7ec7\u7ed3\u6784\u6811", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganUserTreeApiVo>> lazyOrganUserTree(@RequestParam(value="departmentId") @ApiParam(value="\u4e0a\u7ea7id") Long departmentId) {
        List<OrganUserTreeApiVo> organUserTreeVoList = this.organUserService.lazyOrganUserTree(departmentId, OrganUserConstant.RESULT_TYPE_ORGAN);
        return ApiResponse.success(organUserTreeVoList);
    }

    @GetMapping(value={"/getUsersByOrganUser"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u7528\u6237\u5217\u8868", notes="\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @AuditLog(moduleName="\u9009\u7ec4\u7ec7\u9009\u4eba\u5458\u7ec4\u4ef6", eventDesc="\u6839\u636e\u7ec4\u7ec7\u83b7\u53d6\u7528\u6237\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<OrganUserTreeApiVo>> getUsersByOrganUser(@RequestParam(value="departmentId") @ApiParam(value="\u4e0a\u7ea7id") Long departmentId) {
        List<OrganUserTreeApiVo> organUserTreeVoList = this.organUserService.lazyOrganUserTree(departmentId, OrganUserConstant.RESULT_TYPE_ORGAN_USER);
        return ApiResponse.success(organUserTreeVoList);
    }

    @GetMapping(value={"/searchOrganAndUserAndRole"})
    @ApiOperation(value="\u6a21\u7cca\u641c\u7d22\u7ec4\u7ec7\u3001\u4eba\u548c\u89d2\u8272", notes="\u6a21\u7cca\u641c\u7d22\u7ec4\u7ec7\u3001\u4eba\u548c\u89d2\u8272")
    @AuditLog(moduleName="\u9009\u7ec4\u7ec7\u9009\u4eba\u5458\u7ec4\u4ef6", eventDesc="\u6a21\u7cca\u641c\u7d22\u7ec4\u7ec7\u3001\u4eba\u548c\u89d2\u8272", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SearchOrganUserRoleVo>> searchOrganAndUserAndRole(@RequestParam(value="keyword") @ApiParam(value="\u5173\u952e\u5b57") String keyword, @RequestParam(name="struFid") @ApiParam(value="\u5168\u4e3b\u952eID") String struFid, @RequestParam(name="types") List<String> types) {
        List<SearchOrganUserRoleVo> organUserTreeVoList = this.organUserService.searchOrganAndUserAndRole(keyword, struFid, types);
        return ApiResponse.success(organUserTreeVoList);
    }

    @GetMapping(value={"/lazyRoleTree"})
    @ApiOperation(value="\u61d2\u52a0\u8f7d\u89d2\u8272\u6811", notes="\u61d2\u52a0\u8f7d\u89d2\u8272\u6811")
    @AuditLog(moduleName="\u9009\u7ec4\u7ec7\u9009\u4eba\u5458\u7ec4\u4ef6", eventDesc="\u61d2\u52a0\u8f7d\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<RoleTreeVo>> lazyRoleTree(@RequestParam(name="id", required=false) @ApiParam(value="id") Long id) {
        List<RoleTreeVo> roleTreeList = this.organUserService.lazyRoleGroup(id);
        return ApiResponse.success(roleTreeList);
    }
}

