/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.operatelog.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.spc.core.operatelog.context.OperateLogContext;
import com.jxdinfo.spc.core.operatelog.dao.OperateLogMapper;
import com.jxdinfo.spc.core.operatelog.dto.OperateLogAPIDTO;
import com.jxdinfo.spc.core.operatelog.dto.OperateLogDTO;
import com.jxdinfo.spc.core.operatelog.model.OperateLog;
import com.jxdinfo.spc.core.operatelog.service.OperateLogService;
import com.jxdinfo.spc.core.operatelog.vo.JsonItem;
import com.jxdinfo.spc.core.operatelog.vo.OperateLogVO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperateLogServiceImpl
extends HussarServiceImpl<OperateLogMapper, OperateLog>
implements OperateLogService {
    private static final Logger logger = LoggerFactory.getLogger(OperateLogServiceImpl.class);
    @Autowired
    private OperateLogMapper operateLogMapper;

    @Override
    public Page<OperateLogVO> queryOperateLogList(OperateLogDTO dto) {
        if (HussarUtils.isEmpty((Object)dto)) {
            throw new HussarException("\u53c2\u6570\u4e3a\u7a7a");
        }
        String businessType = dto.getBusinessType();
        if (HussarUtils.isEmpty((Object)businessType)) {
            throw new HussarException("\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        }
        ArrayList<OperateLogVO> operateLogVOList = new ArrayList<OperateLogVO>();
        Page page = dto.getPage();
        switch (businessType) {
            case "\u7c7b\u578ba": {
                dto.setBusinessType(null);
                List<OperateLogVO> projectLogs = this.operateLogMapper.queryOperateLogList(page, dto);
                if (HussarUtils.isNotEmpty(projectLogs)) {
                    OperateLogServiceImpl.convertAndSetContentItems(projectLogs, true);
                    operateLogVOList.addAll(projectLogs);
                }
                page.setRecords(projectLogs);
                break;
            }
            default: {
                List<OperateLogVO> logs = this.operateLogMapper.queryOperateLogList(page, dto);
                if (HussarUtils.isNotEmpty(logs)) {
                    OperateLogServiceImpl.convertAndSetContentItems(logs, true);
                    operateLogVOList.addAll(logs);
                }
                page.setRecords(logs);
            }
        }
        return page;
    }

    @Override
    public Boolean recordOperateLog(OperateLogContext context) {
        if (HussarUtils.isEmpty((Object)context)) {
            return false;
        }
        Long operatorId = context.getOperatorId();
        String operatorName = context.getOperatorName();
        LocalDateTime operateTime = context.getOperateTime();
        OperateLogAPIDTO dto = context.getLogDTO();
        if (HussarUtils.isEmpty((Object)dto)) {
            return false;
        }
        OperateLog log = OperateLogServiceImpl.getOperateLog(dto, operatorId, operatorName, operateTime);
        return this.save(log);
    }

    @Override
    public Boolean batchRecordOperateLogs(List<OperateLogContext> contexts) {
        if (HussarUtils.isEmpty(contexts)) {
            return false;
        }
        ArrayList<OperateLog> logList = new ArrayList<OperateLog>(contexts.size());
        for (OperateLogContext context : contexts) {
            if (HussarUtils.isEmpty((Object)context.getLogDTO())) continue;
            OperateLog log = OperateLogServiceImpl.getOperateLog(context.getLogDTO(), context.getOperatorId(), context.getOperatorName(), context.getOperateTime());
            logList.add(log);
        }
        return this.saveBatch(logList);
    }

    private static void convertAndSetContentItems(List<OperateLogVO> logs, boolean withBusinessName) {
        if (HussarUtils.isEmpty(logs)) {
            return;
        }
        Consumer<OperateLogVO> contentItemHandler = withBusinessName ? log -> {
            List<JsonItem> items = OperateLogServiceImpl.parseRecordJson(log.getRecordJson());
            String businessName = log.getBusinessName();
            if (HussarUtils.isNotBlank((CharSequence)businessName)) {
                // empty if block
            }
            log.setContentItems(items);
        } : log -> {
            List<JsonItem> items = OperateLogServiceImpl.parseRecordJson(log.getRecordJson());
            log.setContentItems(items);
        };
        for (OperateLogVO log2 : logs) {
            contentItemHandler.accept(log2);
        }
    }

    private static List<JsonItem> parseRecordJson(String jsonStr) {
        if (HussarUtils.isBlank((CharSequence)jsonStr)) {
            return new ArrayList<JsonItem>();
        }
        return JSON.parseArray((String)jsonStr, JsonItem.class);
    }

    private static OperateLog getOperateLog(OperateLogAPIDTO dto, Long operatorId, String operatorName, LocalDateTime operateTime) {
        OperateLog log = new OperateLog();
        log.setBusinessType(dto.getLogType().getBusinessTypeCode());
        log.setOperateType(dto.getLogType().getOperateTypeCode());
        log.setBusinessId(dto.getBusinessId());
        log.setBusinessName(dto.getBusinessName());
        log.setOperator(operatorId);
        log.setOperatorName(operatorName);
        log.setOperateTime(operateTime);
        if (HussarUtils.isNotEmpty(dto.getContentItems())) {
            log.setOperateRecord(JSON.toJSONString(dto.getContentItems()));
        }
        return log;
    }
}

