/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.operatelog.context;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.common.constant.CommonConstant;
import com.jxdinfo.spc.core.operatelog.context.OperateLogContext;
import com.jxdinfo.spc.core.operatelog.dto.OperateLogAPIDTO;
import java.time.LocalDateTime;

public class OperateLogContextBuilder {
    private OperateLogAPIDTO dto;
    private Long operatorId;
    private String operatorName;
    private LocalDateTime operateTime = LocalDateTime.now();

    public static OperateLogContextBuilder create(OperateLogAPIDTO dto) {
        return new OperateLogContextBuilder().dto(dto);
    }

    public OperateLogContextBuilder dto(OperateLogAPIDTO dto) {
        this.dto = dto;
        return this;
    }

    public OperateLogContextBuilder operator(Long id, String name) {
        this.operatorId = id;
        this.operatorName = name;
        return this;
    }

    public OperateLogContextBuilder operateTime(LocalDateTime time) {
        this.operateTime = time;
        return this;
    }

    public OperateLogContext build() {
        if (HussarUtils.isEmpty((Object)this.operatorId) && HussarUtils.isBlank((CharSequence)this.operatorName)) {
            SecurityUser user = BaseSecurityUtil.getUser();
            if (HussarUtils.isNotEmpty((Object)user)) {
                this.operatorId = user.getUserId();
                this.operatorName = user.getUserName();
            } else {
                this.operatorId = CommonConstant.SYS_USE_ID;
                this.operatorName = "\u7cfb\u7edf";
            }
        }
        return new OperateLogContext(this.dto, this.operatorId, this.operatorName, this.operateTime);
    }
}

