/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.common.util;

import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.spc.core.common.dto.TimeBody;
import com.jxdinfo.spc.core.common.vo.DateConvertVo;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;

public class TimeFlagTransferUtil {
    public static TimeBody transfer(TimeBody timeBody) {
        if (timeBody == null) {
            return null;
        }
        String timeFlag = timeBody.getFlag();
        if (StringUtil.isNotEmpty((Object)timeFlag) && !"6".equals(timeFlag)) {
            DateConvertVo dateConvertVo = TimeFlagTransferUtil.getCurrentTime(timeFlag);
            if (dateConvertVo != null && StringUtil.isNotEmpty((Object)dateConvertVo.getStartDate())) {
                timeBody.setStart(LocalDate.parse(dateConvertVo.getStartDate()));
            }
            if (dateConvertVo != null && StringUtil.isNotEmpty((Object)dateConvertVo.getEndDate())) {
                timeBody.setEnd(LocalDate.parse(dateConvertVo.getEndDate()));
            }
        }
        return timeBody;
    }

    public static DateConvertVo getCurrentTime(String timeRange) {
        DateConvertVo dateConvertVo = null;
        if ("1".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getWeekDate();
        } else if ("11".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getLastWeekDate();
        } else if ("8".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getNextWeekDate();
        } else if ("12".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getLastMonthDay();
        } else if ("2".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getMonthDay();
        } else if ("9".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getNextMonthDay();
        } else if ("4".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getYearDay();
        } else if ("7".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getLastYearDay();
        } else if ("5".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getNextYearDay();
        } else if ("13".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getYesterday();
        } else if ("0".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getToday();
        } else if ("3".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getQuarter();
        } else if ("14".equals(timeRange)) {
            dateConvertVo = TimeFlagTransferUtil.getLastQuarter();
        }
        return dateConvertVo;
    }

    public static DateConvertVo initLastBeginEndDateByTimeRange(String timeRange, String hasDay) {
        DateConvertVo dateConvertVo = null;
        switch (timeRange) {
            case "1": {
                if ("1".equals(hasDay)) {
                    dateConvertVo = TimeFlagTransferUtil.getLastWeekTodayDate();
                    break;
                }
                dateConvertVo = TimeFlagTransferUtil.getLastWeekDate();
                break;
            }
            case "11": {
                dateConvertVo = TimeFlagTransferUtil.getLastWeekDate();
                dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
                dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
                break;
            }
            case "2": {
                if ("1".equals(hasDay)) {
                    dateConvertVo = TimeFlagTransferUtil.getLastMonthTodayDay();
                    break;
                }
                dateConvertVo = TimeFlagTransferUtil.getLastMonthDay();
                break;
            }
            case "12": {
                dateConvertVo = TimeFlagTransferUtil.getLastMonthDay();
                dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
                dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
                break;
            }
            case "4": {
                if ("1".equals(hasDay)) {
                    dateConvertVo = TimeFlagTransferUtil.getLastYearTodayDay();
                    break;
                }
                dateConvertVo = TimeFlagTransferUtil.getLastYearDay();
                break;
            }
            case "7": {
                dateConvertVo = TimeFlagTransferUtil.getLastYearDay();
                dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.plusYears((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)-1), (String)"yyyy-MM-dd"));
                dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.plusYears((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)-1), (String)"yyyy-MM-dd"));
                break;
            }
            case "14": {
                dateConvertVo = TimeFlagTransferUtil.getLastQuarter();
                dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)-3), (String)"yyyy-MM-dd"));
                dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)-3), (String)"yyyy-MM-dd"));
            }
        }
        return dateConvertVo;
    }

    private static DateConvertVo getQuarter() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        int quarterFirstMonth = cal.get(2) / 3 * 3;
        cal.set(2, quarterFirstMonth);
        cal.set(5, 1);
        Date sundayDate = cal.getTime();
        String quarterStart = sdf.format(sundayDate);
        cal.add(2, 2);
        cal.set(5, cal.getActualMaximum(5));
        String quarterEnd = sdf.format(cal.getTime());
        return TimeFlagTransferUtil.dateResultMap(quarterStart, quarterEnd);
    }

    private static DateConvertVo getLastQuarter() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        int quarterLastMonth = cal.get(2) / 3 * 3;
        cal.set(2, quarterLastMonth);
        cal.set(5, 0);
        String quarterEnd = sdf.format(cal.getTime());
        int quarterFirstMonth = quarterLastMonth - 3;
        cal.set(2, quarterFirstMonth);
        cal.set(5, 1);
        String quarterStart = sdf.format(cal.getTime());
        return TimeFlagTransferUtil.dateResultMap(quarterStart, quarterEnd);
    }

    public static DateConvertVo getWeekDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        cal.add(5, 4 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        return TimeFlagTransferUtil.dateResultMap(weekBegin, weekEnd);
    }

    public static DateConvertVo getLastWeekDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        cal.add(5, 4 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        return TimeFlagTransferUtil.dateResultMap(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekBegin, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getLastWeekTodayDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        return TimeFlagTransferUtil.dateResultMap(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekBegin, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getNextWeekDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        cal.add(5, 4 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        return TimeFlagTransferUtil.dateResultMap(DateUtil.format((Date)DateUtil.plusWeeks((Date)DateUtil.parse((String)weekBegin, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.plusWeeks((Date)DateUtil.parse((String)weekEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getMonthDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String monthEnd = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(monthStart, monthEnd);
    }

    public static DateConvertVo getLastMonthDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String monthEnd = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthStart, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getLastMonthTodayDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        String monthEnd = format.format(cale.getTime());
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthStart, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getNextMonthDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String monthEnd = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(DateUtil.format((Date)DateUtil.plusMonths((Date)DateUtil.parse((String)monthStart, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.plusMonths((Date)DateUtil.parse((String)monthEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getYearDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, 0);
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        cale.add(1, 1);
        cale.set(6, 0);
        String yearEnd = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getNextYearDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, 1);
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        cale.add(1, 1);
        cale.set(6, 0);
        String yearEnd = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getLastYearDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, -1);
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        cale.add(1, 1);
        cale.set(6, 0);
        String yearEnd = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getLastYearTodayDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, -1);
        String yearEnd = format.format(cale.getTime());
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getYesterday() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, -1);
        String yesterday = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(yesterday, yesterday);
    }

    public static DateConvertVo getToday() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, 0);
        String today = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(today, today);
    }

    public static DateConvertVo getBeginANdEndTimeOfToday() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, 0);
        String today = format.format(cale.getTime());
        cale.add(5, 1);
        String tomorrow = format.format(cale.getTime());
        return TimeFlagTransferUtil.dateResultMap(today, tomorrow);
    }

    private static DateConvertVo dateResultMap(String startDate, String endDate) {
        DateConvertVo date = new DateConvertVo();
        date.setStartDate(startDate);
        date.setEndDate(endDate);
        return date;
    }
}

