/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.baseManage.judgmentRuleManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.dao.JudgmentRuleMapper;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.dto.JudgmentRuleDto;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.model.JudgmentRule;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.model.JudgmentRuleDict;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.service.JudgmentRuleDictService;
import com.jxdinfo.spc.core.baseManage.judgmentRuleManage.service.JudgmentRuleService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="baseMange.judgmentRuleManage.JudgmentRuleServiceImpl")
public class JudgmentRuleServiceImpl
extends ServiceImpl<JudgmentRuleMapper, JudgmentRule>
implements JudgmentRuleService {
    @Autowired
    private JudgmentRuleMapper judgmentRuleMapper;
    @Resource
    private JudgmentRuleDictService judgmentRuleDictService;

    @Override
    @HussarTransactional
    public ApiResponse saveRule(JudgmentRuleDto dto) {
        this.remove((Wrapper)new LambdaQueryWrapper().eq(JudgmentRule::getGroupId, (Object)dto.getGroupId()));
        if (!dto.getRuleList().isEmpty()) {
            dto.getRuleList().forEach(rule -> {
                rule.setCreateTime(LocalDateTime.now());
                rule.setCreatorName(BaseSecurityUtil.getUser().getUserName());
                rule.setCreator(BaseSecurityUtil.getUser().getUserId());
            });
            this.saveBatch(dto.getRuleList());
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public List<JudgmentRule> queryList(Long groupId) {
        return this.list((Wrapper)new LambdaQueryWrapper().eq(JudgmentRule::getGroupId, (Object)groupId));
    }

    @Override
    public List<JudgmentRule> queryDefaultList(Long groupId) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(JudgmentRule::getGroupId, (Object)groupId));
        List dictIdList = list.stream().map(JudgmentRule::getRuleDictId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(dictIdList) && dictIdList.size() > 0) {
            List dictList = this.judgmentRuleDictService.list((Wrapper)new LambdaQueryWrapper().in(JudgmentRuleDict::getRuleDictId, dictIdList));
            list.forEach(rule -> dictList.forEach(dict -> {
                if (rule.getRuleDictId().equals(dict.getRuleDictId())) {
                    rule.setkValue(dict.getkValue());
                    rule.setmValue(dict.getmValue());
                    rule.setlValue(dict.getlValue());
                }
            }));
            return list;
        }
        return null;
    }
}

