/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.baseManage.controlProjectManage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.spc.adapter.api.dict.service.IDictAPIService;
import com.jxdinfo.spc.adapter.api.dict.vo.DictApiVo;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AnalysisInfoEntity;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.IAnalysisInfoService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dao.ControlProjectMapper;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dto.ControlProjectDto;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dto.ControlProjectImportDto;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.dto.ControlProjectPageDto;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.model.ControlProject;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.model.ControlProjectType;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.service.ControlProjectService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.service.ControlProjectTypeService;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.util.ReadControlProjectExcelUtil;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.vo.ControlProjectVo;
import com.jxdinfo.spc.core.baseManage.controlProjectManage.vo.ImportResultVo;
import com.jxdinfo.spc.core.common.util.CommonUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="baseMange.controlProjectManage.SpcControlProjectServiceImpl")
public class ControlProjectServiceImpl
extends ServiceImpl<ControlProjectMapper, ControlProject>
implements ControlProjectService {
    @Autowired
    private ControlProjectMapper controlProjectMapper;
    @Resource
    private ControlProjectTypeService controlProjectTypeService;
    @Resource
    private IAnalysisInfoService iAnalysisInfoService;
    @Resource
    private IDictAPIService dictApiService;

    @Override
    public Long saveControlProject(ControlProjectDto dto) {
        ControlProject controlProject = (ControlProject)((Object)BeanUtil.copy((Object)((Object)dto), ControlProject.class));
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long controlProjectId = controlProject.getControlProjectId();
        if (HussarUtils.isEmpty((Object)controlProjectId)) {
            controlProject.setCreateTime(date);
            controlProject.setCreator(user.getUserId());
            controlProject.setCreatorName(user.getUserName());
        } else {
            controlProject.setLastEditor(user.getUserId());
            controlProject.setLastEditorName(user.getUserName());
            controlProject.setLastTime(date);
        }
        this.saveOrUpdate((Object)controlProject);
        return controlProject.getControlProjectId();
    }

    @Override
    public ControlProject detail(Long controlProjectId) {
        return (ControlProject)((Object)this.getById(controlProjectId));
    }

    @Override
    public ApiResponse delete(ControlProjectDto dto) {
        long count = this.iAnalysisInfoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(AnalysisInfoEntity.class).eq(AnalysisInfoEntity::getControlProjectId, (Object)dto.getControlProjectId())).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        if (count > 0L) {
            return ApiResponse.fail((String)"\u8be5\u63a7\u5236\u9879\u76ee\u5df2\u5173\u8054\u8d28\u63a7\u5206\u6790\u56fe\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.removeById(dto.getControlProjectId());
        return ApiResponse.success();
    }

    @Override
    public Page<ControlProjectVo> queryPage(ControlProjectPageDto dto) {
        Page page = dto.getPage();
        if (HussarUtils.isNotEmpty((Object)dto.getControlProjectName())) {
            dto.setControlProjectName(dto.getControlProjectName().replaceAll("/", "//").replaceAll("%", "/%").replaceAll("_", "/_").replaceAll("\\[", "/[").replaceAll("]", "/]"));
        }
        List<ControlProjectVo> list = this.controlProjectMapper.queryPage(page, dto);
        page.setRecords(list);
        return page;
    }

    @Override
    public ApiResponse updateType(ControlProjectDto controlProjectDto) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(ControlProject::getControlProjectId, controlProjectDto.getControlProjectIdList())).set(ControlProject::getTypeId, (Object)controlProjectDto.getTypeId()));
        return ApiResponse.success();
    }

    @Override
    public void downLoadTemplate(HttpServletResponse response) {
        ClassPathResource resource = new ClassPathResource("template/\u63a7\u5236\u9879\u76ee\u5bfc\u5165\u6a21\u677f.xlsx");
        try (InputStream in = resource.getInputStream();
             ServletOutputStream out = response.getOutputStream();){
            int len;
            if (!resource.exists()) {
                response.sendError(404, "\u63a7\u5236\u9879\u76ee\u5bfc\u5165\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728");
                return;
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u63a7\u5236\u9879\u76ee\u5bfc\u5165\u6a21\u677f", StandardCharsets.UTF_8.name()).replaceAll("\\+", "%20");
            response.setHeader("Content-Disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            response.setContentLengthLong(resource.contentLength());
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            throw new BaseException("\u63a7\u5236\u9879\u76ee\u5bfc\u5165\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            throw new BaseException("\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\uff08IO\u9519\u8bef\uff09\uff1a" + e.getMessage());
        }
        catch (Exception e) {
            throw new BaseException("\u6a21\u677f\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<ImportResultVo> importExcel(MultipartFile file) {
        ImportResultVo importResultVo = new ImportResultVo();
        ArrayList<ControlProject> controlProjectList = new ArrayList<ControlProject>();
        ArrayList<ControlProjectType> addTypeList = new ArrayList<ControlProjectType>();
        try {
            List<ControlProjectImportDto> list = ReadControlProjectExcelUtil.getExcelInfo(file);
            if (CollectionUtil.isNotEmpty(list)) {
                List featureTypeDictList = this.dictApiService.getDictList("feature_type");
                Map<String, String> featureTypeDictMap = featureTypeDictList.stream().collect(Collectors.toMap(DictApiVo::getLabel, DictApiVo::getValue));
                List chartTypeDictList = this.dictApiService.getDictList("control_chart_type");
                Map<String, String> chartTypeDictMap = chartTypeDictList.stream().collect(Collectors.toMap(DictApiVo::getLabel, DictApiVo::getValue));
                List typeList = this.controlProjectTypeService.list((Wrapper)new LambdaQueryWrapper());
                Map<String, ControlProjectType> typePathMap = typeList.stream().collect(Collectors.toMap(ControlProjectType::getTypeNamePath, item -> item));
                Map<Long, ControlProjectType> typeIdMap = typeList.stream().collect(Collectors.toMap(ControlProjectType::getTypeId, item -> item));
                for (int x = 0; x < list.size(); ++x) {
                    ControlProjectImportDto dto = list.get(x);
                    ControlProject controlProject = new ControlProject();
                    controlProject.setCreateTime(LocalDateTime.now());
                    controlProject.setCreator(BaseSecurityUtil.getUser().getUserId());
                    controlProject.setCreatorName(BaseSecurityUtil.getUser().getUserName());
                    controlProject.setControlProjectName(dto.getControlProjectName());
                    if (HussarUtils.isNotEmpty(chartTypeDictMap) && HussarUtils.isNotEmpty((Object)chartTypeDictMap.get(dto.getDataTypeName()))) {
                        controlProject.setDataType(chartTypeDictMap.get(dto.getDataTypeName()));
                    }
                    if (HussarUtils.isNotEmpty(featureTypeDictMap) && HussarUtils.isNotEmpty((Object)featureTypeDictMap.get(dto.getFeatureTypeName()))) {
                        controlProject.setFeatureType(featureTypeDictMap.get(dto.getFeatureTypeName()));
                    }
                    if (HussarUtils.isNotEmpty(chartTypeDictMap) && HussarUtils.isNotEmpty((Object)chartTypeDictMap.get(dto.getChartTypeName()))) {
                        controlProject.setChartType(chartTypeDictMap.get(dto.getChartTypeName()));
                    }
                    controlProject.setUsl(dto.getUsl());
                    controlProject.setSl(dto.getSl());
                    controlProject.setLsl(dto.getLsl());
                    if ("xmr".equals(controlProject.getChartType()) && dto.getSubgroupSize() != 1) {
                        throw new IllegalArgumentException("\u7b2c" + (x + 1) + "\u884c\u6570\u636e\u9519\u8bef\uff1aX-MR\u56fe\u5b50\u7ec4\u5bb9\u91cf\u5fc5\u987b\u4e3a1");
                    }
                    controlProject.setSubgroupSize(dto.getSubgroupSize());
                    String[] levelArr = new String[]{dto.getOneLevelType(), dto.getTwoLevelType(), dto.getThreeLevelType(), dto.getFourLevelType(), dto.getFiveLevelType()};
                    String typePath = "";
                    for (String level : levelArr) {
                        if (!HussarUtils.isNotEmpty((Object)level)) break;
                        typePath = typePath + level + "/";
                    }
                    String isExistTypePath = "";
                    String isNotExistTypePath = "";
                    if (typePathMap.containsKey(typePath.substring(0, typePath.length() - 1))) {
                        controlProject.setTypeId(typePathMap.get(typePath.substring(0, typePath.length() - 1)).getTypeId());
                    } else {
                        String[] parts = typePath.split("/");
                        StringBuilder existingPath = new StringBuilder();
                        for (int i = 0; i < parts.length; ++i) {
                            existingPath.append(parts[i]).append("/");
                            String existingPathStr = existingPath.toString();
                            if (typePathMap.containsKey(existingPathStr.substring(0, existingPathStr.length() - 1))) continue;
                            if (i > 0) {
                                isExistTypePath = String.join((CharSequence)"/", Arrays.copyOfRange(parts, 0, i));
                            }
                            isNotExistTypePath = String.join((CharSequence)"/", Arrays.copyOfRange(parts, i, parts.length));
                            break;
                        }
                        Long lastTypeId = null;
                        if (HussarUtils.isNotEmpty((Object)isNotExistTypePath)) {
                            List<String> isNotExistTypePathList = Arrays.asList(isNotExistTypePath.split("/"));
                            if (HussarUtils.isEmpty((Object)isExistTypePath)) {
                                lastTypeId = this.createSpcControlProjectType(isNotExistTypePathList, typeIdMap, null, null, 0, addTypeList, typePathMap);
                            } else {
                                ControlProjectType parentType = typePathMap.get(isExistTypePath);
                                lastTypeId = this.createSpcControlProjectType(isNotExistTypePathList, typeIdMap, parentType, parentType.getTypeId(), 0, addTypeList, typePathMap);
                            }
                        }
                        controlProject.setTypeId(lastTypeId);
                    }
                    controlProjectList.add(controlProject);
                }
                this.controlProjectTypeService.saveBatch(addTypeList);
                this.saveBatch(controlProjectList);
                importResultVo.setControlProjectNum(controlProjectList.size());
                importResultVo.setControlProjectTypeNum(addTypeList.size());
                return ApiResponse.success((Object)importResultVo);
            }
            throw new IllegalArgumentException("\u65e0\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u6587\u4ef6\uff01");
        }
        catch (IllegalArgumentException e) {
            return ApiResponse.fail((String)e.getMessage());
        }
        catch (Exception e) {
            return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
    }

    @Override
    public List<ControlProjectVo> queryList(ControlProjectPageDto dto) {
        return this.controlProjectMapper.queryList(dto);
    }

    private Long createSpcControlProjectType(List<String> isNotExistTypePathList, Map<Long, ControlProjectType> typeIdMap, ControlProjectType controlProjectType, Long parentTypeId, int level, List<ControlProjectType> addTypeList, Map<String, ControlProjectType> typePathMap) {
        if (level > isNotExistTypePathList.size() - 1) {
            return parentTypeId;
        }
        ControlProjectType createType = new ControlProjectType();
        Long LastTypeId = Long.valueOf(CommonUtils.generateAssignId());
        if (parentTypeId == null) {
            createType.setTypeLevel(1);
            createType.setTypeName(isNotExistTypePathList.get(0));
            createType.setTypeNamePath(isNotExistTypePathList.get(0));
            createType.setTypePath(LastTypeId.toString());
            createType.setTypeId(LastTypeId);
        } else {
            if (HussarUtils.isEmpty((Object)((Object)controlProjectType))) {
                controlProjectType = typeIdMap.get(parentTypeId);
            }
            createType.setTypeLevel(controlProjectType.getTypeLevel() + 1);
            createType.setTypeNamePath(controlProjectType.getTypeNamePath() + "/" + isNotExistTypePathList.get(level));
            createType.setParentId(controlProjectType.getTypeId() == null ? parentTypeId : controlProjectType.getTypeId());
            createType.setTypePath(controlProjectType.getTypePath() + "/" + LastTypeId);
            createType.setTypeId(LastTypeId);
            createType.setTypeName(isNotExistTypePathList.get(level));
        }
        createType.setCreatorName(BaseSecurityUtil.getUser().getUserName());
        createType.setCreator(BaseSecurityUtil.getUser().getUserId());
        createType.setCreateTime(LocalDateTime.now());
        if (!typePathMap.containsKey(createType.getTypeNamePath())) {
            addTypeList.add(createType);
            typePathMap.put(createType.getTypeNamePath(), createType);
            typeIdMap.put(createType.getTypeId(), createType);
            controlProjectType = createType;
        } else {
            controlProjectType = typePathMap.get(createType.getTypeNamePath());
        }
        return this.createSpcControlProjectType(isNotExistTypePathList, typeIdMap, controlProjectType, controlProjectType.getTypeId(), level + 1, addTypeList, typePathMap);
    }
}

