/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.strategy;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.AbnormalData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.entity.ChartStatistic;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.ControlChartStrategy;
import com.jxdinfo.spc.core.analysisManage.analysisTool.vo.ControlChartDataVO;
import com.jxdinfo.spc.formula.api.util.aviator.Calc;
import com.jxdinfo.spc.formula.api.util.counting.PChartUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PChartStrategy
extends ControlChartStrategy {
    @Override
    public void dataCheck() {
        List<List<Integer>> failList = this.getFailNodeGroupList();
        List<List<Integer>> detectList = this.getDetectNodeGroupList();
        if (failList.get(0).size() != 1 || detectList.get(0).size() != 1) {
            throw new RuntimeException("P\u56fe\u5e94\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u5b50\u7ec4\uff01");
        }
    }

    @Override
    public void generateControlData(AnalysisResultVO analysisResultVO) {
        BigDecimal detectNum;
        ArrayList<ControlData> controlDataList = new ArrayList<ControlData>();
        AnalysisParamDto param = this.getAnalysisParam();
        List<Integer> failList = this.getFailNodeList();
        List<Integer> detectList = this.getDetectNodeList();
        boolean flag = this.areAllElementsSame(detectList);
        if (!flag) {
            BigDecimal sum = BigDecimal.ZERO;
            int size = detectList.size();
            for (Integer num : detectList) {
                sum = sum.add(BigDecimal.valueOf(num.intValue()));
            }
            detectNum = sum.divide(BigDecimal.valueOf(size), MathContext.DECIMAL128);
        } else {
            detectNum = BigDecimal.valueOf(detectList.get(0).intValue());
        }
        BigDecimal cl = !HussarUtils.isEmpty((Object)param.getCl()) ? Calc.getBigDecimal((Object)param.getCl()) : PChartUtils.calculatePBar(failList, detectList);
        BigDecimal sigma = PChartUtils.calculateSigmaList((BigDecimal)cl, (BigDecimal)detectNum);
        BigDecimal ucl = !HussarUtils.isEmpty((Object)param.getUcl()) ? Calc.getBigDecimal((Object)param.getUcl()) : PChartUtils.calculateUCLList((BigDecimal)cl, (BigDecimal)sigma);
        BigDecimal lcl = !HussarUtils.isEmpty((Object)param.getLcl()) ? Calc.getBigDecimal((Object)param.getLcl()) : PChartUtils.calculateLCLList((BigDecimal)cl, (BigDecimal)sigma);
        BigDecimal uclDecimal = Calc.tidyDecimal((BigDecimal)ucl, (Integer)param.getDecimalNum(), (Boolean)true);
        BigDecimal lclDecimal = Calc.tidyDecimal((BigDecimal)lcl, (Integer)param.getDecimalNum(), (Boolean)true);
        BigDecimal clDecimal = Calc.tidyDecimal((BigDecimal)cl, (Integer)param.getDecimalNum(), (Boolean)true);
        ControlChartDataVO controlChartDataVO = new ControlChartDataVO();
        controlChartDataVO.setCl(clDecimal.toPlainString());
        controlChartDataVO.setSigma(Calc.tidyDecimal((BigDecimal)sigma, (Integer)param.getDecimalNum(), (Boolean)true).toPlainString());
        controlChartDataVO.setUcl(uclDecimal.toPlainString());
        controlChartDataVO.setLcl(lclDecimal.toPlainString());
        List<BigDecimal> pList = this.countingChartAnalysis(failList, detectList, param);
        List<ChartStatistic> pStatisticList = this.generateData(pList, param, cl.toPlainString(), sigma.toPlainString());
        ControlData pControlData = this.generateControlData("8", pStatisticList, uclDecimal.toPlainString(), clDecimal.toPlainString(), lclDecimal.toPlainString());
        ArrayList<AbnormalData> allAbnormalDataList = new ArrayList<AbnormalData>();
        List<AbnormalData> pAnalysisDataSourceList = this.generateAbnormalDataSource(pStatisticList, uclDecimal.toPlainString(), lclDecimal.toPlainString(), clDecimal.toPlainString(), "8");
        if (HussarUtils.isNotEmpty(pAnalysisDataSourceList)) {
            allAbnormalDataList.addAll(pAnalysisDataSourceList);
            analysisResultVO.setAbnormalData(allAbnormalDataList);
        }
        controlDataList.add(pControlData);
        analysisResultVO.setControlChartDataVO(controlChartDataVO);
        analysisResultVO.setControlData(controlDataList);
    }
}

