/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.patterns;

import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.Pattern;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalAnalysis;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalJudgmentFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisFunction;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisUtils;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.dto.AbnormalPatternDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedDeque;

public class Pattern12
extends Pattern {
    @Override
    public AbnormalAnalysis getAnalysis(AbnormalPatternDto dto) {
        String kValue = this.getParam(dto, "pattern12", "kValue", "10");
        String lValue = this.getParam(dto, "pattern12", "lValue", "30");
        if (!this.checkPositiveNumber(lValue, false)) {
            throw new HussarException("\u5224\u5f02\u51c6\u521912\uff1aL\u503c\u5fc5\u987b\u4e3a\u6b63\u6570\uff08\u5f53\u524d\u503c\uff1a" + lValue + "\uff09");
        }
        int k = (int)Math.floor(Double.parseDouble(kValue));
        double l = Double.parseDouble(lValue) / 100.0;
        BigDecimal t = dto.getT();
        if (t == null) {
            return new AbnormalAnalysis((nodes, index, buffer) -> Collections.emptyList(), AbnormalJudgmentFunction::commonJudge);
        }
        BigDecimal offsetThreshold = t.multiply(BigDecimal.valueOf(2L)).multiply(BigDecimal.valueOf(l));
        ConcurrentLinkedDeque window = new ConcurrentLinkedDeque();
        AnalysisFunction analysisFunc = (nodes, index, buffer) -> {
            AnalysisNode current = (AnalysisNode)nodes.get(index);
            window.addLast(current);
            if (window.size() > k) {
                window.removeFirst();
            }
            if (window.size() == k) {
                BigDecimal windowMean = AnalysisUtils.calculateWindowMean(new ArrayList<AnalysisNode>(window));
                BigDecimal cl = dto.getCl();
                if (cl == null) {
                    return Collections.emptyList();
                }
                BigDecimal offset = windowMean.subtract(cl).abs();
                if (offset.compareTo(offsetThreshold) > 0) {
                    current.addTag("pattern12", "12");
                    return Collections.singletonList(current);
                }
            }
            return Collections.emptyList();
        };
        return new AbnormalAnalysis(analysisFunc, AbnormalJudgmentFunction::commonJudge);
    }
}

