/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis;

import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

public class AnalysisUtils {
    public static BigDecimal upperBound(BigDecimal cl, BigDecimal sigma, double k) {
        if (cl == null || sigma == null) {
            return null;
        }
        return cl.add(sigma.multiply(BigDecimal.valueOf(k)));
    }

    public static BigDecimal lowerBound(BigDecimal cl, BigDecimal sigma, double k) {
        if (cl == null || sigma == null) {
            return null;
        }
        return cl.subtract(sigma.multiply(BigDecimal.valueOf(k)));
    }

    public static boolean isAboveCl(AnalysisNode node, BigDecimal cl) {
        Objects.requireNonNull(node, "\u8282\u70b9\u4e0d\u80fd\u4e3anull");
        return cl != null && node.getValue().compareTo(cl) > 0;
    }

    public static boolean isBelowCl(AnalysisNode node, BigDecimal cl) {
        Objects.requireNonNull(node, "\u8282\u70b9\u4e0d\u80fd\u4e3anull");
        return cl != null && node.getValue().compareTo(cl) < 0;
    }

    public static BigDecimal calculateWindowMean(List<AnalysisNode> window) {
        if (window.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = window.stream().map(AnalysisNode::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.divide(new BigDecimal(window.size()), 6, 4);
    }
}

