/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis;

import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AbnormalAnalysis;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.analysis.AnalysisNode;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.dto.AbnormalPatternDto;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.entity.PatternEntity;
import com.jxdinfo.spc.core.analysisManage.analysisTool.abnormalanalysis.entity.PatternParam;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Pattern {
    private static final Map<String, Pattern> PATTERN_MAP;

    private static String extractPatternName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        if (className.startsWith("Pattern") && className.length() > 7) {
            try {
                String numStr = className.substring(7);
                Integer.parseInt(numStr);
                return "pattern" + numStr.toLowerCase();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public abstract AbnormalAnalysis getAnalysis(AbnormalPatternDto var1);

    protected boolean checkPositiveNumber(String numStr, boolean isInteger) {
        if (numStr == null || numStr.trim().isEmpty()) {
            return false;
        }
        try {
            double value = Double.parseDouble(numStr);
            if (value <= 0.0) {
                return false;
            }
            return !isInteger || value % 1.0 == 0.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected String getParam(AbnormalPatternDto dto, String patternName, String paramName, String defaultValue) {
        if (dto == null || dto.getPatternList() == null) {
            return defaultValue;
        }
        return dto.getPatternList().stream().filter(pattern -> Objects.equals(patternName, pattern.getName())).flatMap(pattern -> {
            List<PatternParam> params = pattern.getParams();
            return params != null ? params.stream() : Stream.empty();
        }).filter(param -> Objects.equals(paramName, param.getName())).findFirst().map(param -> {
            Object paramValue = param.getValue();
            return paramValue != null ? paramValue.toString() : defaultValue;
        }).orElse(defaultValue);
    }

    public static Map<String, Integer> analyze(AbnormalPatternDto dto, List<AnalysisNode> nodes) {
        List validPatterns = dto.getPatternList().stream().filter(pattern -> PATTERN_MAP.containsKey(pattern.getName())).collect(Collectors.toList());
        boolean useParallel = validPatterns.size() > 5 && nodes.size() > 1000;
        Stream patternStream = useParallel ? (Stream)validPatterns.stream().parallel() : validPatterns.stream();
        return patternStream.collect(Collectors.toMap(PatternEntity::getName, pattern -> {
            try {
                Pattern instance = PATTERN_MAP.get(pattern.getName());
                AbnormalAnalysis analysis = instance.getAnalysis(dto);
                analysis.analyze(nodes);
                return analysis.getAbnormalEventCount();
            }
            catch (Exception e) {
                return -1;
            }
        }, (v1, v2) -> v1, LinkedHashMap::new));
    }

    static {
        ConcurrentHashMap<String, Pattern> tempMap = new ConcurrentHashMap<String, Pattern>();
        ServiceLoader<Pattern> serviceLoader = ServiceLoader.load(Pattern.class);
        for (Pattern pattern : serviceLoader) {
            String patternName = Pattern.extractPatternName(pattern.getClass());
            if (patternName == null || tempMap.containsKey(patternName)) continue;
            tempMap.put(patternName, pattern);
        }
        PATTERN_MAP = Collections.unmodifiableMap(tempMap);
    }
}

