/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.spc.core.analysisManage.analysisInfo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dao.ControlDataMapper;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.dto.AnalysisParamDto;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.model.ControlData;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.service.ControlDataService;
import com.jxdinfo.spc.core.analysisManage.analysisInfo.vo.AnalysisResultVO;
import com.jxdinfo.spc.core.analysisManage.analysisTool.factory.ChartStrategyFactory;
import com.jxdinfo.spc.core.analysisManage.analysisTool.strategy.ControlChartStrategy;
import com.jxdinfo.spc.core.baseManage.coefficient.model.ControlCoefficient;
import com.jxdinfo.spc.core.baseManage.coefficient.service.ControlCoefficientService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ControlDataServiceImpl
extends ServiceImpl<ControlDataMapper, ControlData>
implements ControlDataService {
    @Resource
    private ControlDataMapper controlDataMapper;
    @Resource
    private ControlCoefficientService controlCoefficientService;
    @Resource
    private ChartStrategyFactory chartStrategyFactory;
    private final Map<String, ControlCoefficient> localCache = new HashMap<String, ControlCoefficient>(25);
    private static final String CACHE_KEY_CONTROL_COEFFICIENT = "spc_controlCoefficient_";
    private static final String SUBGROUP_SIZE_TWO = "2";

    @Override
    @HussarTransactional
    public AnalysisResultVO chartAnalysis(AnalysisParamDto analysisParam) {
        ControlCoefficient controlCoefficient;
        String subgroupSize = analysisParam.getSubgroupSize();
        if ("xmr".equals(analysisParam.getChartType())) {
            subgroupSize = SUBGROUP_SIZE_TWO;
        }
        if (this.localCache.containsKey(subgroupSize)) {
            controlCoefficient = this.localCache.get(subgroupSize);
        } else {
            String controlCoefficientJson = (String)DefaultCacheUtil.get((Object)(CACHE_KEY_CONTROL_COEFFICIENT + subgroupSize));
            if (HussarUtils.isNotEmpty((Object)controlCoefficientJson)) {
                controlCoefficient = (ControlCoefficient)JSONObject.parseObject((String)controlCoefficientJson, ControlCoefficient.class);
                this.localCache.put(subgroupSize, controlCoefficient);
            } else {
                controlCoefficient = this.controlCoefficientService.getCoefficientMap(subgroupSize);
                DefaultCacheUtil.put((Object)(CACHE_KEY_CONTROL_COEFFICIENT + subgroupSize), (Object)JSONObject.toJSONString((Object)controlCoefficient));
                this.localCache.put(subgroupSize, controlCoefficient);
            }
        }
        analysisParam.setControlCoefficient(controlCoefficient);
        ControlChartStrategy chartStrategy = this.chartStrategyFactory.createStrategy(analysisParam.getChartType());
        if (chartStrategy == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7b56\u7565\uff01");
        }
        try {
            AnalysisResultVO analysisResultVO = new AnalysisResultVO();
            chartStrategy.handleBasicCalculationData(analysisParam);
            chartStrategy.dataCheck();
            chartStrategy.generateControlData(analysisResultVO);
            if ("0".equals(analysisParam.getDataType())) {
                chartStrategy.generateProcessCapability(analysisResultVO);
                chartStrategy.generateFittingNormalChart(analysisResultVO);
            } else if ("p".equals(analysisParam.getChartType())) {
                chartStrategy.generateBinomialChart(analysisResultVO);
            }
            chartStrategy.generateBoxplot(analysisResultVO);
            AnalysisResultVO analysisResultVO2 = analysisResultVO;
            return analysisResultVO2;
        }
        catch (HussarException e) {
            throw new HussarException(e.getMessage());
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            chartStrategy.clearThreadLocal();
        }
    }
}

